***************************************************************************
**  Property of Texas Instruments Incorporated                            *
**                                                                        *
**  Unauthorized reproduction and/or distribution is strictly             *
**  prohibited.  (C) Copyright 1995 Texas Instruments Incorporated.       *
**  All rights reserved.                                                  *
**                                                                        *
**  These commodities, technical data, and software may be U.S. export    *
**  license controlled.  As such, prior to export or re-export, U.S.      *
**  Government approval and authorization may be required.                *
**                                                                        *
**  PLEASE BE AWARE THAT IN THE ABSENCE OF A SIGNED, WRITTEN AGREEMENT    *
**  TO THE CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
**  MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR IMPLIED.        *
**  Further, TI assumes no liability for: 1) the accuracy of the SPICE    *
**  models provided to your company; 2) the proper functioning of these   *
**  SPICE models in your design or for any resulting applications;  or    *
**  3) infringement of patents, copyrights or intellectual property       *
**  rights resulting from your use of these SPICE models.                 *
**                                                                        *
**  TI provides SPICE models as a service to our customers.  You and      *
**  your company shall not distribute, convey, sell or give these         *
**  models to anyone else without receiving prior written permission      *
**  from TI.                                                              *
**                                                                        *
**  TI reserves the right to make changes to its products or to           *
**  discontinue any semiconductor product or service without notice,      *
**  and advises its customers to obtain the latest version of relevant    *
**  information to verify, before placing orders, that the information    *
**  being relied on is current.                                           *
**                                                                        *
**  Please be aware that your receipt and subsequent use of the SPICE     *
**  information provided shall serve as acceptance of the terms and       *
**  conditions of this agreement.  If you do not accept these terms,      *
**  you should return the SPICE model and any other accompanying          *
**  information immediately.                                              *
***************************************************************************
**CDC536 SPICE I/O Model
**Advanced System Logic, Texas Instruments
****************************************************************
*
*NOTE:
*   The following files must be present to use this SPICE model:
*      536.CDC                  (netlist)
*      EPIC2B.LIB               (Library file for process models)
*      EPIC2BN.13               (Nominal process models, CMOS Level 13)
*      EPIC2BS.13               (Strong  process models, CMOS Level 13)
*      EPIC2BW.13               (Weak    process models, CMOS Level 13)
*      EPIC2BN.3                (Nominal process models, CMOS Level 3)
*      EPIC2BS.3                (Strong  process models, CMOS Level 3)
*      EPIC2BW.3                (Weak    process models, CMOS Level 3)
*      PKGS.LIB                 (Library file for packages)
*      SSOP28.PKG               (Package parasitics)
*      READ.ME                  (General use, release notes, ...)
*
*INSTRUCTIONS:
*   To use this SPICE model, include the following lines in your main netlist:
*      .
*      .
*      .
*      .INCLUDE '536.CDC'
*      XCDC536_IN    1     2                 199   100         CDC536IN
*      XCDC536_OUT   4     5     6           199   100         CDC536OUT
*      .
*      .
*      .
*
*   The diagrams below describe the nodes for the subcircuits:
*
*                                                   /|\
*                                                    |
*                                                    |
*                      ----                      Node 199(VCC)
*                     |    \                     Node 100(GND)
*       Node 1  ______|     \___  Node 2             |
*                     |     /                        |
*                     |    /                        ---
*                      ----                          -
*
*               CDC536IN(Input Buffer)
* 
*
*                      | Node 6                     /|\
*                      |                             |
*                      O                             |
*                     ----                       Node 199(VCC)
*                    /    |                      Node 100(GND)
*      Node 5  _____/     |___  Node 4               |
*                   \     |                          |
*                    \    |                         ---
*                     ----                           -
*
*               CDC536OUT(Output Buffer)
*
*       
*   Please refer to the 'READ.ME' file for general instructions for use.
*
*    CDC536 SPICE I/O MODEL SUBCIRCUIT
*    
*    ADVANCED SYSTEM LOGIC, TEXAS INSTRUMENTS
*
*    SUBCIRCUITS:  CDC536IN, CDC536OUT
*
*    PACKAGE PARASITICS
        .LIB 'PKGS.LIB'   SSOP28
*
*    PROCESS MODELS 
        .LIB 'EPIC2B.LIB' NOMINAL_L13
*       .LIB 'EPIC2B.LIB' STRONG_L13
*       .LIB 'EPIC2B.LIB' WEAK_L13
*
* CDC536 INPUT SUBCIRCUIT
*    NODES:        INPUT NODE
*                  |     INTERNAL OUTPUT NODE
*                  |     |     VCC
*                  |     |     |     GND
*                  |     |     |     |    
.SUBCKT CDC536IN   1     2     199   100
 X_PKGIN           1     1001                    SSOP28_03
 X_PKGVCC          199   1199                    SSOP28_08
 X_PKGGND          100   1100                    SSOP28_06
 XCDC536IN         1001  2     1199  1100        CDC536__IN
.ENDS CDC536IN
*                         
* CDC536 OUTPUT SUBCIRCUIT   
*    NODES:        INTERNAL INPUT NODE
*                  |     OUTPUT NODE
*                  |     |     INTERNAL OE NODE
*                  |     |     |     VCC
*                  |     |     |     |     GND
*                  |     |     |     |     |
.SUBCKT CDC536OUT  4     5     6     199   100  
 X_PKGOUT          5     1005                    SSOP28_07
 X_PKGVCC          199   1199                    SSOP28_06
 X_PKGGND          100   1100                    SSOP28_08
 XCDC536OUT        4     1005  6     1199  1100  CDC536__OUT
.ENDS CDC536OUT
*
.SUBCKT CDC536__IN       551   552   599   500
 X_ESDA      551   501   599   500   ESD
 XINV1       501   502   599   500   INV         WPI=35U     WNI=20U
 XINV2       502   552   599   500   INV         WPI=50U     WNI=20U
.ENDS CDC536__IN
*
.SUBCKT CDC536__OUT      551   552   553   599   500      
 XP1         514   513   599   599   PM          WP=350U     LP=0.8U
 XP3         514   503   599   599   PM          WP=350U     LP=0.8U
 XP5         506   517   599   599   PM          WP=140U     LP=0.8U
 XP6         504   503   506   599   PM          WP=140U     LP=0.8U
 XPOUT       552   514   599   599   PM          WP=1300U    LP=0.8U
 XN1         514   503   516   500   NM          WN=160U     LN=0.8U 
 XN3         516   513   500   500   NM          WN=160U     LN=0.8U 
 XN5         504   503   500   500   NM          WN=160U     LN=0.8U 
 XN6         504   517   500   500   NM          WN=160U     LN=0.8U 
 XNOUT       505   504   500   500   NM          WN=1300U    LN=0.8U 
 XINV1       551   502   599   500   INV         WPI=100U    WNI=40U
 XINV2       502   503   599   500   INV         WPI=220U    WNI=60U
 XINV3       553   512   599   500   INV         WPI=16U     WNI=8U
 XINV4       512   513   599   500   INV         WPI=40U     WNI=20U
 XINV5       514   515   599   500   INV         WPI=30U     WNI=30U
 XINV6       513   517   599   500   INV         WPI=100U    WNI=50U
 QUOP        599   515   552         Q7_NPN      125  
 DQESD       500   552               QESD        1  
 CBP         552   500                           0.37P
 RESD        505   552                           2
.ENDS CDC536__OUT 
*
.SUBCKT INV  551   552   599   500               WPI=10U     WNI=4U
XMP1         552   551   599   599   PM          WP='WPI'    LP=0.8U
XMN1         552   551   500   500   NM          WN='WNI'    LN=0.8U
.ENDS INV
*
.SUBCKT ESD  551   552   599   500
XMN1         599   599   502   500   NM         WN=50U       LN=0.8U
XMN2         502   552   552   500   NM         WN=50U       LN=0.8U
XMN3         552   552   501   500   NM         WN=50U       LN=0.8U
XMN4         501   500   500   500   NM         WN=50U       LN=0.8U
DQESD1       500   551               QESD       1
CBP          551   500                          0.37P
RESD1        551   552                          43 
.ENDS ESD
*                                                CDC53696176GL
