***************************************************************************
**  Property of Texas Instruments Incorporated                            *
**                                                                        *
**  Unauthorized reproduction and/or distribution is strictly             *
**  prohibited.  (C) Copyright 1996 Texas Instruments Incorporated.       *
**  All rights reserved.                                                  *
**                                                                        *
**  These commodities, technical data, and software may be U.S. export    *
**  license controlled.  As such, prior to export or re-export, U.S.      *
**  Government approval and authorization may be required.                *
**                                                                        *
**  PLEASE BE AWARE THAT IN THE ABSENCE OF A SIGNED, WRITTEN AGREEMENT    *
**  TO THE CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
**  MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR IMPLIED.        *
**  Further, TI assumes no liability for: 1) the accuracy of the SPICE    *
**  models provided to your company; 2) the proper functioning of these   *
**  SPICE models in your design or for any resulting applications;  or    *
**  3) infringement of patents, copyrights or intellectual property       *
**  rights resulting from your use of these SPICE models.                 *
**                                                                        *
**  TI provides SPICE models as a service to our customers.  You and      *
**  your company shall not distribute, convey, sell or give these         *
**  models to anyone else without receiving prior written permission      *
**  from TI.                                                              *
**                                                                        *
**  TI reserves the right to make changes to its products or to           *
**  discontinue any semiconductor product or service without notice,      *
**  and advises its customers to obtain the latest version of relevant    *
**  information to verify, before placing orders, that the information    *
**  being relied on is current.                                           *
**                                                                        *
**  Please be aware that your receipt and subsequent use of the SPICE     *
**  information provided shall serve as acceptance of the terms and       *
**  conditions of this agreement.  If you do not accept these terms,      *
**  you should return the SPICE model and any other accompanying          *
**  information immediately.                                              *
***************************************************************************
**CDC587 SPICE I/O Model
**Advanced System Logic, Texas Instruments
****************************************************************
*
*NOTE:
*   The following files must be present to use this SPICE model:
*      587.CDC                  (netlist)
*      EPIC2B.LIB               (Library file for process models)
*      EPIC2BN.13               (Nominal process models, CMOS Level 13)
*      EPIC2BS.13               (Strong  process models, CMOS Level 13)
*      EPIC2BW.13               (Weak    process models, CMOS Level 13)
*      EPIC2BN.3                (Nominal process models, CMOS Level 3)
*      EPIC2BS.3                (Strong  process models, CMOS Level 3)
*      EPIC2BW.3                (Weak    process models, CMOS Level 3)
*      PKGS.LIB                 (Library file for packages)
*      TSSOP56.PKG              (Package parasitics)
*      READ.ME                  (General use, release notes, ...)
*
*INSTRUCTIONS:
*   To use this SPICE model, include the following lines in your main netlist:
*      .
*      .
*      .
*      .INCLUDE '587.CDC'
*                    IN    OUT   VREF  VCC   GND 
*      XCDC587_IN    1     2     3     199   100         CDC587IN
*                    IN    OUT   OE    VCC   GND
*      XCDC587_OUT   4     5     6     199   100         CDC587OUT
*      .
*      .
*      .
*
*   The diagrams below describe the nodes for the subcircuits:
*
*                    Node 3                         /|\
*                       |                            |
*                       |                            |
*                      ----                      Node 199(VCC)
*                     |    \                     Node 100(GND)
*       Node 1  ______|     \___  Node 2             |
*                     |     /                        |
*                     |    /                        ---
*                      ----                          -
*
*               CDC587IN(Input Buffer)
* 
*
*                      | Node 6                     /|\
*                      |                             |
*                      O                             |
*                     ----                       Node 199(VCC)
*                    /    |                      Node 100(GND)
*      Node 5  _____/     |___  Node 4               |
*                   \     |                          |
*                    \    |                         ---
*                     ----                           -
*
*               CDC587OUT(Output Buffer)
*
*       
*   Please refer to the 'READ.ME' file for general instructions for use.
*
*    CDC587 SPICE I/O MODEL SUBCIRCUIT
*    SYSTEM PERFORMANCE PRODUCTS 
*    ADVANCED SYSTEM LOGIC, TEXAS INSTRUMENTS
*
*    SUBCIRCUITS:  CDC587IN, CDC587OUT
*
*    PACKAGE PARASITICS
        .LIB 'PKGS.LIB'   TSSOP56
*
*    PROCESS MODELS 
        .LIB 'EPIC2B.LIB' NOMINAL_L13
*       .LIB 'EPIC2B.LIB' STRONG_L13
*       .LIB 'EPIC2B.LIB' WEAK_L13
*
* CDC587 INPUT SUBCIRCUIT
*    NODES:        CLK INPUT NODE
*                  |     INTERNAL OUTPUT NODE
*                  |     |     VREF INPUT NODE 
*                  |     |     |     VCC
*                  |     |     |     |     GND 
*                  |     |     |     |     | 
.SUBCKT CDC587IN   1     2     3     199   100
 X_PKGIN           1     1001                    TSSOP56_01
 X_PKGVREF         3     1003                    TSSOP56_02
 X_PKGVCC          199   1199                    TSSOP56_04
 X_PKGGND          100   1100                    TSSOP56_06
 XCDC587IN         1001  2    1003   1199  1100  CDC587__IN
.ENDS CDC587IN
*                         
* CDC587 OUTPUT SUBCIRCUIT   
*    NODES:        INTERNAL INPUT NODE
*                  |     OUTPUT NODE
*                  |     |     INTERNAL OE NODE
*                  |     |     |     VCC
*                  |     |     |     |     GND
*                  |     |     |     |     |
.SUBCKT CDC587OUT  4     5     6     199   100  
 X_PKGOUT          5     1005                    TSSOP56_08
 X_PKGVCC          199   1199                    TSSOP56_07
 X_PKGGND          100   1100                    TSSOP56_10
 XCDC587OUT        4     1005  6     1199  1100  CDC587__OUT
.ENDS CDC587OUT
*
.SUBCKT CDC587__IN 401 402 403 599 500
X3B     505     523    599    500   INVA   WPI=50U  WNI=20U 
X3A     523     533    599    500   INVA   WPI=25U  WNI=10U 
X7      402     513    599    500   INVA   WPI=50U  WNI=20U 
X6      513     512    599    500   INVA   WPI=25U  WNI=10U 
X4N2    544     508    500    500   NM     WN=50U   LN=0.8U   
X4P1    506     505    554    599   PM     WP=125U  LP=0.8U 
X4P2    554     405    599    599   PM     WP=125U  LP=0.8U 
X4N1    506     505    544    500   NM     WN=50U   LN=0.8U   
XP5     500     403    500    500   PM     WP=64U   LP=48.8U 
X2      508     405    599    500   INVA   WPI=40U  WNI=16U 
X5      512     506    599    500   INVA   WPI=10U  WNI=4U 
X3      533     503    599    500   INVA   WPI=10U  WNI=8U 
XP6     510     508    599    599   PM     WP=125U  LP=0.8U 
XP7     506     401    510    599   PM     WP=125U  LP=0.8U 
XN5     511     405    500    500   NM     WN=50U   LN=0.8U   
XN4     506     401    511    500   NM     WN=50U   LN=0.8U   
XN3     509     508    500    500   NM     WN=200U  LN=0.8U   
XN2     504     403    509    500   NM     WN=10U   LN=0.8U   
XN1     503     401    509    500   NM     WN=10U   LN=0.8U   
XP4     504     504    502    502   PM     WP=90U   LP=0.8U 
XP3     503     504    502    502   PM     WP=90U   LP=0.8U 
XP2     502     405    501    501   PM     WP=200U  LP=0.8U 
XP1     501     404    599    599   PM     WP=50U   LP=1.8U 
XBIAS   403	404    405    599   500  SSTL_BIAS
.ENDS CDC587__IN 
*
.SUBCKT INVA  402 401 599 500              WNI=4U   WPI=10U 
X__MN1  402     401    500     500  NM     WN='WNI' LN=0.8U   
X__MP1  402     401    599     599  PM     WP='WPI' LP=0.8U 
.ENDS INVA
*
.SUBCKT SSTL_BIAS 403 404 405 599 500
XE1     405    403    599    500   INVA   WPI=10U  WNI=75U 
XPE1    321    405    599    599   PM     WP=100U  LP=0.8U     
XPC2    500    503    500    500   PM     WP=50U   LP=57.8U    
R3      501    503                 3K 
XN3     404    503    500    500   NM     WN=40U   LN=1.8U   
XN2     503    503    500    500   NM     WN=40U   LN=1.8U   
XN1     501    501    504    500   NM     WN=40U   LN=1.8U   
XP4     404    599    404    404   PM     WP=100U  LP=57.8U
XP2     404    404    599    599   PM     WP=20U   LP=1.8U 
XP1     500    500    504    599   PM     WP=40U   LP=1.8U 
R1      321    501                 2K 
.ENDS SSTL_BIAS 
*
.SUBCKT CDC587__OUT 401 402 403 599 500
XAP1    551     401     599     599   PM     WP=25U    LP=0.8U 
XAP2    552     551     599     599   PM     WP=50U    LP=0.8U 
XAN1    551     401     500     500   NM     WN=10U    LN=0.8U
XAN2    552     551     500     500   NM     WN=20U    LN=0.8U
CPAD    402     500                          1PF 
X__N1   504     513     500     500   NM     WN=100U   LN=0.8U
QESD    402     500     500           Q2_NPN 200 
X__P12  512     403     599     599   PM     WP=16U    LP=0.8U 
X__P14  513     512     599     599   PM     WP=40U    LP=0.8U 
X__P7   507     513     599     599   PM     WP=100U   LP=0.8U 
X__P10  502     552     599     599   PM     WP=100U   LP=0.8U 
X__P11  503     502     599     599   PM     WP=200U   LP=0.8U 
X__N14  512     403     500     500   NM     WN=8U     LN=0.8U
X__N15  513     512     500     500   NM     WN=20U    LN=0.8U
X__N7   507     513     500     500   NM     WN=50U    LN=0.8U
X__N12  502     552     500     500   NM     WN=40U    LN=0.8U
X__N13  503     502     500     500   NM     WN=80U    LN=0.8U
X__P5   505     507     599     599   PM     WP=200U   LP=0.8U 
X__P6   520     503     505     599   PM     WP=200U   LP=0.8U 
X__N5   520     503     500     500   NM     WN=100U   LN=0.8U
X__N6   520     507     500     500   NM     WN=100U   LN=0.8U
X__N3   521     503     504     500   NM     WN=100U   LN=0.8U
X__P1   521     513     599     599   PM     WP=150U   LP=0.8U 
X__P3   521     503     599     599   PM     WP=150U   LP=0.8U 
X__NOUT 3142    520     500     500   NM     WN=500U   LN=0.8U   
X__POUT 402     521     599     599   PM     WP=1100U  LP=0.8U 
RESD    3142    402                          3.84
.ENDS CDC587__OUT
*						CDC587X96163GL
