
;
; Character commands.
; Entries :
;		HOM - home alpha cursor (routine duplicated in dchar).
;		SAP - set alpha parameters.
;		MAR - set left and right text margins.
; 		CHR - select character font.
;		SAC - set alpha cursor color.
;		TXT - what you think.
;		SAW - set alpha window.
;
; NOTE - both CHR and SAP are incompatible with Colorware.
; Currently the 1280 version of SAP selects the 7x9 font
; if asked for the (non-existent) 5x6 or 5x7, and selects
; the default 11x15 if asked for 7x9.  
; CHR does the best it can in matching the requested
; (Colorware) font with those available in the 1280.
;


txt:
	php
	sep	#0x20
	bra	$2
$1:
	jsl	>0,Dchar

$2:	jsl	>0,Get
	cmp	#0
	bne	$1

	plp
	rtl

chr:
	php
	sep	#0x20
	jsl	>0,Getb
	sec
	sbc	#1
	cmp	#8
	bcc	$1
	lda	#6
$1:
	bsl	setfnt
;
; set da char size (single/double high and wide).
;
$w1:	bit	Dpdone
	bvc	$w1
	lda	DaCtl
	and	#255-128-64
	ora	<chrsiz
	sta	DaCtl
	
	plp
	rtl

setfnt:
	php
	phb
	phk
	plb
	sep	#0x30
	cmp	#0
	beq	$set71
	cmp	#1
	beq	$set71
	cmp	#4
	beq	$set71
	cmp	#3
	beq	$set72
	cmp	#7
	beq	$setb2

	per	$sing11
	bra	$setup
$set71
	per	$sing7
	bra	$setup
$set72
	per	$doub7
	bra	$setup
$setb2
	per	$doub11
$setup:
	ldx	#0
	txy
$loop:	lda	(1,s),y
	sta	<chrsiz,x
	iny
	inx
	cpx	#$doub7-$sing7
	bne	$loop
	pla				; clean up stack.
	pla
	plb
	plp
	rts	

$sing7:
	dcb	0		; chrsiz - drawing acc char flag bits.
	dcw	10		; cwidth - horiz char spacing.
	dcw	15		; chight - vertical char spacing.
	dcw	2		; desc - descender amt.
	dcb	7		; csx - bits/row in char bit map.
	dcb	9		; csy - rows/char in char bit map.
	dcw	15-9		; fudge - dist from cap to bottom of box.
				; (chight-csy).
	dcw	0xbc0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$doub7:
	dcb	128+64		; chrsiz - drawing acc char flag bits.
	dcw	17		; cwidth - horiz char spacing.
	dcw	24		; chight - vertical char spacing.
	dcw	4		; desc - descender amt.
	dcb	7		; csx - bits/row in char bit map.
	dcb	9		; csy - rows/char in char bit map.
	dcw	24-18		; fudge - dist from cap to bottom of box.
				; (chight - csy ).
	dcw	0xbc0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$sing11:
	dcb	0		; chrsiz - drawing acc char flag bits.
	dcw	14		; cwidth - horiz char spacing.
	dcw	24		; chight - vertical char spacing.
	dcw	3		; desc - descender amt.
	dcb	12		; csx - bits/row in char bit map.
	dcb	16		; csy - rows/char in char bit map.
	dcw	24-16		; fudge - dist from cap to bottom of box.
				; (csy - chight).
	dcw	0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$doub11:
	dcb	128+64		; chrsiz - drawing acc char flag bits.
	dcw	26		; cwidth - horiz char spacing.
	dcw	40		; chight - vertical char spacing.
	dcw	6		; desc - descender amt.
	dcb	12		; csx - bits/row in char bit map.
	dcb	16		; csy - rows/char in char bit map.
	dcw	40-32		; fudge - dist from cap to bottom of box.
				; (csy - chight).
	dcw	0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.

;
; Home graphics cap.  Also home alpha cap
; if caps are linked.
;

hom:
	php
	rep	#0x20
	ldx	<lftmar
	stx	<xpos

	sec
	lda	<topmar
	sbc	<chight
	sta	<ypos

	bit	<acflag-1		; caps linked ?
	bvs	$done			; br if no.
	stx	<acx
	sta	<acy
$done:
	plp
	rtl
	
sap:
	php
	sep	#0x20
;
; get single/double flag
;
	jsl	>0,Get		; size
	cmp	#'.'		; leave as is ?
	beq	$1		; br if yes.
	sec
	sbc	#'1'		; '1' for single, anything else double.
	beq	$2
	lda	#128+64
	tsb	<chrsiz
	bra	$21
$2:	lda	#128+64
	trb	<chrsiz
$21:

;
; get font, '5' or '6' or '7' for 7x9,
; '8' for 12x16.
;
$1:
	jsl	>0,Get		; font
	cmp	#'.'
	bne	$new
	lda	<csx
	cmp	#7
	bne	$10
	lda	#'7'
	bra	$new
$10	lda	#'8'
$new	cmp	#'8'
	beq	$normal
	lda	#0
	bit	<chrsiz
	bpl	$setfnt
	lda	#3
	bra	$setfnt
$normal
	lda	#8
	bit	<chrsiz
	bpl	$setfnt
	lda	#7
$setfnt
	bsl	setfnt	
$3:
	jsl	>0,Getb
	sta	<cwidth
	stz	<cwidth+1

	jsl	>0,Getb
	sta	<chight
	stz	<chight+1

	sec
	lda	<chight
	sbc	<csy
	bit	<chrsiz
	bpl	$okdok
	sbc	<csy
$okdok	sta	<fudge	
		
	jsl	>0,Get		; linked or unlinked caps
	cmp	#'U'		; unlink ?
	bne	$4		; br if no, check for 'U'.
	lda	<acflag
	ora	#64		; yes, set linked caps bit.
	bra	$5		; store result.
$4:	cmp	#'L'		; linked caps ?
	bne	$6		; done if no.
	lda	<acflag
	and	#255-64		; yes, reset linked caps bit.
$5:	sta	<acflag
$6:	plp
	rtl

;
; Set left, right text margins.
;

mar:
	php
	rep	#0x20

	jsl	>0,Getw		
	cmp	##0
	bne	$1
	inc	a
$1:
	sta	<lftmar

	jsl	>0,Getw		
	cmp	##0
	bne	$2
	sec
	lda	<windx
	sbc	<worgx
$2:
	sta	<rgtmar
	
	plp
	rtl
;
; SAC - set alpha cursor color.
; Note - if 0, cursor not drawn.
;
sac:
	php
	sep	#0x20
	jsl	>0,Getb		
	sta	<acolor
	plp
	rtl

;
; Set Alpha Window - all four margins
;
saw:
	php
	rep	#0x30
;	phx
;	phy

	jsl	>0,Gcoor
	stx	<lftmar
	sty	<botmar

	jsl	>0,Getw		; as long as rgtmar > lftmar,then we
	cmp	<lftmar		; will take it, else previous value stay
	bmi	$1
	beq	$1
	sta	<rgtmar
$1:
	jsl	>0,Getw		; see above
	cmp	<botmar
	bmi	$done
	beq	$1
	sta	<topmar
$done	
;	ply
;	plx
	plp
	rtl



	end


