
;
; Preliminary window routines.
;
; Entries :
;
;	DFW(id,x,y,dx,dy)	- define window.
;	DLW(id)			- delete window.
;	SLW(id)			- select window.
;	ORG(x,y)		- change origin of current window.
;	MVW(x,y)		- change position of current window.
;	CLP(onoff)		- turn clipping on/off.
;	ERD			- erase window.
;
;	getwin			- gets a block of 60 bytes for new 
;				  window data
;	savwin			- save current window data
;	reswin			- restore y specified window data

;
; Define window.
;

dfw:
	php
	sep	#0x30

	ldy	<wname		; save current window data
	bsl	savwin

	jsl	>0,Getb
	asl	a
	tay
	bne	$1		; window #0 cannot be redefined
$nogood				; here to gobble up data coming in
	jsl	>0,Gcoor	
	jsl	>0,Getw
	jsl	>0,Getw
	bra	$done

$1	bsl	getwin		; get new block from heap
	bcs	$nogood
	phk			; get and set window screen position.
	bsl	mvw
	rep	#0x20
	jsl	>0,Getw
	sta	<windx
	jsl	>0,Getw
	sta	<windy

	stz	<worgx
	stz	<worgy

	lda	<windx
	clc
	adc	<worgx
	sta	<rgtmar

	lda	<windy
	clc
	adc	<worgy
	sta	<topmar

	lda	##1
	sta	<lftmar
	lda	##4
	sta	<botmar

	bsl	savwin		; record new data
$done
	ldy	<wname
	bsl	reswin		; now bring back the window we were in
	plp
	rtl

;
; Select predefined window
;
slw:
	php

	sep	#0x10
	ldy	<wname
	bsl	savwin

	jsl	>0,Getb
	rep	#0x30
	asl	a		; double for indexing
	tay
	lda	(<wheap),y
	beq	$done		; go home if window wasn't defined

	tya
	sep	#0x30
	sta	<wname
	bsl	reswin
$done		
	plp
	rtl	

;
; Delete Window
;
dlw:
	php
	rep	#0x30

	jsl	>0,Getb
	asl	a
	tay
	beq	$done			; cannot delete window #0

	lda	(<wheap),y
	beq	$done			; br if not defined 

;	sta	<temp
;	pei	<temp

	pha
	jsl	>0,FreHeap		; free the block and
	lda	##0
	sta	(<wheap),y		; clear pointer
$done
	plp
	rtl
	
;
; Move window in world coordinate space.
;
org:
	php
	rep	#0x30
	jsl	>0,Getw
	tax
	jsl	>0,Getw
	tay
	stx	<worgx
	sty	<worgy
$1:	bit	Dpdone-1
	bvc	$1
	stx	Xorg
	sty	Yorg
	plp
	rtl
;
; Move window screen position.
;
mvw:
	php
	rep	#0x30
	phx
	phy

	jsl	>0,Gcoor
	stx	<winox
	sty	<winoy
$1:	bit	Dpdone-1
	bvc	$1
	stx	Xwbot
	sty	Ywbot
	lda	<windx
	sta	Xwtop
	lda	<windy
	sta	Ywtop

	ply
	plx
	plp
	rtl

;
; Turn clipping on/off.
;
clp:
	php
	sep	#0x30
	jsl	>0,Getb
	ldy	#4
$1:	bit	Dpdone
	bvc	$1
	tax
	bne	$on
	tya
	trb	DaFlag
	plp
	rtl
$on:	tya
	tsb	DaFlag
	plp
	rtl


;
; Get a new window data block, y contains (wname*2)
;
getwin:
	php
	rep	#0x30
	phy

	lda	(<wheap),y
	bne	$done		; already got heap, go home
	
	pea	##wblock	; current block size
	jsl	>0,GetHeap
	pla
	bcs	$nogood		; no ram available
	sta	(<wheap),y	; update addr in array
$done
	ply
	plp
	clc
	rts
$nogood
	ply
	plp
	sec
	rts
;
; Restore y specified window data into direct page
;
reswin:
	php
	rep	#0x30
	phx
	phy

	lda	(<wheap),y
	tax				; source

	tdc
	clc
	adc	##color
	tay				; destination
	lda	##wblock-1		; block size	
	mvn	>0,>0

$1	bit	Dpdone-1
	bvc	$1
	lda	<winox
	sta	Xwbot
	lda	<winoy
	sta	Ywbot
	lda	<windx
	sta	Xwtop
	lda	<windy
	sta	Ywtop
	lda	<worgx
	sta	Xorg
	lda	<worgy
	sta	Yorg

	lda	<xpos
	sta	Xcap
	lda	<ypos
	sta	Ycap

	lda	<color
	sta	DaColr
	lda	<bcolor
	sta	DaBclr
	lda	<wcapct
	sta	Capctl
	lda	<wdaflg
	sta	DaFlag
		
	ply
	plx
	plp
	rts

;
; Save current window data 
;
savwin:
	php
	rep	#0x30
	phx
	phy

$1	bit	Dpdone-1
	bvc	$1
	lda	Capctl
	sta	<wcapct
	lda	DaFlag
	sta	<wdaflg

	lda	(<wheap),y
	tay				; destination

	tdc
	clc
	adc	##color
	tax				; source
	lda	##wblock-1		; block size	
	mvn	>0,>0

	ply
	plx
	plp
	rts

erd:
	php
	sep	#0x20
$1:	bit	Dpdone
	bvc	$1
	sta	DaErw
	plp
	rtl


	end



