;
; VT100 character set, character size, video attribute commands
;

;
; ESC # - set character size or align display.
;
; Set chrsiz =	'5' ->   0  - single size,
;		'6' ->  128 - single high, double wide,
;		'3' ->   64 - top half of double size,
;		'4' ->  192 - bottom half double size.

escpnd:
	bsl	getchr		; get size selector.
	beq	escpnd
	bcc	$noesc
	brl	escseq
$noesc:	bvc	$ok
	rts			; CAN or SUB.
$ok:	
	cmp	#'8'		; align display ?
	beq	$align		; yes, go fill with 'E'

	cmp	#'3'
	bne	$l1
	lda	#64		; top of double high and wide
	bra	$found
$l1	cmp	#'4'
	bne	$l2
	lda	#128+64		; bottom of double high and wide
	bra	$found
$l2	cmp	#'5'
	bne	$l3
	lda	#0		; single everything!
	bra	$found
$l3	cmp	#'6'
	bne	$done		; br if illegal param
	lda	#128

$found	cmp	<chrsiz		; size change ?
	beq	$done		; br if no, that was easy.
	pha			; save new size.
	ldy	<nchr		; get last column in line.
	beq	$1		; easy if line empty.
	lda	#1
	bsl	undisp		; erase line from display.
$1:	pla			; recover new char size.
	bsl	setsiz		; update line attr record and
				; truncate the line if necessary.
	ldy	<nchr
	beq	$done
	lda	#1
	brl	dsplin		; display the line in new size.	
$done:	rts

;
; ESC # 8
;

$align:
;	fill screen with 'E'
	rts

;
; ESC ( - Set G0
;

setg0:
	bsl	getchr
	beq	setg0
	bcc	$noesc
	brl	escseq
$noesc:
	bvc	$1
	rts
$1:
	stz	<g0set		; reinit
	cmp	#'A'
	beq	$l1
	cmp	#'B'
	beq	$l1
	cmp	#'0'
	bne	$done
	bit	<g01sel		; are we selected?
	bmi	$ok		; br if not
	sta	<g0set
	lda	#128
	tsb	<spattr		; make current char attr aware
	rts

$l1	bit	<g01sel
	bmi	$ok
	pha
	lda	#128
	trb	<spattr
	pla

$ok:	sta	<g0set
$done:	rts

;
; ESC ) - Set G1
;

setg1:
	bsl	getchr
	beq	setg1
	bcc	$noesc
	brl	escseq
$noesc:
	bvc	$1
	rts
$1:
	stz	<g1set		; reinit
	cmp	#'A'
	beq	$l1
	cmp	#'B'
	beq	$l1
	cmp	#'0'
	bne	$done
	bit	<g01sel
	bpl	$ok		; br if we're not selected
	sta	<g1set
	lda	#128
	tsb	<spattr
	rts

$l1:	bit	<g01sel
	bpl	$ok
	pha
	lda	#128
	trb	<spattr
	pla

$ok:	sta	<g1set
$done:	rts

;
; SO
;

soctl:
	lda	#128		; select G1 set
	tsb	<g01sel

	lda	<g1set
	cmp	#'0'		; is it gfx?
	bne	$l1		; br if not
	lda	#128
	tsb	<spattr
	rts
$l1	lda	#128
	trb	<spattr
	rts

;
; SI
;

sictl:
	stz	<g01sel		; select G0 set

	lda	<g0set
	cmp	#'0'		; is it gfx?
	bne	$l1		; br if not
	lda	#128
	tsb	<spattr
	rts
$l1	lda	#128
	trb	<spattr
	rts

;
; ESC [ Ps m - Video attributes.
;
; Note - only the underline attribute is supportable.
; Currently no attributes are supported.
;

vidatt:
	php
	rep	#0x30
	phx
	sep	#0x30

	lda	#255-128
	trb	<spattr		; default - no attr
	bsl	getps
	bcc	$1		; br if good stuff!
	bra	$done
$1
	cmp	#0		; attribute off
	bne	$2
$l1	lda	#255-128
	trb	<spattr
	bra	$next
$2	cmp	#1		; bold, not supported
	beq	$next
	cmp	#4		; underscore
	bne	$3
$l2	tsb	<spattr
	bra	$next
$3	cmp	#5		; blink, not supported
	beq	$next
	cmp	#7		; reverse video, sub with underscore
	bne	$next
	lda	#4
	bra	$l2
$next	bsl	getps
	bcc	$1		; more in buffer

$done	rep	#0x30
	plx
	plp
	rts

setfnt:
	php
	phb
	phk
	plb

	sep	#0x30
	cmp	#0
	beq	$set11
	cmp	#1
	beq	$set22
	cmp	#2
	beq	$set7
	cmp	#3
	beq	$set72
	bra	$done
$set7
	per	$sing7
	bra	$setup
$set72
	per	$doub7
	bra	$setup
$set11
	per	$sing11
	bra	$setup
$set22:
	per	$doub11

$setup:
	ldx	#0
	txy
$loop:	lda	(1,s),y
	sta	<daflag,x
	iny
	inx
	cpx	#$doub7-$sing7
	bne	$loop

	pla			; remove table addr.
	pla
	plb			; restore dbr.
;
; set da char size (single/double high and wide).
;
$w1:	bit	Dpdone
	bvc	$w1
	lda	DaCtl
	and	#255-128-64
	ora	<daflag
	sta	DaCtl
$done:	
	plp
	rts	

$sing7:
	dcb	0		; daflag - drawing acc char flag bits.
	dcw	9		; cwidth - horiz char spacing.
	dcw	16		; chight - vertical char spacing.
	dcw	3		; desc - descender amt.
	dcb	7		; csx - bits/row in char bit map.
	dcb	9		; csy - rows/char in char bit map.
	dcw	16-9		; fudge - dist from cap to bottom of box.
				; (chight-csy).
	dcw	0xbc0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$doub7:
	dcb	128+64		; daflag - drawing acc char flag bits.
	dcw	16		; cwidth - horiz char spacing.
	dcw	24		; chight - vertical char spacing.
	dcw	6		; desc - descender amt.
	dcb	7		; csx - bits/row in char bit map.
	dcb	9		; csy - rows/char in char bit map.
	dcw	24-18		; fudge - dist from cap to bottom of box.
				; (chight - csy ).
	dcw	0xbc0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$sing11:
	dcb	0		; daflag - drawing acc char flag bits.
	dcw	14		; cwidth - horiz char spacing.
	dcw	24		; chight - vertical char spacing.
	dcw	3		; desc - descender amt.
	dcb	12		; csx - bits/row in char bit map.
	dcb	16		; csy - rows/char in char bit map.
	dcw	24-16		; fudge - dist from cap to bottom of box.
				; (csy - chight).
	dcw	0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.
$doub11:
	dcb	128+64		; daflag - drawing acc char flag bits.
	dcw	26		; cwidth - horiz char spacing.
	dcw	40		; chight - vertical char spacing.
	dcw	6		; desc - descender amt.
	dcb	12		; csx - bits/row in char bit map.
	dcb	16		; csy - rows/char in char bit map.
	dcw	40-32		; fudge - dist from cap to bottom of box.
				; (csy - chight).
	dcw	0		; fntptr - addr of font.
	dcb	ROM		; fntbnk - data bank containing font.



	end
