;
; VT100 escape sequence parser.
;

escseq:
	bsl	getchr
	beq	escseq
	bcs	escseq		; br if ESC, start new esc sequence.
	bvs	$done		; br if CAN, abandon sequence.
	bit	<vtmode		; ANSI or VT52 mode ?
	bmi	$1		; br if ANSI.
	brl	$vt52		; go do VT52 ESC sequence.
$done:
	rts
$1:
	cmp	#'['
	bne	$2
	brl	escbfn
$2:
	cmp	#'D'
	bne	$3
	brl	index
$3:
	cmp	#'E'
	bne	$4
	brl	nxtlin
$4:
	cmp	#'M'
	bne	$5
	brl	rindex
$5:
	cmp	#'7'
	bne	$6
	brl	savcur
$6:
	cmp	#'8'
	bne	$7
	brl	rstcur
$7:
	cmp	#'='
	bne	$8
	brl	setakm
$8:
	cmp	#'>'
	bne	$9
	brl	clrakm
$9:
	cmp	#'#'
	bne	$10
	brl	escpnd
$10:
	cmp	#'H'
	bne	$11
	brl	settab
$11:
	cmp	#'('
	bne	$12
	brl	setg0
$12:
	cmp	#')'
	bne	$13
	brl	setg1
$13:
	cmp	#'Z'
	bne	$14
	brl	rqidnt
$14:
	cmp	#'c'
	bne	$15
	brl	vtrst
$15:
	cmp	#'%'
	bne	$16
	brl	vtxitm		; exit VT100/ANSI emulation
$16:
	brl	$done



$vt52:
;
; Arrange for calls to getpn to return default (0).
; This allows us to use the ANSI mode cursor movement
; and erase routines in VT52 mode.
;
	stz	<param
	stz	<parcnt
	stz	<pncnt

	cmp	#'A'
	bne	$v1
	brl	curup
$v1:	cmp	#'B'
	bne	$v2
	brl	curdn
$v2:	cmp	#'C'
	bne	$v3
	brl	currt
$v3:	cmp	#'D'
	bne	$v4
	brl	curlt
$v4:	cmp	#'F'
	bne	$v5
	brl	$done
$v5:	cmp	#'G'
	bne	$v6
	brl	$done
$v6:	cmp	#'H'
	bne	$v7
	brl	currc
$v7:	cmp	#'I'
	bne	$v8
	brl	rindex
$v8:	cmp	#'J'
	bne	$v9
	brl	erscrn
$v9:	cmp	#'K'
	bne	$v10
	brl	erslin
$v10:	cmp	#'Y'
	bne	$v11
	brl	$mov52
$v11:	cmp	#'Z'
	bne	$v12
	brl	rqidnt
$v12:	cmp	#'='
	bne	$v13
	brl	setakm
$v13:	cmp	#'>'
	bne	$v14
	brl	clrakm
$v14:	cmp	#'<'
	bne	$v15
	brl	clr52m
$v15:	cmp	#'%'
	bne	$v16
	brl	vtxitm		; exit VT100/ANSI emulation
$v16:	brl	$done

$mov52:
	bsl	getchr
	beq	$mov52
	bvs	$v15
	bcs	$vesc
	sec
	sbc	#32
	cmp	<rowmax
	bcs	$col
	inc	a
	sta	<cury
	bsl	chngln
$col:	bsl	getchr
	beq	$col
	bvs	$v15
	bcs	$vesc
	sec
	sbc	#32
	cmp	<ncol
	bcs	$v15
	inc	a
	sta	<curx
	brl	$done	
$vesc	brl	escseq
		
;
; Here to parse ESC[ sequence.
;

escbfn:
	stz	<prvflg		; assume not a 'private' sequence.
	stz	<param		; init first parameter.
	stz	<pncnt		; init counter for getps/getpn.
	ldx	#0		; init parameter count/index to array.

$wait	bsl	getchr
	beq	$wait
	bcc	$1
$eesc:	brl	escseq		; ESC, start new escape sequence.
$1:	bvc	$2
$abt:	brl	$done		; CAN, abandon escape sequence.
$2:	cmp	#'?'		; private sequence ?
	bne	$eval1		; br if no, start evaluating.
	dec	<prvflg		; yes, set private flag.

;
; start evaluating parameter string.
;

$eval:	bsl	getchr
	beq	$eval
	bcs	$eesc
	bvs	$abt		
$eval1:
	tay			; save first parameter char.
	sec			; see if its a decimal digit.
	sbc	#'0'
	cmp	#10
	bcs	$notdec		; it's not, check ; and final char.
;
; it's decimal, multiply current param * 10 and add.
;
	tay			; save decimal value
	asl	<param,x	; mult current param * 10.
	lda	<param,x
	asl	a
	asl	a
	clc
	adc	<param,x
	sta	<param,x
	clc			; add decimal value to parameter.
	tya
	adc	<param,x
	sta	<param,x
	brl	$eval		; go process next char.
$notdec:
	cpx	#maxpar		; read max number params ?
	bcs	$11		; br if yes.
	inx			; no, inc param count.
	stx	<parcnt		; save parameter count.
	stz	<param,x	; init next param.
$11:
	tya			; recover the not decimal char.
	cmp	#';'		; param separator ?
	bne	$12		; br if no.
	brl	$eval		; yes, go start next parameter.
;
; Reached end of parameter string.  See if
; valid final char.  If no, just exit, else
; see if there is a handler for the char and
; call the handler if there is, else just exit.
;
$12:
	sec			; see if char is in range of
	sbc	#0x40		; valid final chars (40-7e hex).
	cmp	#0x7e-0x40		
	bcc	$ok		; br if yes.
	brl	$done		; not valid, just exit.
$ok:
	tya			; recover potential final char.
	cmp	#'H'
	bne	$20
	brl	currc		; move cursor to r,c.
$20:
	cmp	#'f'
	bne	$21
	brl	currc		; move cursor to r,c.
$21:
	cmp	#'n'
	bne	$22
	brl	rqstat		; term ok ? where is cursor ?
$22:
	cmp	#'K'
	bne	$23
	brl	erslin		; various flavors of erase line.
$23:
	cmp	#'J'
	bne	$24
	brl	erscrn		; ditto erase screen.
$24:		
	cmp	#'h'
	bne	$25
	brl	setmod		; set modes.
$25:
	cmp	#'l'
	bne	$26
	brl	rstmod		; reset modes.
$26:
	cmp	#'m'
	bne	$27
	brl	vidatt		; video attributes.
$27:
	cmp	#'A'
	bne	$28
	brl	curup		; cursor up n.
$28:
	cmp	#'B'
	bne	$29
	brl	curdn		; cursor down n.
$29:
	cmp	#'C'
	bne	$30
	brl	currt		; cursor right n.
$30:
	cmp	#'D'
	bne	$31
	brl	curlt		; cursor left n.
$31:
	cmp	#'r'
	bne	$32
	brl	setreg		; set scrolling region.
$32:
	cmp	#'g'
	bne	$33
	brl	clrtab		; clear 1 or all tabs.
$33:
	cmp	#'q'
	bne	$34
	brl	setled		; set leds.
$34:
	cmp	#'x'
	bne	$35
	brl	rqtpar		; what are terminal parameters ?
$35:
	cmp	#'c'
	bne	$36
	brl	rqidnt		; what are you ?
$36:
	cmp	#'y'
	bne	$37
	brl	slftst		; perform self test.
$37:
$done:	rts


;
; Return the next Pn of an ESC[ sequence.
;

getpn:
	ldx	<pncnt		; get index next param value.
	cpx	<parcnt		; < # params sent ?
	bcc	$1		; br if yes.
	lda	#0		; no, return 0 as default.
	rts
$1:	lda	<param,x	; get next param value.
	inc	<pncnt		; point pncnt to next Pn val to return.
	rts

;
; Return the next Ps of an ESC[ sequence
; if there is one, else return carry set.
;
			
getps:
	ldx	<pncnt
	cpx	<parcnt
	bcc	$1
	rts
$1:	lda	<param,x
	inc	<pncnt
	rts
	
	end


