
;
; VT100 set/reset mode commands
;

setakm:				; ESC =  set alternate keypad mode.
	lda	#128
	tsb	<akmode
	rts

clrakm:				; ESC  >  clear alternate keypad mode.
	lda	#128
	trb	<akmode
	rts

clr52m:				; ESC <  Enter ANSI mode (from VT52).
	lda	#128
	tsb	<vtmode
	rts

vtxitm:
	bsl	getchr
	beq	vtxitm
	bcc	$noesc
	brl	escseq
$noesc
	bvc	$ok
	rts
$ok
	cmp	#'!'
	bne	$done
$l1
	bsl	getchr
	beq	$l1
	bcc	$l2
	brl	escseq
$l2
	bvc	$l3
	rts
$l3
	cmp	#'0'
	bne	$done
	brl	vtexit
$done
	rts

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ESC [ Ps h	ANSI set mode	;
; or ESC [ ? Ps h - DEC private ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

setmod:
	bsl	getps		; get next selective param.
	bcc	$1		; br if there is one.
	rts			; all used up, return.
$1:
	bit	<prvflg		; private flag set ?
	bmi	$decprv		; br if yes.
	cmp	#20
	beq	setnlm		; clear newline mode.
	cmp	#12
	beq	setekm		; clear local echo mode.
	bra	setmod
$decprv:
	cmp	#9		; Ps < 9 ?
	bcs	setmod		; br if no, 1..8 is all we do.
	cmp	#1
	bne	$l1
	brl	setckm		; set cursor key mode.
$l1	cmp	#3
	beq	set132		; set 132 column mode.
	cmp	#4
	beq	setssm		; set smooth scroll mode.
	cmp	#5
	beq	setrvm		; set reverse video mode.
	cmp	#6
	beq	setorm		; set origin mode.
	cmp	#7
	beq	setawm		; set autowrap mode.
	cmp	#8
	beq	setarm		; set autorepeat mode.
	bra	setmod

setnlm:				; ESC [ 20 h	Set newline mode.
	lda	#128
	tsb	<nlmode
	bra	setmod

setekm:				; ESC [ 12 h	Set local echo mode.
	lda	#64
	tsb	<vtmode
	bra	setmod

setssm:				; ESC [ ? 4 h	Set smooth scroll mode.
	lda	#64
	tsb	<clmode
	brl	setmod

set132:				; ESC [ ? 3 h	Set 132 column mode.
	lda	#128
	tsb	<clmode
	lda	#2
	sta	<param
	lda	#1
	sta	<parcnt
	sta	<curx
	sta	<cury
	bsl	chngln
	bsl	erscrn	
	bsl	inibuf		; reconfigure for 132 columns.
	bsl	stabs
	lda	#2
	bsl	setfnt
	lda	#35
	sta	<xorg
	stz	<xorg+1
	brl	setmod

setrvm:				; ESC [ ? 5 h	Set reverse video.
	lda	#128
	tsb	<rvmode
	brl	setmod

setorm:				; ESC [ ? 6 h - Set Origin Mode.
	lda	#128
	tsb	<ormode		; set origin mode flag.
	lda	#1		; move to scrolling region origin.
	sta	<curx
	lda	<srtop
	cmp	<cury
	beq	$1
	sta	<cury
	bsl	chngln		; update current line info.
$1:	brl	setmod

setawm:				; ESC [ ? 7 h	Set autowrap mode.
	lda	#64
	tsb	<nlmode
	brl	setmod

setckm:
	lda	#64
	tsb	<akmode
	brl	setmod

setarm:				; ESC [ ? 8 h	Set autorepeat mode.
	brl	setmod


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ESC [ Ps l	ANSI reset mode ;
; or ESC [ ? Ps l - DEC private ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

rstmod:
	bsl	getps		; get next selective param.
	bcc	$1		; br if there is one.
	rts			; all used up, return.
$1:
	bit	<prvflg		; private flag set ?
	bmi	$decprv		; br if yes.
	cmp	#20
	beq	clrnlm		; clear newline mode.
	cmp	#12
	beq	clrekm		; clear local echo mode.
	bra	rstmod
$decprv:
	cmp	#9		; Ps < 9 ?
	bcs	rstmod		; br if no, 1..8 is all we do.
	cmp	#1
	bne	$l1
	brl	clrckm
$l1	cmp	#2
	beq	set52m
	cmp	#3
	beq	clr132
	cmp	#4
	beq	clrssm
	cmp	#5
	beq	clrrvm
	cmp	#6
	beq	clrorm
	cmp	#7
	beq	clrawm
	cmp	#8
	beq	clrarm
	bra	rstmod

clrnlm:				; ESC [ 20 l	Clear newline mode.
	lda	#128
	trb	<nlmode
	bra	rstmod

clrekm:				; ESC [ 12 l	Clear local echo mode.
	lda	#64
	trb	<vtmode
	bra	rstmod

clrarm:				; ESC [ ? 8 l	Clear autorepeat mode.
	brl	rstmod


set52m:				; ESC [ ? 2 l	Set VT52 mode.
	lda	#128
	trb	<vtmode
	bra	rstmod

clr132:				; ESC [ ? 3 l	Set 80 column mode.
	lda	#128
	trb	<clmode
	lda	#2
	sta	<param
	lda	#1
	sta	<parcnt
	sta	<curx
	sta	<cury
	bsl	chngln
	bsl	erscrn	
	bsl	inibuf		; reconfigure for 80 columns.
	bsl	stabs		; set tabs in buffer
	lda	#0
	bsl	setfnt
	lda	#128
	sta	<xorg
	stz	<xorg+1
	brl	rstmod

clrssm:				; ESC [ ? 4 l	Clear smooth scroll mode.
	lda	#64
	trb	<clmode
	brl	rstmod

clrrvm:				; ESC [ ? 5 l	Clear reverse video.
	lda	#128
	trb	<rvmode
	brl	rstmod

clrorm:				; ESC [ ? 6 l - Reset Origin Mode.
	lda	#128
	trb	<ormode		; clear origin mode flag.
	lda	#1		; move to screen origin.
	sta	<curx
	cmp	<cury
	beq	$1
	sta	<cury
	bsl	chngln		; update current line info.
$1:	brl	rstmod

clrawm:				; ESC [ ? 7 l	Clear autowrap mode.
	lda	#64
	trb	<nlmode
	brl	rstmod

clrckm:
	lda	#64
	trb	<akmode
	brl	rstmod




	end
