#include	"mac.h"
#include	"mac.x"

/*
 *   Generate object file
 */

struct	out	out;
struct	outhdr	outhdr;

makobjf()
{

	register struct st *q;
	register int i;

	/*
	 *   Write m.out header
	 */
	outhdr.ao_mword = MWORD;		/* magic number */
	outhdr.ao_bu_len = head.h_bu_len;	/* length of a byte */
	outhdr.ao_attrib = LCOUNT;		/* maximum number of segs*/

	if(*option('r')) outhdr.ao_attrib |= HASREL;

	/*
	 *   Scan symbol table for any global or external symbols
	 */

	q = symtab;

	for(i=0; i<nsyms; i++){
	  if(q->s_mode & (EXPO|EXT)){
	    outhdr.ao_attrib |= HASSYM;
	    break;
	  }
	  q++;
	}
	 
	write(objfil, &outhdr, AOUT);

	/*
	 *   Dump out segment descriptors
	 *   for code of any sort to generate.
	 */
	for (i=0; i<LCOUNT; i++)  {
	  out.ou_length = (int)(locn[i].l_limit - locn[i].l_start);
	  out.ou_start  = (int)locn[i].l_start;
	  out.ou_attrib = locn[i].l_attrib;
	  write(objfil, &out, OUT);
	}

	/*
	 * Output code segment to m.out
	 */

	for (i=0; i<LCOUNT; i++)  {
	  if (locn[i].l_limit != 0){
	    out.ou_length = (locn[i].l_limit - locn[i].l_start);
	    write(objfil, locn[i].l_rel_f, out.ou_length*INT);
	  }
	}

	/*
	 * Output relocation info if '-r'
	 */
	if(*option('r')){
	  for (i=0; i<LCOUNT; i++)  {
	    if (locn[i].l_limit){
	      out.ou_length = (locn[i].l_limit - locn[i].l_start);
	      write(objfil, locn[i].l_reloc, out.ou_length*INT); /*{ch}*/
			/* was     .l_rel_n */
	    }
	  }
	}

	/*
	 * Output exportable symbols
	 */
	q = symtab;
	for(i = 0; i < nsyms; i++){
	  if (q->s_mode & (EXPO|EXT))
	    write(objfil, q, ST);
	  q++;
	}
}

/*
 *   Dump code summary to stdout
 */

dmpsum(){

	register int *r;
	register int *len;
	register int i,j,k;
/*	register int width;
 *	register int wdump;
 */

	header(dmptitle);
	for(i=0; i < LCOUNT; i++) {
 	  if(locn[i].l_limit){
	    r = locn[i].l_rel_f;
	    j = (int)(locn[i].l_limit - locn[i].l_start);
	    len = r + j;
	    printf("Segment %2d  ",i);
	    printf("Length %5d  ",j);
	    printf("Start Adr 0x%04x",(int)locn[i].l_start);
	    if(locn[i].l_attrib == REL)
	      printf(" (rel)\n\n");
	    else
	      printf(" (abs)\n\n");
	    newpage();
	    j = 0;
	    k = (int)locn[i].l_start;
	    printf("%04x: ",k);
	    k += 16;
	    while(r < len) {
	      if(j > 16){
	        putchar('\n');
		newpage();
	        printf("%04x: ",k);
 	        k += 16;
	        j = 0;
	      }
	      printl(2, *r);
	      putchar(' ');
	      r++;
	      j++;
	    }
	    putchar('\n');
	    putchar('\n');
	    newpage();
	  }
	}

	if(*option('r')){
	  header(reltitle);
	  for(i=0; i < LCOUNT; i++) {
	    if(locn[i].l_limit){
	      r = locn[i].l_rel_n;
	      j = (int)(locn[i].l_limit - locn[i].l_start);
	      len = r + j;
	      putchar('\n');
	      printf("Segment %2d  ",i);
	      printf("Length %5d  ",j);
	      printf("Start Adr 0x%04x\n", (int)locn[i].l_start);
	      j = 0;
	      k = (int)locn[i].l_start;
	      printf("%04x: ",k);
	      k += 8;
	      while(r < len) {
	        if(j > 8){
	          putchar('\n');
		  newpage();
	  	  printf("%04x: ",k);
		  k += 8;
	          j = 0;
	        }
	        printl(4, *r);
	        putchar(' ');
	        r++;
   	        j++;
	      }
	      newpage();
	      putchar('\n');
	      putchar('\n');
	    }
	  }
	}
}

/*
 *   Generate header lines for listing.
 */
header(hp)
char *hp;
{
	register char *r;

	if(hp != 0){		/* update header title if new one specified */
	 r = ctitle;
	 while(*hp)
	   *r++ = *hp++;
	 *r = '\0';
	}

	putchar('\f');
	putchar('\n');
	printf("Page %-4d (%s)\t%s Assembler\n",
	        lpage++, srcnam, head.h_mac);
	printf("%s\n\n",ctitle);

	lline =	5;
	return;
}


/*
 *   Check to see whether a new	page is	needed or not.
 */
newpage()
{
	if (nline == 1){
	  header(0);
	  return;
	}

	if (!lline)  header(0);
		lline =	(lline + 1) % head.h_page;
	return;
}

warning(str)
register char *str;
{
	if (*option('e'))  return;
	fprintf(stderr,"%s %4d: warning: %s\n", srcnam, nline, str);
	return;
}

synerr(ptr)
register char *ptr;
{
	errcount++;
	length = 0;				/* no instruction */

	if (*option('e'))
	  return;

	fprintf(stderr,"%s %4d: %s\n", srcnam, nline, ptr);
	return;
}

char*
option(c)
register char c;
{
	if((c>='A')&&(c<='z'))
	 return(&flags[c-'A']);
	else
	 return(-1);
}

/*
 * output symbols to stdout
 */

prtsyms()

{
	register struct st *q;
	register int i;
	register int j;

	header(symtitle);

	/*
	 * search all the symbol buckets looking for
	 * symbols to print
	 */
	j = 0;

	for(i=0; i < fcharsz; i++){
	  if(fchar[i] != 0){
	    q = fchar[i];
prtsym:
	    printf("%-8s ",q->s_name);
	    printf("%04x ",q->s_value);
	    printf("[%04x] ",q->s_mode);
	    printf("   ");
	    if(++j > 2){
	      putchar('\n');
	      newpage();
	      j = 0;
	    }
	    if(q->s_next != 0){
	      q = q->s_next;
	      goto prtsym;
	    }
	  }
	}
	putchar('\n');
}


