PAGE 55,132
TITLE	PIPES
;
;=========================================================================
;
;     CORVUS/IBM PIPE INTERFACE UNIT FOR MICROSOFT
;		   PASCAL COMPILER
;	   MSDOS 1.x and 2.x CONSTELLATION II
;
;	   VERSION 1.00  BY  NORMAN O. DOYLE
;	     (MICROSOFT ASSEMBLER VERSION)
;
;
;	THIS UNIT IMPLEMENTS 8 PROCEDURES:
;
;		PipeOpRd   - Open a pipe for read
;		PipeOpWr   - Open a pipe for write
;		PipeStatus - Return the status of all files in a pipe
;		PipeRead   - Read data stored in a pipe
;		PipeWrite  - Write data to a pipe
;		PipeClRd   - Close a pipe that had been opened for read
;		PipeClWr   - Close a pipe that had been opened for write
;		PipePurge  - Purge a file from the pipe list
;
;=========================================================================
;			REVISION HISTORY
;
; FIRST VERSION :  8-15-84  BY NORMAN O. DOYLE
;
;=========================================================================
;
	EXTRN	CDSND_ASM:FAR, CDRCV_ASM:FAR
;
OpRead		EQU	0C01BH	; FUNCTION TYPE FOR OPEN FOR READ
OpWrite 	EQU	0801BH	; FUNCTION TYPE FOR OPEN FOR WRITE
ClRead		EQU	000FDH	; FUNCTION TYPE FOR CLOSE READ
ClWrite 	EQU	000FEH	; FUNCTION TYPE FOR CLOSE WRITE
PurgeFnc	EQU	0	; FUNCTION TYPE FOR PURGE
ClsPurCmd	EQU	0401AH	; COMMAND TO CLOSE/PURGE A PIPE
StatCmd 	EQU	0411AH	; COMMAND TO GET PIPE STATUS
RedCmd		EQU	0201AH	; COMMAND TO READ FROM A PIPE (BYTES 1 & 2)
RedCmd2 	EQU	00200H	; COMMAND TO READ FROM A PIPE (BYTES 4 & 5)
WrtCmd		EQU	0211AH	; COMMAND TO WRITE TO A PIPE (BYTES 1 & 2)
WrtCmd2 	EQU	00200H	; COMMAND TO WRITE TO A PIPE (BYTES 4 & 5)
ClsLen		EQU	5	; LENGTH OF DATA FOR A CLOSE/PURGE COMMAND
OpnLen		EQU	0000AH	; LENGTH OF DATA FOR A OPEN COMMAND
RedLen		EQU	5	; LENGTH OF DATA FOR A READ COMMAND
StatLen 	EQU	5	; LENGTH OF DATA FOR A STATUS COMMAND
WrtLen		EQU	517	; LENGTH OF DATA FOR A WRITE COMMAND
;
; ---- ALLOCATE MEMORY FOR THE COMMAND ----
;
DATSEG	SEGMENT 'DATA'
;
Cmd		DW ?		; COMMAND LENGTH FIELD
		DB ?		; COMMAND BYTE #1
		DB ?		; COMMAND BYTE #2
		DB 8 DUP(?)	; SPACE FOR PIPE NAME
		DB 506 DUP(?)	; EXTRA SPACE NEEDED FOR PIPE TABLES & PIPE READ
;
DATSEG	ENDS
PAGE
;
CODSEG	SEGMENT 'CODE'
	ASSUME	CS:CODSEG
;
	PUBLIC	PipeOpRd, PipeOpWr, PipePurge, PipeStatus
	PUBLIC	PipeRead, PipeWrite, PipeClRd, PipeClWr
;
	DB	'CORVUS MSDOS 1.x AND 2.x CONST. II PIPE UTILITY,'
	DB	' PASCAL VERSION AS OF 08-15-84'
;
;------------------------------------------------------------------------------
;
; PipeOpRd & PipeOpWr - THESE FUNCTIONS WILL OPEN A PIPE FOR READ OR
;			WRITE ACCESS.  THE CALLING SEQUENCE FROM
;			PASCAL IS:
;				X = PipeOpRd (Name);   AND
;				X = PipeOpWr (Name);
;			THEY ARE DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION PipeOpRd( Name: STRING ) : INTEGER; EXTERN;
;				FUNCTION PipeOpWr( Name: STRING ) : INTEGER; EXTERN;
;			THE TWELVE BYTES RETURNED FROM THE CDRCV_ASM ROUTINE ARE:
;				1 - DISK ERROR
;				2 - PIPE ERROR
;				3 - OPENED PIPE # (1-62)
;				4 - PIPE STATE
;			  5 to 12 - UNUSED
;			THESE FUNCTIONS WILL RETURN:
;				    > 0 - PIPE # OPENED
;			     -8 to  -15 - PIPE ERROR
;			   -128 to -255 - DISK ERROR
;
;------------------------------------------------------------------------------
;
PipeOpRd PROC	FAR
	MOV	BX,OpRead
	JMP	SHORT Start
PipeOpWr:
	MOV	BX,OpWrite
Start:
	PUSH	BP			; SAVE THE FRAME POINTER
	MOV	BP,SP			; SET A NEW ONE
;
	MOV	SI,6 [BP]		; GET ADDRESS OF NAME SENT
;
	MOV	AX,DATSEG
	MOV	ES,AX			; GET ES SEG ADDRESSABILITY
	ASSUME	ES:DATSEG		;  AND USE FOR LOCAL DATA
;
; ---- SET UP THE COMMAND STRING (Open with Read or Write) ----
;
	MOV	WORD PTR ES:[CMD],OpnLen
	MOV	WORD PTR ES:[CMD+2],BX		; BX CONTAINS THE COMMAND
;
; ---- INITIALIZE THE PIPE CMD NAME FIELD TO BLANKS ----
;
	CLD
	MOV	CX,8			; INIT ARRAY TO BLANKS
	MOV	AL,20H
	MOV	DI,OFFSET ES:Cmd
	ADD	DI,4			; POINT TO NAME STRING
	REP	STOSB
;
; ---- NOW LOAD THE ACTUAL NAME SENT INTO THE COMMAND STRING ----
;
	XOR	CX,CX			; INITIALIZE CX TO 0
	MOV	CL,BYTE PTR [SI]	; GET THE LENGTH OF THE COMMAND
	INC	SI			; POINT TO THE SEMAPHORE NAME
	MOV	DI,OFFSET ES:Cmd	; GET ADDRESS TO PUT THE NAME
	ADD	DI,4
	REP	MOVSB			; LOAD THE PASSED NAME INTO THE CMD STRING
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	DS			; SAVE DS
	PUSH	ES
	POP	DS			; SET DS=ES
	MOV	AX,OFFSET ES:Cmd
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:Cmd
	CALL	CDRCV_ASM
	POP	DS			; RESTORE DS
;
; ---- SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN VALUE
	MOV	DI,2			; SET OFFSET FOR DISK ERROR CHECK
	CMP	BYTE PTR ES:[CMD+2],0	; CHECK FOR DISK ERRORS
	JNE	Pipe_Err
	INC	DI			; SET OFFSET FOR PIPE ERROR CHECK
	CMP	BYTE PTR ES:[CMD+3],0	; CHECK FOR PIPE ERRORS
	JNE	Pipe_Err
	MOV	AL,BYTE PTR ES:[CMD+4]	; RETURN THE OPENED PIPE #
	JMP	SHORT EndPipe
Pipe_Err:
	MOV	AL,BYTE PTR ES:[CMD+DI] ; RETURN THE ERROR CODE
	NEG	AX
EndPipe:
;
; ---- CLEAN UP AND RETURN ----
;
	POP	BP
	RET
PipeOpRd ENDP
PAGE
;
;------------------------------------------------------------------------------
;
; PIPESTATUS - THIS FUNCTION WILL RETURN THE STATUS OF ALL FILES IN A PIPE.
;			THE CALLING SEQUENCE FROM PASCAL IS:
;				X = PipeStatus ( Name Table, Ptr Table)
;			IT IS DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION PipeStatus( Var Name: Nametbl;
;					 Var Ptrs: Ptrtbl ) : INTEGER; EXTERN;
;			THE 513 BYTES RETURNED FROM THE CDRCV_ASM ROUTINE ARE:
;				1 - DISK ERROR
;				2 - PIPE ERROR
;			 3 TO 513 - TABLE DATA (NAME or POINTER)
;			THIS FUNCTIONS WILL RETURN:
;				    = 0 - EVERYTHING OK
;			   -128 to -255 - DISK ERROR
;
;			NOTE : ALTHOUGH THE "CORVUS MASS STORAGE SYSTEMS GENERAL
;			       TECHNICAL INFORMATION" MANUAL GIVES AN OPTION
;			       TO REQUEST BOTH THE NAME AND POINTER TABLES
;			       WITH ONE COMMAND (SUBOP #2 = 0) THIS OPTION
;			       WILL NOT WORK WITH PRESENT SOFTWARE.  THE LARGEST
;			       RETURN BUFFER ALLOWED BY ROUTINE CDRCV_ASM IS 530
;			       BYTES WHILE THE COMMAND TO REQUEST BOTH BUFFERS
;			       NEEDS 1025 BYTES RETURNED FROM CDRCV_ASM.
;
;------------------------------------------------------------------------------
;
PipeStatus	PROC	FAR
;
	PUSH	BP		; SAVE THE FRAME POINTER
	MOV	BP,SP		; SET A NEW ONE
;
	MOV	SI,6 [BP]	; GET ADDRESS OF PTR TABLE
	MOV	CS:PtrTbl,SI	; SAVE PTR TABLE ADDRESS
	MOV	SI,8 [BP]	; GET ADDRESS OF NAME TABLE
	MOV	CS:NamTbl,SI	; SAVE NAME TABLE ADDRESS
;
	PUSH	DS		; SAVE DS REGISTER
	PUSH	ES		; SAVE ES REGISTER
	MOV	AX,DATSEG
	MOV	ES,AX		; GET ES SEG ADDRESSABILITY
	ASSUME	ES:DATSEG	;  AND USE FOR LOCAL DATA
;
; ---- SET UP THE COMMAND STRING TO GET THE NAME TABLE ----
;
	MOV	WORD PTR ES:[CMD],StatLen
	MOV	WORD PTR ES:[CMD+2],StatCmd
	MOV	BYTE PTR ES:[CMD+4],1			; SUBOP = NAME TABLE
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	ES
	POP	DS			; SET DS=ES
	MOV	AX,OFFSET ES:Cmd
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:Cmd
	CALL	CDRCV_ASM
;
; ---- CHECK FOR DISK ERRORS ----
;
	XOR	AX,AX			; ZERO OUT AX FOR RETURN VALUE
	CMP	BYTE PTR ES:[CMD+2],0	; CHECK FOR DISK ERRORS
	JE	NO_ERROR
	MOV	AL,BYTE PTR ES:[CMD+2]
	NEG	AX
	POP	ES			; RESTORE ES
	JMP	SHORT ENDSTAT
NO_ERROR:
;
; ---- LOAD THE NAME TABLE TO RETURN ----
;
	MOV	DI,CS:NamTbl		; GET THE ADDRESS OF THE NAME TABLE
	MOV	SI,OFFSET ES:[CMD+3]	; POINT TO BYTE 3 OF THE COMMAND STRING
	MOV	CX,200H
	POP	ES
	CLD
	REP	MOVSB			; MOVE FROM COMMAND STRING TO NAME TABLE
;
; ---- SET UP THE COMMAND STRING TO GET THE POINTER TABLE ----
;
	PUSH	ES				; SAVE ES
	PUSH	DS
	POP	ES				; SET ES=DS
	MOV	WORD PTR ES:[CMD],StatLen
	MOV	WORD PTR ES:[CMD+2],StatCmd
	MOV	BYTE PTR ES:[CMD+4],2		; SUBOP = POINTER TABLE
;
; ---- NOW SEND THE COMMAND ----
;
	MOV	AX,OFFSET ES:Cmd
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:Cmd
	CALL	CDRCV_ASM
;
; ---- CHECK FOR DISK ERRORS ----
;
	XOR	AX,AX			; ZERO OUT AX FOR RETURN VALUE
	CMP	BYTE PTR ES:[CMD+2],0	; CHECK FOR DISK ERRORS
	JE	NO_ERROR2
	MOV	AL,BYTE PTR ES:[CMD+2]
	NEG	AX
	POP	ES			; RESTORE ES
	JMP	SHORT ENDSTAT
NO_ERROR2:
;
; ---- LOAD THE PTR TABLE TO RETURN ----
;
	MOV	DI,CS:PtrTbl		; GET THE ADDRESS OF THE PTR TABLE
	MOV	SI,OFFSET ES:[CMD+3]	; POINT TO BYTE 3 OF THE COMMAND STRING
	MOV	CX,200H
	POP	ES
	CLD
	REP	MOVSB			; MOVE FROM COMMAND STRING TO NAME TABLE
ENDSTAT:
	POP	DS			; RESTORE DS
;
; ---- CLEAN UP AND RETURN ----
;
	POP	BP
	RET
;
NamTbl	DW	?			; ADDRESS OF NAME TABLE FOR STATUS COMMAND
PtrTbl	DW	?			; ADDRESS OF PTR TABLE FOR STATUS COMMAND
;
PipeStatus	ENDP
;
PAGE
;
;------------------------------------------------------------------------------
;
; PipeRead	      - THIS FUNCTION WILL READ A PIPE.  THE CALLING
;			SEQUENCE FROM PASCAL IS:
;				X = PipeRead (Pipe #, Buffer)
;			IT IS DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION PipeRead( Pn: INTEGER; Buffer: Diskbuf ) : INTEGER; EXTERN;
;			THE 516 BYTES RETURNED FROM THE CDRCV_ASM ROUTINE ARE:
;				1 - DISK ERROR
;				2 - PIPE ERROR
;				3 - LENGTH OF DATA READ (LSB)
;				4 -			(MSB)
;			 5 to 516 - DATA READ (512 BYTES MAX)
;			THIS FUNCTIONS WILL RETURN:
;				    > 0 - NUMBER OF BYTES READ
;			     -8 to  -15 - PIPE ERROR
;			   -128 to -255 - DISK ERROR
;
;------------------------------------------------------------------------------
;
PipeRead	PROC	FAR
;
	PUSH	BP			; SAVE THE FRAME POINTER
	MOV	BP,SP			; SET A NEW ONE
;
	MOV	DX,8 [BP]		; GET THE PIPE NUMBER PASSED
	MOV	SI,6 [BP]		; GET ADDRESS OF THE DATA SENT
	MOV	CS:ReadBfr,SI		; SAVE THE ADDRESS
;
	PUSH	DS			; SAVE THE DS SEGMENT REGISTER
	PUSH	ES			; SAVE THE ES SEGMENT REGISTER
	MOV	AX,DATSEG		; GET ES SEG ADDRESSABILITY
	MOV	ES,AX			;  AND USE FOR LOCAL DATA
	ASSUME	ES:DATSEG
;
; ---- SET UP THE COMMAND STRING TO WRITE DATA TO A PIPE ----
;
	MOV	WORD PTR ES:[CMD],RedLen
	MOV	WORD PTR ES:[CMD+2],RedCmd
	MOV	BYTE PTR ES:[CMD+4],DL		; PIPE # PASSED
	MOV	WORD PTR ES:[CMD+5],RedCmd2
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	DS			; SAVE DS
	PUSH	ES
	POP	DS			; SET DS=ES
	MOV	AX,OFFSET ES:CMD
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:CMD
	CALL	CDRCV_ASM
	POP	DS			; RESTORE DS
;
; ---- CHECK FOR ERRORS AND SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN
	MOV	DI,2			; SET OFFSET FOR DISK ERROR CHECK
	CMP	BYTE PTR ES:[CMD+DI],0	; CHECK FOR DISK ERRORS
	JNE	PipeRed_Err
	INC	DI			; SET OFFSET FOR PIPE ERROR CHECK
	CMP	BYTE PTR ES:[CMD+DI],0	; CHECK FOR PIPE ERRORS
	JNE	PipeRed_Err
	MOV	AX,WORD PTR ES:[CMD+4]	; RETURN THE LENGTH OF DATA READ
;
; ---- LOAD THE DATA READ TO RETURN IN THE BUFFER SENT ----
;
	MOV	SI,OFFSET ES:[CMD+6]	; SET UP SEGMENT OFFSET FOR CMD STRING
	MOV	DI,CS:ReadBfr		; SET UP SEGMENT OFFSET FOR BUFFER SENT
	MOV	CX,AX			; NUMBER OF BYTES TO TRANSFER
	PUSH	DS			; SET DS TO WHAT ES WAS AND THEN
	PUSH	ES			;  SET ES TO WHAT DS WAS
	POP	DS			;
	POP	ES			;
	CLD
	REP	MOVSB			; TRANSFER THE BYTES FROM CMD STRING
	POP	ES			; RESTORE THE ES SEGMENT REGISTER
	JMP	SHORT EndPipe_Red	;  TO THE BUFFER PASSED. (DS:SI-->ES:DI)
PipeRed_Err:
	MOV	AL,BYTE PTR ES:[CMD+DI] ; RETURN THE ERROR CODE
	NEG	AX
	POP	ES			; RESTORE THE ES SEGMENT REGISTER
EndPipe_Red:
;
; ---- CLEAN UP AND RETURN ----
;
	POP	DS
	POP	BP
	RET
;
ReadBfr DW	?			;ADDRESS OF PASSED READ BUFFER
;
PipeRead	ENDP
;
PAGE
;
;------------------------------------------------------------------------------
;
; PipeWrite	      - THIS FUNCTION WILL WRITE TO A PIPE.  THE CALLING
;			SEQUENCE FROM PASCAL IS:
;				X = PipeWrite (Pipe #, Len, Buffer)
;			IT IS DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION PipeRead( Pn: INTEGER; Len: INTEGER;
;					  Buffer: Diskbuf ) : INTEGER; EXTERN;
;			THE 12 BYTES RETURNED FROM THE CDRCV_ASM ROUTINE ARE:
;				1 - DISK ERROR
;				2 - PIPE ERROR
;				3 - LENGTH OF DATA WRITTEN (LSB)
;				4 -			   (MSB)
;			  5 to 12 - UNUSED
;			THIS FUNCTIONS WILL RETURN:
;				    > 0 - NUMBER OF BYTES WRITTEN
;			     -8 to  -15 - PIPE ERROR
;			   -128 to -255 - DISK ERROR
;
;------------------------------------------------------------------------------
PipeWrite	PROC	FAR
;
	PUSH	BP			; SAVE THE FRAME POINTER
	MOV	BP,SP			; SET A NEW ONE
;
	MOV	DX,10 [BP]		; GET THE PIPE NUMBER PASSED
	MOV	CX,8 [BP]		; GET THE LENGTH OF DATA TO WRITE
	MOV	SI,6 [BP]		; GET ADDRESS OF THE DATA SENT
;
	MOV	AX,DATSEG		; GET ES SEG ADDRESSABILITY
	MOV	ES,AX			;  AND USE FOR LOCAL DATA
	ASSUME	ES:DATSEG
;
; ---- SET UP THE COMMAND STRING TO WRITE DATA TO A PIPE ----
;
	MOV	WORD PTR ES:[CMD],WrtLen
	MOV	WORD PTR ES:[CMD+2],WrtCmd
	MOV	BYTE PTR ES:[CMD+4],DL		; PIPE # PASSED
	MOV	WORD PTR ES:[CMD+5],WrtCmd2
	MOV	DI,OFFSET ES:[CMD+7]		; GET ADDRESS TO PUT DATA STRING
	CLD
	REP	MOVSB				; LOAD THE PASSED STRING TO WRITE
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	DS			; SAVE DS
	PUSH	ES
	POP	DS			; SET DS=ES
	MOV	AX,OFFSET ES:CMD
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:CMD
	CALL	CDRCV_ASM
	POP	DS			; RESTORE DS
;
; ---- SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN
	MOV	DI,2			; SET OFFSET WHERE ERROR FOUND
	CMP	BYTE PTR ES:[CMD+DI],0	; CHECK FOR DISK ERRORS
	JNE	PipeWrt_Err
	INC	DI			; SET OFFSET FOR PIPE ERROR
	CMP	BYTE PTR ES:[CMD+DI],0	 ; CHECK FOR PIPE ERRORS
	JNE	PipeWrt_Err
	MOV	AX,WORD PTR ES:[CMD+4]	; RETURN THE LENGTH OF DATA WRITTEN
	JMP	SHORT EndPipe_Wrt
PipeWrt_Err:
	MOV	AL,BYTE PTR ES:[CMD+DI] ; RETURN THE ERROR CODE
	NEG	AX
EndPipe_Wrt:
;
; ---- CLEAN UP AND RETURN ----
;
	POP	BP
	RET
PipeWrite	ENDP
;
;
PAGE
;------------------------------------------------------------------------------
;
; PipeClRd & PipeClWr & PipePurge
;
;		      - THESE FUNCTIONS WILL CLOSE A PIPE THAT WAS OPENED
;			FOR READ OR WRITE ACCESS AND PURGE A FILE FROM THE
;			PIPE LIST.  THE CALLING SEQUENCE FROM PASCAL IS:
;				X = PipeClRd (Pipe #); and
;				X = PipeClWr (Pipe #); and
;				X = PipePurge (Pipe #);
;			THEY ARE DEFINED IN PASCAL AS FOLLOWS:
;				FUNCTION PipeClRd( Pn ) : INTEGER; EXTERN;
;				FUNCTION PipeClWr( Pn ) : INTEGER; EXTERN;
;				FUNCTION PipePurge( Pn ) : INTEGER; EXTERN;
;			THE TWO BYTES RETURNED FROM THE CDRCV_ASM ROUTINE ARE:
;				1 - DISK ERROR
;				2 - PIPE ERROR
;			THESE FUNCTIONS WILL RETURN:
;				    = 0 - EVERYTHING OK
;			     -8 to  -15 - PIPE ERROR
;			   -128 to -255 - DISK ERROR
;
;------------------------------------------------------------------------------
PipeClRd	PROC	FAR
	MOV	BX,ClRead
	JMP	SHORT STARTCL
PipeClWr:
	MOV	BX,ClWrite
	JMP	SHORT STARTCL
PipePurge:
	MOV	BX,PurgeFnc
;
STARTCL:
	PUSH	BP			; SAVE THE FRAME POINTER
	MOV	BP,SP			; SET A NEW ONE
;
	MOV	SI,6 [BP]		; GET PIPE # SENT
;
	MOV	AX,DATSEG		; GET ES SEG ADDRESSABILITY
	MOV	ES,AX			;  AND USE FOR LOCAL DATA
	ASSUME	ES:DATSEG
;
; ---- SET UP THE COMMAND STRING (CLOSE READ/WRITE or PURGE) ----
;
	MOV	WORD PTR ES:[CMD],ClsLen
	MOV	WORD PTR ES:[CMD+2],ClsPurCmd
	MOV	AX,SI
	MOV	BYTE PTR ES:[CMD+4],AL		; PIPE # PASSED
	MOV	WORD PTR ES:[CMD+5],BX
;
; ---- NOW SEND THE COMMAND ----
;
	PUSH	DS			; SAVE DS
	PUSH	ES
	POP	DS			; SET DS=ES
	MOV	AX,OFFSET ES:CMD
	CALL	CDSND_ASM
	MOV	DI,OFFSET ES:CMD
	CALL	CDRCV_ASM
	POP	DS			; RESTORE DS
;
; ---- SET UP THE RETURN VALUE ----
;
	XOR	AX,AX			; CLEAR OUT AX FOR RETURN
	MOV	DI,2			; SET OFFSET WHERE ERROR FOUND
	CMP	BYTE PTR ES:[CMD+DI],0	; CHECK FOR DISK ERRORS
	JNE	PipeCl_Err
	INC	DI			; SET OFFSET FOR PIPE ERROR
	CMP	BYTE PTR ES:[CMD+DI],0	; CHECK FOR PIPE ERRORS
	JE	EndPipe_Cl
PipeCl_Err:
	MOV	AL,BYTE PTR ES:[CMD+DI] ; RETURN THE ERROR CODE
	NEG	AX
EndPipe_Cl:
;
; ---- CLEAN UP AND RETURN ----
;
	POP	BP
	RET
PipeClRd	ENDP
;
CODSEG	ENDS
	END
