/* Array is a sequential collection that holds other objects.
 Array objects are fixed in size; once you create one, it
 cannot hold more than the number of elements you specified.
 Literal arrays can be formed with the # format; for instance,
 an array with the elements 3, 7, and 8 can be formed by
 saying #(3 7 8).  */!!

/* inherit(IndexedCollection, #Array, nil, nil, nil) */!!

now(class(Array))!!

now(Array)!!

/* Return the element at self[index]. If
  index < 0 or index >= limit(self), then
  an out of bounds error is generated. */
 Prim at(self, index):ArrayElement!!


/* Return the contents of self from
  self[begIdx] to self[endIdx-1], inclusive,
  in the form of another Array object. For
  example, copyFrom(#(3 4 5), 0, 2) would
  return Array(3 4 ).

  If begIdx > endIdx, then a bad range
  error is generated.  */
 Prim copyFrom(self, begIdx, endIdx):Array!!


/* Fill the receiver with anObject. For
  example, to initialize an array called
  Scores so that all of its elements were
  zero, you would send the following
  message: fill(Scores, 0). */
Prim fill(self, anObject):Array!!

/* Return the index at which the target
  is located within self.  If the target is
  not found, then indexOf return nil
  instead. For example, indexOf(#(3 5 7),
  5) would return 1, but indexOf(#(3 5 7),
  10) would return nil.  find uses equality
  to find the target element.  */
 Prim find(self, target):Int!!



/* Return the index at which the target
  is located within self.  If the target is
  not found, then indexOf return nil
  instead. For example, indexOf(#(3 5 7),
  5) would return 1, but indexOf(#(3 5 7),
  10) would return nil.  indexOf is the
  same as find except that it uses
  equivalence as its searching criterion,
  so you should only use indexOf to locate
  a target for which equivalence is
  meaningful, such as Int, Char, or
  Symbol objects.  */
Prim indexOf(self, target):Int!!


/* Place anObject at self[index].  For
  instance, if Joe is an Array object, then
  Joe[3] := "Hello" is equivalent to the
  message put(Joe, "Hello", 3).  It return
  anObject; in the example above, "Hello"
  would be returned.  */
Prim put(self, anObject, index):anObject!!
