/* This class provides universal methods used by all control
 windows, such as Buttons and ScollBars.  Descendants of Control,
 such as Button and ScrollBar, define behavior for specific controls.  */!!

inherit(Object, #Control,
#(hCntl  /* Handle to the control */
parent  /* Parent object */
contID  /* Control ID */
cRect   /* Size rectangle */), 2, nil) !!

now(ControlClass) !!

now(Control) !!

/* Create and return a new control; save handle in hCntrl.
  wName is the name of the control, usually nil except
  for for buttons.  winClass is a string specifying
  class of control, e.g. "ListBox", and style is an integer
  which determines the exact style of the control object.
  Refer to the new methods of some of the descendants of Control
  to see how they use this method.  */
Def  create(self, wName, winClass, style | hnd, lpStr)
{	if wName
	then lpStr := Call GlobalLock(hnd := asHandle(wName))
	else lpStr := 0
	endif;

	if not(cRect)   /* cRect may be given by new message */
	then cRect := new(Rect); setSize(self)
	endif;

	hCntl := Call CreateWindow(asciiz(winClass), lpStr,
		style, left(cRect),  top(cRect),	width(cRect),  height(cRect),
		handle(parent),  contID, HInstance, NilData);
	if wName
	then 	Call GlobalUnlock(hnd);	Call GlobalFree(hnd);
	endif
} !!

/* Return control handle (hCntl).  */
 Def handle(self)
{ ^hCntl
}!!

/* This is the default version of setSize.  It simply returns the
  current value of cRect.  The descendants of Control will usually
  redefine this method.  */
 Def  setSize(self)
{  ^cRect;
}!!


/* Set the sizing rectangle to the specified Rect. */
 Def  setCRect(self, rect)
{  ^cRect := rect;
}!!


/* Move the window to the latest size, don't repaint. */
 Def   moveWindow(self)
{ Call MoveWindow(hCntl, left(cRect),  top(cRect),
  width(cRect),  height(cRect),  0)
}!!

/* Display the control according to val.  If val is 0,
  the control will be made hidden.  If val is one, the control
  is made visible.  */
 Def  show (self, val )
{ ^Call ShowWindow(hCntl, val)
}!!


/* Invalidate entire control for repaint. */
Def invalidate(self)
{	Call InvalidateRect(hCntl, 0, 0);
} !!

/* Send an MS-Windows message to a control.  wMsg is a message
  constant, such as LB_ADDSTRING, BM_SETCHECK, etc.  wP and lP
  provide additional information about the message being sent.  */
Def   sendMessage (self, wMsg, wP, lP)
{ ^Call SendMessage(hCntl, wMsg, wP, lP);
}!!


/*  Assign input focus to control.  Return hWindPrev, the handle
 which had the input focus.  */
Def   setFocus (self)
{	^Call SetFocus(hCntl);
} !!

