/* ErrorBox displays a string in a simple dialog box,
 making use of MS-Windows MessageBox function. */ !!

inherit(Object, #ErrorBox,	nil, nil, nil);!!

now(ErrorBoxClass) !!

/* Create a new ErrorBox error dialog with parent as
  the parent window, text as the dialog message text, cap
  as the caption.  The type of error dialog is specified
  via the type argument, which controls exactly what the
  error dialog looks like.  For more information, refer
  to the MS-Windows documentation concerning MessageBox.  */
Def new(self, parent, txt, cap, type | hTxt, hCap, ret)
{	hTxt := asHandle(txt);
	hCap := asHandle(cap);
	ret := Call MessageBox(handle(parent), 
		Call GlobalLock(hTxt), Call GlobalLock(hCap), type);
	Call GlobalUnlock(hTxt);
	Call GlobalUnlock(hCap);
	^ret;
}!!

now(ErrorBox) !!

