/* A frame is a collection of slots, each of which is
 a collection of facets.  */    !!

inherit(Dictionary, #Frame, #(name /* Symbolic name of frame */), 2, 1) !!


now(FrameClass) !!


/* Create and return a new frame with space for 4 slots and an
  automatic AKO slot. */
Def new(self, fName | fr)
  { fr := new(self:CollectionClass, 4);
  fr.name := fName;
  fr [#AKO] := new(Slot, #AKO);
  ^fr
  }!!

now(Frame) !!

/* Set a facet of one of this frame's
  slots. */
Def  set(self, slot, facet, val | sl)
{
  if not(sl := self[slot])
  then sl := self[slot] := new(Slot,
    slot);
  endif;
  ^sl[facet] := val;
} !!


/* Get a facet of one of this frame's
  slots. */
Def  get(self, slot, facet | sl)
{
  if not(sl := self[slot])
  then ^nil;
  else ^self [slot] [facet];
  endif;
} !!

/* Set the value facet of one of this
  frame's slots. */
Def  setValue(self, slot, val | sl)
{
  if not(sl := self[slot])
  then sl := self[slot] := new(Slot,
    slot);
  endif;
  ^sl[#value] := val;
} !!


/* Get the value facet of one of this
  frame's slots.  Use AKO inheritance if
  not found, and run the ifNeeded demon
  as a last resort.  */
Def  getValue(self, slot | sl, val)
{
  if not(sl := self[slot])
  then
    if not(sl := lookAKO(self, slot))
    then  ^runValueDemon(self, slot);
    else ^sl [#value];
    endif;
  else
    if not(val := sl [#value])
    then ^runValueDemon(self, slot);
    else ^val;
    endif;
  endif;
} !!

/* Look in the instance (AKO) chain for
  a slot with the correct name.  */
Def  lookAKO(self, slot | fr, sl)
{
  if (fr := self [#AKO] [#value])
  then
    if (sl := fr [slot])
    then  ^sl;
    else ^lookAKO(fr, slot);
    endif;
  else ^nil;
  endif;
} !!



/* Set the value facet of this frame's AKO slot. */
Def  setAKO(self, val)
  {
  ^self [#AKO] [#value] := val;
  }!!

/* Get the value facet of this frame's AKO slot. */
Def  getAKO(self)
  {
  ^self [#AKO] [#value];
  }!!

/* Print the frame onto the specified Stream.  */
Def printOn(self,strm)
  { printOn(name+"(", strm);
  do(self,
    {using(sl) printOn(sl, strm);
    printOn(' ',strm);
    });
  printOn(')',strm);
  }!!


/*  sysPrint the frame onto the specified Stream.
  sysPrintOn is the same as printOn for this class.  */

Def sysPrintOn(self,strm)
  { printOn(self, strm);
  }!!

/* Execute the value needed demon
  (block) for a slot. */
Def runValueDemon(self, slot | blk)
{
  if (blk := self [slot].ifNeeded)
  then setValue(self, slot, eval(blk));
  endif;
  ^nil
} !!


