/* A general-purpose dialog for getting input from the
 user.  The class's new message returns a string or nil.  */!!

inherit(ModalDialog,#InputDialog,#(
dTitle  /* Dialog title  */
dPrompt /* Prompt string */
dText   /* String entered by user */), 2, nil) !!

now(InputDialogClass) !!

/* Create and run an input dialog.
  The dialog's instance variables
  are all specified as arguments.
  The parent argument is the parent
  window of the dialog.  */
Def new(self, parent, title, prompt, txt  | theDlg)
{ theDlg := new(self:Behavior);
  setDialog(theDlg);
  theDlg.dTitle := title;
  theDlg.dPrompt := prompt;
  theDlg.dText := txt;
  if Call DialogBox(HInstance, INPUT_BOX, handle(parent),
     LpDFunc) > 0
  then ^leftJustify(theDlg.dText);
  endif; ^nil;
}!!


now(InputDialog) !!

/* Initialize the dialog text and caption. */
 Def  WM_INITDIALOG(self, wp, lp)
{  setText(self, dTitle);
   setItemText(self, FILE_EDIT, dText);
   setItemText(self, INPUT_MSG, dPrompt);
}!!

/* Handle dialog events. */
Def WM_COMMAND(self, wp, lp | val)
{
  select
    case  wp == IDOK
    is dText := getItemText(self, FILE_EDIT);
      Call EndDialog(handle, 1);
    endCase
    case wp == IDCANCEL
    is dText := nil;
      Call EndDialog(handle, 0);
    endCase
  endSelect;
  ^0;
}!!
