/* The Inspector class creates and manages Inspector windows,
 the windows which allow Actor users to inspect any object in
 the Actor system.  */   !!

inherit(ToolWindow, #Inspector,
#(target /* The object being inspected */
curList  /* The current listbox, lb1 or lb2 */
indices  /* True if the object being inspected has indices */), 2, nil) !!


now(InspectorClass) !!

/* Create a new Inspector window to inspect targ. */
Def new(self, parent, targ | inspects, theIns, offset, cl)
{ cl := Compiler.curClass :=
  class(targ);
  inspects :=
    TheApp.workspace.inspectors;
  offset := size(inspects) *     16;
  theIns := new(self:PopupWindowClass ,
    parent,
  "inspmenu",
  "Inspector: " + cl.name +
  ",limit=" + asString(limit(targ),10),
    rect(240 + offset, 50 + offset, 550 + offset, 240 + offset));
  add(inspects, theIns);
  theIns.target := targ;
  theIns.indices := isAncestor(cl, Set)
    or isAncestor(cl, IndexedCollection);
  ^theIns
} !!

now(Inspector) !!

/* Initialize the variable list box (lb1), upper left corner. */
 Def  initVarList(self)
{ do( variables(class(target)),
  {using(aStr) insertString(lb1, asciiz(aStr), -1)
  });
  invalidate(lb1);
}!!


/* Initialize the key list box (lb2), upper right corner. */
 Def initKeyList(self | addCode)
{
  if isIdx(target)
  then showWaitCurs(self);
    if indices
    then addCode := LB_INSERTSTRING
    else addCode := LB_ADDSTRING
    endif;
    keysDo(target,
    { using(aKey) sendMessage(lb2, addCode, -1,
      asciiz(aKey))
    });
    showOldCurs(self)
  endif
}!!

/* Close the inspector and remove from the master set of Inspectors. */
 Def WM_CLOSE(self, wP, lP )
{ Call DestroyWindow(hWnd);
  remove(TheApp.workspace.inspectors, self);
  ^0
}!!


/* Start new Inspector on the selected variable. */
Def inspSelVar(self | iv)
{
  if iv := getSelIdx(lb1)
  then inspect(ivIdx(target, asInt(iv)))
  endif
}!!


/* Start Inspector on the selected key. */
 Def inspSelKey(self | selKey)
{ if selKey := getSelString(lb2)
  then
    if indices
    then inspect(target[asInt(selKey, 10 )])
    else inspect(target[ asSymbol(selKey)])
    endif;
  endif;
}!!

/* Dispatch the various menu choices (Doit!, Inspect, etc.). */
Def  doMenuChoice(self, wP | strm, ot)
{
  select
    case wP == INSP_DOIT
    is  doLine(ew)
    endCase
    case wP == INSP_ISEL
    is inspectIt(ew);
    endCase
    case wP == INSP_IVAR
    is inspSelVar(self)
    endCase
    case wP == INSP_IKEY
    is inspSelKey(self)
    endCase
  default WM_COMMAND(ew, wP, 0);
  endSelect;
  ^1
} !! 
  
 

/* Handle the Inspector events. */
 Def    WM_COMMAND(self, wP, lP | strm)
{
  select
    case lP = 0   /* a menu choice */
    is doMenuChoice(self, wP)
    endCase
    case wP == INSP_VARS and high(lP) = LBN_SELCHANGE
    is curList := lb1;
      showData(self);
    endCase
    case wP == INSP_KEYS and high(lP) = LBN_SELCHANGE
    is  curList := lb2;
      showData(self)
    endCase
  endSelect;
  ^1;
}!!


/*  Show the data for the selected variable or key. */
 Def showData(self | iv, val, ot)
{
  if not(curList)
  then ^nil
  endif;
  showWaitCurs(self);
  if iv := getSelIdx(curList)
  then deleteSelText(ew);
    val := dataAsString(self, iv);
    ot := breakLines(val, 0, ew.xMax);
    insertLines(ew, ot);
    setFocus(ew)  /* optional? */
 endif;
  showOldCurs(self)
}!!


/* Return the selected data as a string for printing. */
 Def dataAsString(self, iv | aStrm, item)
{ item :=
  if curList == lb1
  then  ivIdx(target, asInt(iv))
  else
    if indices
    then target[ asInt( getSelString(curList), 10 ) ]
    else target[ asSymbol( getSelString(curList)) ]
    endif;
  endif;
  sysPrintOn(item, aStrm := streamOver(""));
  ^aStrm.collection
}!!


/* Start an Inspector:  Show the window, create listboxes,
  edit window, fill listboxes, display all. */
Def start(self)
  { show(self, 1);
  newSize := oldSize := asPoint(longAt(clientRect(self), 4));
  lb1 := new(ListBox, INSP_VARS, self);
  lb2 := new(ListBox, INSP_KEYS, self);
  ew := new(WorkEdit, 0, self);
  sizeKids(self);
  initVarList(self);
  show(lb1,1);
  initKeyList(self);
  show(lb2,1);
  show(ew,1);
  invalidate(ew);
  setFocus(ew);
  moveCaret(ew)
  } !!


/* Set compiler's class for target,
  pass the focus to the Inspector's edit window if it exists.  */
Def WM_SETFOCUS(self, wP, lP )
  {  Compiler.curClass := class(target);
  if ew
  then setFocus(ew);
  endif;
  ^0
  }!!
