/* Long is the class which can represent any integer which
 will fit in 32 bits, i.e. -2**31 to -(2**31)-1,
 (-2,147,483,648 to 2,147,483,647).  Long integers always
 appear with an 'L' after them, e.g. 34L, 23689L, etc.
 Although Actor will always print an upper case 'L', you
 can use either upper or lower case.  */ !!

/* inherit(Number, #Long, nil, nil, nil); */!!

now(class(Long));!!

now(Long);!!

/* Generality for Long objects.  Return 1.  */
Def generality(self)
{ ^1
}!!


/* Return the message used to coerce 
  other numerics to this class.  */
 Def converterFor(self)
{ ^#asLong;
}!!

/* Print the Long onto the specified
  Stream.  All integers by default display
  themselves in base 10.  */
Def printOn(self, aStrm)
{       nextPutAll(aStrm,
  leftJustify(asString(self, 10)));
}!!

/* sysPrint the Long onto the specified
  Stream.  Print an 'L' after it.  */
 Def sysPrintOn(self, aStrm)
{       printOn(self, aStrm);
  printOn(
  "L", aStrm);
}!!



/* Return self.  Included only so that
  you can send asLong messages to any
  number.  */
Def asLong(self)
{
}!!

/* Convert a packed point as received
  from Windows to an Actor point object.
  A "packed point" has the x coordinate
  stored in the lower two bytes of the
  Long, and the y coordinate is stored
  in the upper two bytes.  For example,
  asPoint(128000928L) returns 9210@1953. */
 Def asPoint(self)
{ ^point( asInt(low(self)),
  asInt(high(self)) )
}!!

/* Return a hash value based on the
  numeric contents (rather than the object
  pointer, which is how Int and Char
  objects are hashed). */
 Def hash(self)
{ ^asInt((high(self) bitXor low(self))
  bitAnd 0x3fff);
}!!


/* Sign-extend the low word (lower two
  bytes) of the receiver, and return the
  result. */
 Def extend(self)
{
  if self bitAnd 0x8000 > 0l
  then ^self bitOr 0xffff0000
  endif;
}!!


/* Multiplication operator.  Example:
  3L*4L. */
 Prim *(self, y):Long!!


/* Addition operator.  Example: 3L+4L. */
 Prim +(self, y):Long!!


/* Subtraction operator.  Example: 10L-2L. */
 Prim -(self, y):Long!!


/* Division operator.  If both operands
  are integers (i.e. either Ints or Longs),
  then integer division is performed.  For
  example, 3L/4L is 0, whereas 3.0/4 is
  0.75. Note that the receiver Long is
  actually the numerator, i.e. in the
  message 3L/4L, 3L receives the message. */
 Prim /(self, numerator):Long!!

/* Less than.  If the argument is less
  than the receiver, then this method
  return true.  In the message 14L<3L, 3L
  is the receiver of the < message and 14L
  is the argument.  */
 Prim <(self, y):Boolean!!

/* Less than or equal to.  If the
  argument is less than or equal to the
  receiver, then this method returns true.
  In the message 14L<=3L, 3L is the
  receiver of the <= message and 14L is the
  argument.  */
 Prim <=(self, y):Boolean!!


/* Not equal.  If the receiver is not
  equal to the argument, then this method
  returns true. In the message 14L<>3L, 3L
  is the receiver of the <> message and 14L
  is the argument. */
 Prim <>(self, y):Boolean !!


/* Equals.  If the receiver is equal to
  the argument, then this method returns
  true.  In the message 14L=3L, 14L is the
  receiver of the = message and 3L is the
  argument.  */
 Prim =(self, y):Boolean!!


/* Greater than.  If the argument is
  greater than the receiver, then this
  method returns true.  In the message
  14L>3L, 3L is the receiver of the >
  message and 14L is the argument.  */
 Prim >(self, y):Boolean!!


/* Greater than or equal to.  If the
  argument is greater than or equal to the
  receiver, then this method returns true.
  In the message 14L>=3L, 3L is the
  receiver of the >= message and 14L is the
  argument. */
 Prim >=(self, y):Boolean !!


/* Return true (specifically, return
  the asInt(self)) if the receiver is not
  zero.  */
Prim asBool(self):Boolean!!


/* Return a Char whose ASCII code is
  equal to the receiver.  For instance,
  asChar(32L) returns ' ' (a space).  */
 Prim asChar(self):Char!!


/* Return receiver as an Int.  If the
  receiver is too large to be converted
  into an Int, an error is generated.  */
Prim asInt(self):Int!!


/* Return self as a Real number.  For
  example, asReal(18L) returns 18..  */
Prim asReal(self):Real!!


/* Return the receiver as a String in
  the specified base.  For example,
  asString(100L,2) returns "1100100", which
  is what decimal 100L is in base 2.
  Any number can be displayed in
  hexadecimal format by using 16 as a base,
  for instance.  Bases from 2 to 36, inclusive,
  are defined.  */
Prim asString(self, base):String!!


/* Bitwise AND operator.  Return the
  result of the receiver bitwise ANDed with
  the argument.  */
 Prim bitAnd(self, y):Long!!


/* Bitwise OR operator.  Return the
  result of the receiver bitwise ORed with
  the argument.  */
 Prim bitOr(self, y):Long!!


/* Bitwise XOR operator.  Return the
  result of the receiver bitwise XORed with
  the argument.  */
 Prim bitXor(self, y):Long!!


/* Return the high order word (upper two
  bytes) of the receiver.  For example,
  high(3800788L) returns 57L.  */
Prim high(self):Long!!


/* Return the low order word (lower two
  bytes) of the receiver.  For example,
  low(78899L) returns 2467L.  */
 Prim low(self):Long!!


/* Modulus operator.  Return the
  remainder after dividing the argument by
  the receiver.  For instance, 7/5 is 1,
  with remainder 2.  Thus, 7L mod 5L is 2L. */
 Prim mod(self, y):Long !!

/* Return the negative of the receiver.
  For instance, negate(3L) returns -3L.
  negate(-49L) returns 49L.  Zero, of
  course, has no negative, so negate(0L) is
  0L.  */
 Prim negate(self):Long!!


/* Return true (specifically, it return
  the receiver Long) if the receiver is
  negative (less than zero).  Note that
  zero is neither negative nor positive.  */
 Prim negative(self):Boolean!!


/* Return true (specifically, it returns
  the receiver Long) if the receiver is
  positive (greater than zero).  Note that
  zero is neither negative nor positive.  */
 Prim positive(self):Boolean!!


/* Treats the Long as a Segment:Offset
  pair and return the contents of that
  memory location.  For instance, to peek
  at the contents of memory location
  000F:FD3E, you would send a
  wordAt(0xFFD3EL) message.  */
 Prim wordAt(self):Long!!


/* Return true (specifically, it returns
  0) if the receiver is zero.  */
 Prim zero(self):Boolean!!

