/* SourceFile class.  Objects are Actor source files, and
 can be loaded, modified, and have methods added or deleted.

 SourceFile I/O is buffered for performance.   */  !!

/* inherit(File, #SourceFile, #( buffer ), nil, nil) */ !!

now(SourceFileClass) !!

/* Create a new file for loading and editing Actor
  class source files. */
Prim new(self):SourceFile
!!

now(SourceFile) !!

/* Close the file and throw away buffer. */
 Def   close(self)
{  buffer := nil;
  ^close(self:File);
}!!

/* Backup original class source file, by moving it to the 
  BACKUP directory.  Then move source file in WORK
  directory to the CLASSES directory. */
Def bak_Save(self, class | name)
{ setName(self,
  "backup\" + name := getFileName(class));
  delete(self);
  setName(self,
  "classes\" + name);
  reName(self,
  "backup\" + name);
  setName(self,
  "work\" + name);
  reName(self,
  "classes\" + name);
} !! 
 


/*  If the specified class is in DirtyClasses, open the class source
  file for the class in the WORK directory.  Otherwise, open it in
  the CLASSES directory.  Return file. */
Def   openClass(self, class | dir)
{
  if class.name in DirtyClasses
  then dir := "work\";
  else dir := "classes\";
  endif;
  ^openClassInDir(self, class, dir);
}!!

/* Try to open specified class file in indicated directory.
  Example: openClassInDir(aSourceFile, Behavior, "CLASSES\").  */
Def   openClassInDir(self, class, dir)
{ setName(self, dir + getFileName(class));
  if open(self, 0)
  then ^true
  endif;
  errorBox(
  "Class Source File Error", class.name +
  " file not found in " + dir +
  ".");
  ^nil
} !!

/* Conditionally delete previous class file in WORK
  directory if the specified class is NOT found in
  DirtyClasses.  Otherwise, delete it.  Present a dialog box
  asking whether or not to rename previous file with
  a .BAK extension. */
Def condDelCFile(self, class | fName,
  bakName)
{ fName :=
  "work\" + getFileName(class);
  setName(self, fName);
  if open(self, 0) and not(class.name in
    DirtyClasses)
  then close(self);
    if IDYES = new(ErrorBox, ThePort,
      fName +
      " exists.  Should it be overwritten?",
      "File Conflict", MB_YESNO + MB_ICONEXCLAMATION)
    then delete(self);
    else setName(self, bakName :=
      subString(fName, 0, size(fName)-3) +
      "bak");
      delete(self);
      setName(self, fName);
      reName(self, bakName);
      errorBox(
      "File Renamed",
      "Old work file has .BAK extension.");
    endif;
  else close(self);
    delete(self);
  /* in any case */
  endif;
  ^fName
} !!


/* Create a new class source file with the specified
  class information array (see the ClassDialog class for
  format of this array). */
Def makeClassFile(self, array | fName)
{ fName := condDelCFile(self, Actor[array[0]]);
  setName(self, fName);
  create(self);
  checkError(self);
  do(3,
  {using(idx)  writeChunk(self, array[idx+1])
  });
  checkError(self);
  writeChunk(self,
  "now(" + array[0] + ")");
  close(self);
  checkError(self)
}!!

/* Update a class file with the specified array of class
  information.  Assumes that self is open and read-only.
  Only replace as many chunks as limit indicates. */
Def updateClassFile(self, array, limit | wFile, dir, fName)
{ wFile := new(SourceFile);
  setName(wFile, "temp.cls");
  create(wFile);
  checkError(wFile);
  do(limit,
  {using(idx)  readChunk(self);
    writeChunk(wFile, array[idx+1]);
  });
  copy(self, wFile, 100000L);
  close(self);
  close(wFile);
  checkError(self);
  checkError(wFile);
  fName := condDelCFile(self, Actor[array[0]]);
  reName(wFile, fName);
}!!


/* Load the text of aMethod from the open self.
  Note accordingly if the source code is missing. */
 Def  loadMethText(self, aMethod | methtext)
{ methtext := locateMethod(self, aMethod);
  close(self);
  checkError(self);
  if methtext
  then ^methtext[0]
  else ^aMethod +
    " source is unavailable."
  endif;
}!!

/* Write a chunk out to open file at current position. */
Def writeChunk(self, text)
{ write(self, text +  " !" +  "! " + CR_LF + CR_LF);
  checkError(self)
}!!

/* Write a method in the form of a TextCollection to open self. */
Def writeMeth(self, methtext)
{  write(self, CR_LF );
  do(methtext,
  {using(line)  write(self, line + CR_LF)
  });
  move(self, -2L);
  write(self,  " !" +  "! " + CR_LF +  " ");
  checkError(self)
}!!

/* Locate specified method in self, return
  an Array(methText, startPos, endPos) or nil
  if not found.  Assumes an open self. */
Def   locateMethod(self, methName | text, found, pos, lex tok)
{ lex := new(ActorAnalyzer);
  lex.createFlag := nil;
  pos := 0;
  loop
  while (lex.collection :=
    readChunk(self)) and not(found)
  begin reset(lex);
    if (tok := getToken(lex)) == 272
      or tok == 300	/* a method? */
    then getToken(lex);	 /* get method name */
      found := (lex.val ==
        asSymbol(methName))    /* match? */
    endif;
    if found
    then found := move(self, 0L);
      text := lex.collection;
    else pos := move(self, 0L)
    endif;
  endLoop;
  if found
  then ^tuple(text, pos, found);
  else ^nil
  endif;
} !!

/* Delete specified method in a new file and return the newly
  created file or nil if the method fSym was not found.
  Assumes an open self. */
 Def   deleteMethod(self, fSym)
{ ^delReplMethod(self, nil, fSym, nil);
}!!

/* Delete or replace existing method with the new one in a new file,
  according to rFlag.  If rFlag is true, then the text for the specified
  method fSym is replaced with the text in the methText argument; if it
  is false, the method text is deleted.  Return the newly created
  file in either case. Assumes an open	self, leaves open. */
Def   delReplMethod(self, methtext, fSym, rFlag | wFile, found, pos)
{
  if found := locateMethod(self, fSym)
  then  moveTo(self, 0L);
    wFile := new(SourceFile);
    setName(wFile, "temp.cls");
    create(wFile);
    checkError(wFile);
    copy(self, wFile, found[1]);
    moveTo(self, found[2]);    /* move past old one */
    if rFlag    /* replace flag */
    then  write(wFile, CR_LF);
      writeMeth(wFile, methtext);    /* replace with new */
    endif;
  copy(self, wFile, 100000L);    /* write the rest */
  checkError(self);
    checkError(wFile);
    close(wFile);
  endif;
  ^wFile
}!!


/* Append object method to the source file, return
  the new file which is a copy of self plus the new
  method.  Assumes open self, leaves open. */
 Def   addObjectMeth(self, methtext | len, wF)
{ moveTo(self, 0L);
  wF := new(SourceFile);
  setName(wF,  "temp.cls");
  create(wF);
  checkError(wF);
  copy(self, wF, 100000L);
  checkError(self);
  checkError(wF);
  move(wF, -1L);  /*   backup past EOF */
 writeMeth(wF, methtext);
  close(wF);
  checkError(self);
  checkError(wF);
  ^wF;
}!!


/* Add the class method to self, return the new file,
 which is a copy of the old with plus the new method.
 Assumes an open self, leaves open. */
 Def   addClassMeth(self, methtext | wFile, pos)
{ moveTo(self, 0L);
  do(3,
  {using(idx)  readChunk(self)
  });
  checkError(self);
  pos := move(self, 0L);
  wFile := new(SourceFile);
  setName(wFile,
  "temp.cls");
  create(wFile);
  checkError(wFile);
  moveTo(self, 0L);
  copy(self, wFile, pos);
  checkError(self);
  writeMeth(wFile, methtext);  /* write the method */
  copy(self, wFile, 100000L);  /* copy the rest */
  close(wFile);
  checkError(wFile);
  ^wFile
}!!


/* Get the next chunk from self, return as a string. */
Prim getChunk(self): chunk!!

/* Initialize the buffer and position for self. */
Prim init(self):self!!

/* Load the Actor source file with the specified DOS filename,
  e.g. "CLASSES\SOURCEFI.CLS". */
Prim load(self, filename):self!!

/* Open the source file for reading and/or writing.
 Return the handle if able to open, otherwise return nil. */
Prim open(self, type):Boolean !!

/* Read in the next chunk in the open source file. */
Prim readChunk(self):chunkString !!

/* Redefine moveTo for buffered reads. */
Def moveTo(self, pos)
{ position := 0;
  buffer := "";
  ^moveTo(self:File, pos);
} !!

