/* You can execute Actor source code from the Browser, Inspector
  and Workspace  edit windows  because they are both instances of this
  class, the WorkEdit class.  Instances of WorkEdit are child
  windows (unless overridden) which can execute Actor statements.  */!!

inherit(EditWindow, #WorkEdit,
#(parent  /* Parent window object */
cRect     /* The sizing rectangle */
iD        /* Control id */), 2, nil) !!

now(WorkEditClass) !!

/* Create and return a child style edit window for workspaces.
  The id and par arguments specify the Control ID and parent
  window of the WorkEdit window, respectively.  */
Def new(self, id, par | theWnd)
{	theWnd := new(self:Behavior);
	setVars(theWnd, id, par);
	
	create(theWnd, par, "workedit", theWnd.cRect,
		WS_CHILD + WS_BORDER);

	Call SetWindowWord(handle(theWnd), 0, hash(theWnd));
	theWnd.paintStruct := static(new(Struct, 32));
	init(theWnd);
	^theWnd;
}!!

now(WorkEdit) !!

/* Set some of the WorkEdit object's instance variables. */
Def  setVars(self, id, par)
{	parent := par;
	cRect := new(Rect);
	hMenu := iD := id
} !!

/* Move the window to the latest size. */
Def   moveWindow(self)
{	^Call MoveWindow(hWnd, left(cRect), top(cRect),
		width(cRect), height(cRect), 0)
} !!

/* Return appropriate template string (e.g. if-then, do-endLoop, etc.). */
Def tempStr(self, wP)
{select
	case wP == TEMP_DO
	is ^" do(receiver, {using(elem)  });"
	endCase
	case wP == TEMP_IF
	is ^" if (cond) then (stmtList); endif;"
	endCase
	case wP == TEMP_IFEL
	is ^" if (cond) then (stmtList); else (stmtList); endif;"
	endCase
	case wP == TEMP_BLOCK
	is ^" {(using(elem)      }"
	endCase
	case wP == TEMP_CASE
	is ^" select case (cond) is (stmtList); endCase case (cond)
is (stmtList); endCase endSelect;"
	endCase
	case wP == TEMP_LOOP
	is ^" loop while (cond) begin (stmtList); endLoop;"
	endCase
	case wP == TEMP_NMETH
	is ^"/* comment */ Def  method(self)  { }"
	endCase
 endSelect;
} !!

/* Insert aStr into selected text at the position specified by pos. */
Def insertInSelection(self, aStr, pos | pt)
{	pt := advance(workText, startLine, startChar, pos);
	workText[pt.y] := insert(workText[pt.y], aStr, pt.x);
	startLine := endLine := pt.y;
	startChar := pt.x;
	endChar := pt.x + limit(aStr);
}!!

/* Format a template string and insert it at cursor. */
Def formatTemplate(self, aTemp)
{	deleteSelText(self);
	Lex.collection := aTemp; reset(Lex);
	insertLines(self, formatLines(Lex,xMax));
}!!

/* Insert TextCollection at endLine if blank,
  else after endLine. */
Def insertLines(self, ot)
{ startChar := 0;
  if size(workText[endLine]) = 0
  then remove(workText, endLine);
    endLine := endLine - 1
  endif;
  /* case where endLine is blank */
  startLine := endLine+1;
  endLine := max(endLine + size(ot), 0);
  insertAll(workText, ot, startLine);
  endChar := limit(workText[endLine]);
  repaint(self); hideCaret(self);
} !!


/* Compile the selected text. */
Def doIt(self, rcvr | aStrm, val, ot)
{	val := parse(getSelText(self), rcvr);
	sysPrintOn(val, aStrm := streamOver(""));
	ot := breakLines(aStrm.collection, 0, xMax);
	insertLines(self, ot);
}!!

/* Compile the current line or selected text. */
Def doLine(self)
{
  if not(isSelText(self))
  then  startChar := 0;
    endChar := limit(workText[startLine]);
  endif;
  /* if inspector, target is receiver */
  if findVar(class(parent), #target)
  then doIt(self, parent.target);
  else doIt(self, nil);
  endif;
} !!

/* Handle browser-specific edit window */
Def WM_COMMAND(self, wp, lp)
{
  select
    case wp == BR_REFORM
    is  reform(self);
    endCase
  default  WM_COMMAND(self:EditWindow, wp, lp)
  endSelect;
} !!

/* Translate CR into doLine, Ctrl-CR into CR.  */
Def     WM_CHAR(self, wp, lp)
{
  select
    case wp == 13
    is  doLine(self);
      ^0
    endCase
    case  wp = 10
    /*  ^CR on PCs  */
    is  WM_CHAR(self:EditWindow, 13, lp);
    endCase
  default  WM_CHAR(self:EditWindow, wp,
    lp);
  endSelect;
} !!

/* Run an Inspector on the result of
  evaluating the current selection. */
Def inspectIt(self | val)
{
  if not(isSelText(self))
  then  startChar := 0;
    endChar := limit(workText[startLine]);
  endif;
  /* if inspector, target is receiver */
  if findVar(class(parent), #target)
  then val := parent.target
  endif;
  inspect(parse(getSelText(self),val));
} !!


