
/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 1

             /PALC ASSEMBLER FOR CAPS MONITOR        VERSION 2

             /DEC-8E-OPALA-A-LA
             /30 MARCH 1973                          HJ
             /COPYRIGHT 1972,1973  DIGITAL EQUIPMENT CORPORATION
             /       MAYNARD, MASSACHUSETTS 01754

             DECIMAL

       0002  VERSION=2

             OCTAL

             /PALC IS AN 8K THREE PASS ASSEMBLER DESIGNED
             /TO BE COMPATIBLE WITH THE CAPS SYSTEM.

             /PASS 1 READS THE INPUT (SOURCE) FILE AND CONSTRUCTS
             /THE SYMBOL TABLE.

             /PASS 2 GENERATES THE BINARY (OBJECT) FILE, WHICH
             /MAY BE LOADED WITH THE ABSOLUTE (BINARY) LOADER.

             /PASS 3 GENERATES THE OCTAL SYMBOLIC ASSEMBLY
             /LISTING.

             /PALC IS COMPATIBLE IN MOST RESPECTS WITH OS/8 PAL8-V7


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 2



             /OPTIONS:
             /K      CHECK FOR MORE THAN 8K OF CORE (DEFAULT IS 8K)
             /S      NO SYMBOL TABLE - ONLY IF LISTING
             /N      NO LISTING      - ONLY IF LISTING
             /D      DDT TYPE SYMBOL - ONLY IF LISTING
             /T      CR-LF NOT FF    - ONLY IF LISTING
             /H      NO PAGING       - ONLY IF LISTING

             /PSEUDO-OPS:
             /DECIMAL        RADIX TO BASE 10
             /EJECT          CAUSES A SKIP TO A NEW PAGE, AND IF
             /               THE EJECT IS FOLLOWED BY TEXT, THAT TEXT BECOMES
             /               THE NEW HEADER LINE
             /ENPUNCH        ENABLE PUNCHING
             /EXPUNGE        REMOVE ALL SYMBOLS
             /FIELD          SET FIELD
             /FIXMRI         DEFINE MEMORY REFERENCE INSTRUCTION
             /FIXTAB         MAKE ALL SYMBOLS PERMANENT
             /IFDEF          CONDITIONAL ON DEFINITION
             /IFNDEF         CONDITIONAL ON UNDEFINED
             /IFNZRO         CONDITIONAL ON NON-ZERO
             /IFZERO         CONDITIONAL ON ZERO
             /NOPUNCH        DISABLE PUNCHING
             /OCTAL          RADIX TO BASE 8
             /PAGE           RE-ORIGIN TO BEGINNING OF NEXT PAGE OR PAGE N
             /PAUSE          ALTERNATE END-OF-FILE
             /TEXT           6 BIT TEXT
             /XLIST          LISTING INHIBIT UNLESS THE XLIST IS
             /               FOLLOWED BY AN EXPRESSION. THEN IF THE EXPRESSION
             /               IS 0 START LISTING, OR NON-0 THEN INHIBIT LISTING
             /ZBLOCK         RESERVE BLOCK OF ZEROS

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 3



             /SYMBOL LAYOUT:
             /       WORD 1  BIT 0=1 PERMANENT SYMBOL
             /               BIT 1=1 "I" OR "Z"
             /               BITS 3-11       CHARS 1 AND 2
             /
             /       WORD 2  BIT 0=1 MEMORY REFERENCE INSTRUCTION
             /               BITS 2-11       CHARS 3 AND 4
             /
             /       WORD 3  BIT 0=1 PSEUDO-OP
             /               BITS 2-11       CHARS 5 AND 6
             /
             /       WORD 4  BITS 0-11       OCTAL VALUE
             /CHARS ARE STORED AS:
             /       A TO Z ARE 01 TO 32
             /       0 TO 9 ARE 33 TO 44
             /
             /       CHAR1^45+CHAR2

             /OPERATORS:
             /+              TWO'S COMPLEMENT ADD
             /-              TWO'S COMPLEMENT SUBTRACT
             /&              BOOLEAN AND
             /!              BOOLEAN INCLUSIVE OR
             /  (SPACE)      DELIMITER OR INCLUSIVE OR
             /^              MULTIPLY (REPEATED ADDITION)
             /%              DIVIDE (REPEATED SUBTRACTION)

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 4


             /DEFINITIONS

       4400          FIXMRI  CALL=4400

             /TABLE OF ERROR MESSAGE DEFINITIONS

       5172  IZ="I-240^100+"Z-240    /ILLEGAL PAGE ZERO REFERENCE
       6563  US="U-240^100+"S-240    /UNDEFINED SYMBOL
       5160  IP="I-240^100+"P-240    /ILLEGAL PSEUDO-OP USAGE
       6345  SE="S-240^100+"E-240    /SYMBOL TABLE EXCEEDED
       7245  ZE="Z-240^100+"E-240    /PAGE ZERO EXCEEDED
       6045  PE="P-240^100+"E-240    /CURRENT PAGE EXCEEDED
       5143  IC="I-240^100+"C-240    /ILLEGAL CHARACTER
       5144  ID="I-240^100+"D-240    /ILLEGAL DEFINITION
       4245  BE="B-240^100+"E-240    /PUSH-DOWN OVERFLOW
       4445  DE="D-240^100+"E-240    /DEVICE ERROR
       4446  DF="D-240^100+"F-240    /DEVICE FULL
       5145  IE="I-240^100+"E-240    /ILLEGAL EQUATE
       6050  PH="P-240^100+"H-240    /PHASE ERROR
       5151  II="I-240^100+"I-240    /ILLEGAL INDIRECT
       6244  RD="R-240^100+"D-240    /REDEFINITION
       6557  UO="U-240^100+"O-240    /UNDEFINED ORIGIN


             /ABBREVIATIONS
             /CR/LF  CARRIAGE RETURN/LINE FEED (215,212)
             /F/F    FORM FEED (214)

             / MONITOR INTERFACE LOCATIONS
       7602          KBDIN=7602      /LAST CHARACTER TYPED
       7002          LOOKUP=7002     /LOOKUP A FILE
       7200          UTIL=7200       /CASSETTE FUNCTIONS ROUTINE
       7000          BSIZE=7000      /SIZE OF DATA BLOCK
       6600          HANDLER=6600    /ENTRY POINT OF HANDLER
       6400          CLOSE=6400      /CLOSE OUTPUT FILE
       7402          TTOCHR=7402     /TYPE CHAR ROUTINE
       7626          KBDCHR=7626     /INPUT A CHAR ROUTINE
       6200          WAIT=6200       /WAIT FOR I/O COMPLETE
       6404          ENTER=6404      /CREATE OUTPUT FILE
       7413          TTCHCT=7413     /NUMBER OF CHARS WAITING TO TYPE
       0030          TTSIZE=30       /INITIAL SIZE OF BUFFER
       7410          TTSIZ=7410      /TOTAL SIZE OF BUFFER
       7406          LPCHCT=7406     /NUMBER OF CHARS WAITING TO PRINT
       0002          LPSIZE=2        /INITIAL SIZE OF BUFFER
       7414          LPSIZ=7414      /LOCATION CONTAINING COUNT OF BUFFER SPACE
       7400          LPOCHR=7400     /SUBROUTINE FOR LINE PRINTER
       7734          TTBUFR=7734     /BEGINING OF TELETYPE BUFFER
       7731          LPBUFR=7731     /BEGINING OF LINE PRINTER BUFFER
       7403          SINCH=7403      /SPOT FOR OUTPUT FILENAME FOR ENTER
       0200          BLSIZE=200      /SIZE OF CASSETE BLOCK
       0040          HDSIZE=40       /SIZE OF STANDARD HEADER RECORD
       7400          MPARAM=7400     /MONITOR OPTIONS WORD 1
       7531          DATEWD=7531     /MONITOR DATE LOCATION
       7427          BVERNO=SINCH+24 /VERSION NUMBER OF BINARY FILE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 5


             /PAGE ZERO

       0004  *4
00004  0000  FORMF6, 0               /USED IN DECIMAL PRINT ROUTINE
00005  0000  FORMF7, 0               /FOR STORAGE
00006  0000  LISOU2, 0               /STORAGE DURING PASS 3 OUTPUT
00007  7770  LEADER, -10             /LEADER-TRAILER CONSTANT

             /AUTOINDEX REGISTERS
             /PRESET FOR ONCE ONLY CODE

       0010          *10
00010  1613  PDLXR,  PDLST           /PUSH-DOWN AUTO INDEX REGISTER
00011  0000  TAGXR,  0               /TAG AUTO INDEX REGISTER
00012  2130  XREG1,  DSWIT1-1        /GENERAL AUTO INDEX REGISTER
00013  2145  XREG2,  DSWIT2-1        /GENERAL AUTO INDEX REGISTER

             /NOT USED AS AUTO INDEX REGISTERS
             /EXCEPT DURING ONCE ONLY CODE
00014  1530  LAST1,  DATE-1          /LAST DEFINED SYMBOL
00015  7530  LAST2,  DATEWD-1
00016  1202  LAST3,  SYMPRT+3-1
00017  1235  LAST4,  SYMPR9-2-1

       0020          *20
00020  0000  TAG1,   0               /TAG STORAGE
00021  0000  TAG2,   0
00022  0000  TAG3,   0

00023  0200  LITPTR, 200             /LITERAL POINTER

00024  0000  RADIX,  0               /NON-ZERO IF DECIMAL MODE
00025  0000  PUNCHX, 0               /NON-ZERO IF NO PUNCHING
00026  0000  XLISTX, 0               /NON-ZERO IF NO LISTING
             /*NOTE* PUNCHX AND XLISTX MUST BE TOGETHER
             /AND IN THIS ORDER

00027  0200  LOC,    200             /CURRENT LOCATION

00030  0000  OP,     0               /LAST OPERATOR CODE (0-6)
00031  0000  VALUE,  0               /EXPRESSION VALUE
00032  0000  VALUE2, 0               /EXPRESSION OPERAND

00033  0000  TXTSWT, 0               /SPACE SWITCH
00034  1734  TXTPTR, LINBUF+120      /TEXT POINTER
00035  0000  CHAR,   0               /CURRENT CHARACTER

00036  0000  THISPG, 0               /OVERFLOW PAGE
00037  0000  EDITPG, 0               /EDITOR PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 6



00040  0000  TEMP,   0               /TEMPORARY REGISTERS
00041  0000  TEMP1,  0
00042  0000  TEMP2,  0
00043  0000  TEMP3,  0
00044  6601  OCHAR,  OUTPUT          /OUTPUT ROUTINE
00045  7253  ICHAR,  INPUT           /INPUT ROUTINE
00046  3362  OERROR, OTYPEO          /PASS 1=OTYPEO; 2=OTYPEO; 3=LISOUT
00047  7776  PASS,   -2              /-1 IF PASS 1
                                     /0 IF PASS 2
                                     /1 IF PASS 3
00050  0200  IOMON,  200             /USER SERVICE ROUTINES
00051  0000  CONDSW, 0               /NUMBER OF NESTED CONDITIONALS
00052  0000  EXPIND, 0               /0 IF MRI OK HERE
                                     /NOT 0 IF MRI NOT OK HERE
00053  0000  CHKSUM, 0               /BINARY CHECK SUM
00054  0000  IZIND,  0               /"I" AND "Z" INDICATOR
                                     /IF I, LEFT 6 BITS ARE NON-ZERO
                                     /IF Z, RIGHT 6 BITS ARE NON-ZERO
00055  0000  THISTG, 0               /ASSIGNED NUMBER OF CURRENT TAG
00056  0143  HIGHTG, SYME-SYMS-4%4   /ASSIGNED NUMBER OF LAST TAG
00057  0000  LINCNT, 0               /LINE COUNT
00060  0000  ALPHAI, 0               /UNDEFINED TAG INDICATOR
                                     /-1 IF UNDEFINED
00061  0000  GETCI,  0               /NOT=0 IF ONLY CARRIAGE RETURN ENDS LINE
                                     /OTHERWISE /,;, OR CARRIAGE RETURN ENDS
00062  0000  LSTCNT, 0               /TAB COUNTER
00063  0000  UNDFSW, 0               /UNDEFINED SWITCH
00064  0000  LINKSW, 0               /OFF-PAGE LINK SWITCH
                                     /0 IF NO LINK GENERATED
                                     /0700 IF LINK
00065  0000  LININD, 0               /BACK-UP FOR LINKSW
00066  5126  PERROR, PERRO1          /DUMMY ERROR ROUTINE TO SUPPRESS CERTAIN
                                     /MESSAGES DURING PASS 1
00067  0260  FLDIND, "0              /CURRENT FIELD IN ASCII DIGIT FORM
00070  0000  PTR,    0
00071  0000  KNT,    0
00072  0000  CNT,    0
00073  0000  SPTR,   0
00074  0000  IPTR,   0
00075  0000  UNIT,   0

       0200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 7



             /STARTING ADDRESS OF PAL8 (0200)
             /CHAINING ADDRESS (0201)

00200  7300  NAME1,  CLA CLL         /NAME1-NAME3 USED LATER
00201  5602  NAME2,  JMP I .+1       /TO STORE TAGS AS THEY ARE BUILT
00202  1600  NAME3,  BEGIN
00203  0000  GETTA2, 0               /BUILDING SWITCH AND OVERFLOW PROTECT


             /HANDLERS FOR NOPUNCH AND ENPUNCH PSEUDO-OPS

00204  7201  NOPUNX, CLA IAC         /NON-ZERO FOR NO PUNCHING
00205  3025  ENPUNX, DCA PUNCHX      /ZERO FOR PUNCHING
00206  5577          JMP I [LOOKEX   /--EXIT TO MAIN--


             /HANDLERS FOR DECIMAL AND OCTAL PSEUDO-OPS

00207  7201  DECIMX, CLA IAC         /NON-ZERO FOR DECIMAL RADIX
00210  3024  OCTALX, DCA RADIX       /ZERO FOR OCTAL RADIX
00211  5577          JMP I [LOOKEX   /--EXIT TO MAIN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 8



             /**********************************************************
             /GET A TAG ROUTINE
             /PICKS UP A TAG AND SEARCHES FOR IT
             /"THISTG" HAS NUMBER OF TAG
             /"VALUE2" HAS VALUE
             /SKIPS IF FOUND

00212  0000  GETTAG, 0
00213  3200          DCA NAME1       /CLEAR BUILD AREA
00214  3201          DCA NAME2
00215  3202          DCA NAME3
00216  1176          TAD [NAME1-1
00217  3352          DCA GETTA4      /SET POINTER FOR BUILDING
00220  3203          DCA GETTA2      /ZERO SWITCH
00221  1035  GETTG1, TAD CHAR        /GET THE CHARACTER
00222  0175          AND [77         /MAKE IT 01-32 OR 60-71
00223  1377          TAD (-32        /WAS IT A TO Z?
00224  7540          SMA SZA
00225  1376          TAD (-25        /NO - MAKE 60-71 INTO 33-44
00226  1375          TAD (32         /YES - IT IS NOW 01-32 OR 33-44
00227  2203          ISZ GETTA2      /LEFT SIDE?
00230  5324          JMP GETTA3      /YES
00231  1752          TAD I GETTA4    /NO - RIGHT SIDE
00232  3752          DCA I GETTA4    /BUILD THE WORD
00233  4574  GETTA1, JMS I [GETC     /GET NEXT CHARACTER
00234  4573          JMS I [TSTALN   /IS IT ALPHANUMERIC?
00235  5221          JMP GETTG1      /YES - KEEP BUILDING
00236  1056          TAD HIGHTG      /NO - GET NUMBER OF HIGHEST TAG
00237  7110          CLL RAR         /DIVIDE BY 2
00240  3042          DCA TEMP2       /SAVE DIFFERENCE
00241  3055          DCA THISTG      /START AT TAG ZERO
00242  7120          CLL CML         /LINK MUST BE ON INITIALLY
00243  3041          DCA TEMP1


             /GETTA4 IS POINTER TO NAME1-NAME3
             /FOR DEPOSITING TAG AS IT IS BUILT

             /TEMP2 IS # OF TAGS TO SKIP BETWEEN CHECKS FOR MATCH
             /DURING BINARY SEARCHING

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 9




00244  7430  GETTG2, SZL             /IS THISTG HIGHER THAN TAG?
00245  5312          JMP GETTG3      /NO-LOWER
00246  3041  GETTG4, DCA TEMP1       /CLEAR LAST TIME SWITCH
00247  7420          SNL
00250  2041          ISZ TEMP1       /SET LAST TIME SWITCH TO 1
00251  1042          TAD TEMP2       /GET # OF TAGS TO SKIP
00252  7420          SNL
00253  7041          CIA
00254  1055          TAD THISTG      /INCREASE OR DECREASE TAG NUMBER
00255  3055          DCA THISTG
00256  1042          TAD TEMP2       /GET NUMBER
00257  7110          CLL RAR         /DIVIDE BY 2
00260  7450          SNA             /IS RESULT 0?
00261  2041          ISZ TEMP1       /YES-BUMP LAST TIME SWITCH
00262  7450          SNA
00263  7001          IAC             /IF RESULT WAS 1, MAKE IT 2
00264  3042          DCA TEMP2       /SAVE IT FOR NEXT TIME
00265  4572          JMS I [FINDTG   /GET THE TAG
00266  1171          TAD [1777       /MASK
00267  0020          AND TAG1        /GET WORD 1
00270  7141          CLL CIA
00271  1200          TAD NAME1       /DOES IT MATCH?
00272  7640          SZA CLA
00273  5244          JMP GETTG2      /NO - TRY NEXT TAG
00274  7350          CLL CLA CMA RAR /AC=3777
00275  0021          AND TAG2        /YES - GET WORD 2
00276  7141          CLL CIA
00277  1201          TAD NAME2       /DOES IT MATCH?
00300  7640          SZA CLA
00301  5244          JMP GETTG2      /NO - TRY NEXT TAG
00302  7350          CLL CLA CMA RAR /AC=3777
00303  0022          AND TAG3        /YES - DOES IT MATCH?
00304  7141          CLL CIA
00305  1202          TAD NAME3
00306  7640          SZA CLA
00307  5244          JMP GETTG2      /NO - TRY NEXT TAG
00310  2212          ISZ GETTAG      /YES - INCREMENT RETURN ADDRESS-MATCH
00311  5612          JMP I GETTAG    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 10



00312  7344  GETTG3, CLL CLA CMA RAL /AC=7776
00313  1041          TAD TEMP1       /LAST TIME SWITCH = 2?
00314  7640          SZA CLA
00315  5246          JMP GETTG4      /NO-KEEP TRYING
00316  2055          ISZ THISTG      /YES-QUIT SEARCHING
00317  3032          DCA VALUE2
00320  3020          DCA TAG1
00321  3021          DCA TAG2
00322  3022          DCA TAG3        /TAG NOT FOUND
00323  5612          JMP I GETTAG    /--RETURN--


00324  2352  GETTA3, ISZ GETTA4      /BUMP POINTER
00325  3752          DCA I GETTA4    /SAVE TIMES 1
00326  1752          TAD I GETTA4
00327  7106          CLL RTL         /TIMES 4
00330  3203          DCA GETTA2      /SAVE TIMES 4
00331  1203          TAD GETTA2
00332  7106          CLL RTL         /TIMES 20
00333  7004          RAL             /TIMES 40
00334  1203          TAD GETTA2      /40+4 = TIMES 44
00335  1752          TAD I GETTA4    /44+1 = TIMES 45
00336  3752          DCA I GETTA4    /SET LEFT SIDE
00337  1352          TAD GETTA4
00340  1374          TAD (-GETTA2
00341  7004          RAL
00342  7264          CLA CML CMA RAL /-1 IF TOO MANY; -2 IF O.K.
00343  3203          DCA GETTA2
00344  2203          ISZ GETTA2
00345  5233          JMP GETTA1
00346  7240          CLA CMA
00347  1352          TAD GETTA4
00350  3352          DCA GETTA4      /BACK UP POINTER
00351  5233          JMP GETTA1

00352  0177  GETTA4, NAME1-1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 11


             /IGNORE SPACES ROUTINE

00353  0000  SPNOR,  0
00354  1035          TAD CHAR        /GET THE CHARACTER
00355  1170          TAD [-240       /IS IT A SPACE?
00356  7640          SZA CLA
00357  5753          JMP I SPNOR     /NO --RETURN--
00360  4574          JMS I [GETC     /YES - GET NEXT CHARACTER
00361  5354          JMP SPNOR+1     /LOOP


             /HANDLER FOR PAUSE PSEUDO-OP
             /END-OF-TAPE OR END-OF-FILE

00362  7330  PAUSEX, CLL CLA CML RAR /AC=4000
00363  3035          DCA CHAR        /SET END-OF-LINE CHARACTER
00364  1167          TAD [LINBUF+120 /REINITIALIZE TEXT POINTER
00365  3034          DCA TXTPTR
00366  7240          CLA CMA
00367  3773          DCA I (INCHCT   /INDICATE EMPTY BUFFER
00370  2772          ISZ I (INEOF    /SET END-OF-FILE
00371  5577          JMP I [LOOKEX   /--EXIT TO MAIN--

00372  7302
00373  7300
00374  7575
00375  0032
00376  7753
00377  7746
       0400          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 12



             /HANDLER FOR ZBLOCK PSEUDO-OP
             /RESERVES AS MANY WORDS OF ZERO
             /AS VALUE OF EXPRESSION

00400  4566  ZBLOCX, JMS I [SPNOR    /IGNORE SPACES
00401  4565          JMS I [EXP      /GET THE EXPRESSION
00402  1031          TAD VALUE       /WAS IT ZERO?
00403  7041          CIA
00404  7450          SNA
00405  5577          JMP I [LOOKEX   /YES--EXIT TO MAIN--
00406  3043          DCA TEMP3       /NO - STORE NEGATIVE AS COUNTER
00407  4564  ZBLOCY, JMS I [PUNBIN   /OUTPUT ONE WORD OF ZERO
00410  1047          TAD PASS        /IS THIS PASS 3?
00411  7740          SMA SZA CLA
00412  3777          DCA I (PUNMOD   /YES - PREVENT OUTPUT
00413  2043          ISZ TEMP3       /NO - DONE YET?
00414  5207          JMP ZBLOCY      /NO - CONTINUE
00415  1376          TAD (JMS I [PUNONE      /YES - RESTORE PUNMOD
00416  3777          DCA I (PUNMOD
00417  5577          JMP I [LOOKEX   /--EXIT TO MAIN--


             /HANDLER FOR FIELD PSEUDO-OP

00420  4566  FIELDX, JMS I [SPNOR    /IGNORE SPACES
00421  4562          JMS I [DUMPS    /DUMP CURRENT PAGE LITERALS
00422  4561          JMS I [DUMPZ    /DUMP PAGE ZERO LITERALS
00423  4565          JMS I [EXP      /GET EXPRESSION
00424  1031          TAD VALUE       /TRIM TO RIGHT 3 BITS
00425  4775          JMS I (FIELDA   /SET FIELD DIGIT OF ADDRESS
00426  1047          TAD PASS        /IS THIS PASS 2?
00427  7640          SZA CLA
00430  5236          JMP FIELDY      /NO - PREPARE TO EXIT
00431  1031          TAD VALUE       /YES - GET FIELD NUMBER
00432  7106          CLL RTL
00433  7004          RAL             /AND CHANNELS 7 AND 8
00434  1160          TAD [7700
00435  4444          JMS I OCHAR     /OUTPUT FIELD SETTING
00436  4557  FIELDY, JMS I [CLEAN    /CLEAN UP THINGS
00437  1156          TAD [200        /RESET ORIGIN TO 200
00440  5256          JMP STAR1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 13





             /HANDLER FOR PAGE PSEUDO-OP

00441  4562  PAGEX,  JMS I [DUMPS    /DUMP SAME PAGE LITERALS
00442  4774          JMS I (XLISTZ   /ANY EXPRESSION?
00443  5251          JMP PAGEY       /NO
00444  4565          JMS I [EXP      /YES - GET EXPRESSION
00445  1031          TAD VALUE
00446  4555          JMS I [RTL6
00447  7004          RAL             /GET PAGE NUMBER
00450  5253          JMP STAR1-3

00451  1027  PAGEY,  TAD LOC         /NO ARGUMENT - FIND NEXT PAGE
00452  1176          TAD [177
00453  0154          AND [7600
00454  3031          DCA VALUE
00455  1031          TAD VALUE       /GET START OF PAGE
00456  4553  STAR1,  JMS I [PUNORG   /PUNCH ORIGIN
00457  4552          JMS I [FINDSP
00460  1151          TAD [LITBUF     /RESET POINTERS
00461  3040          DCA TEMP
00462  1440          TAD I TEMP
00463  3023          DCA LITPTR      /INITIALIZE LITERAL POINTER FOR NEW PAGE
00464  3014          DCA LAST1
00465  5550          JMP I [PUNVAL   /SEE ABOUT DUMPING SOURCE CODE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 14



             /HANDLER FOR =

00466  2060  EQUAL,  ISZ ALPHAI      /WAS TAG ALREADY DEFINED?
00467  7410          SKP
00470  4547          JMS I [INSRTG   /NO - PUT TAG INTO SYMBOL TABLE
00471  4574  EQUAL3, JMS I [GETC     /GET NEXT CHARACTER
00472  1055          TAD THISTG
00473  4546          JMS I [PUSHA    /STORE TAG NUMBER
00474  1060          TAD ALPHAI
00475  4546          JMS I [PUSHA    /STORE UNDEFINED INDICATOR
00476  4566          JMS I [SPNOR    /IGNORE SPACES
00477  4565          JMS I [EXP      /GET EXPRESSION TO RIGHT OF =
00500  1410          TAD I PDLXR
00501  3060          DCA ALPHAI      /RESTORE UNDEFINED INDICATOR
00502  1410          TAD I PDLXR
00503  3055          DCA THISTG      /RESTORE TAG NUMBER
00504  4572          JMS I [FINDTG
00505  2063          ISZ UNDFSW      /WAS ANY PART OF DEFINITION UNDEFINED?
00506  5311          JMP .+3
00507  4466          JMS I PERROR    /YES - GENERATE IE ERROR MESSAGE
00510  5145          IE
00511  1060          TAD ALPHAI      /NO - HAD TAG BEEN DEFINED BEFORE?
00512  7650          SNA CLA
00513  5326          JMP EQUAL2      /NO
00514  1031          TAD VALUE       /YES - WERE DEFINITIONS THE SAME?
00515  7041          CIA
00516  1032          TAD VALUE2
00517  7650          SNA CLA
00520  5326          JMP EQUAL2      /YES
00521  1020          TAD TAG1        /NO - IS IT A PERMANENT SYMBOL?
00522  7700          SMA CLA
00523  5326          JMP EQUAL2      /NO - OK TO REDEFINE
00524  4545          JMS I [ERROR    /YES - GENERATE RD ERROR MESSAGE FIRST
00525  6244          RD
00526  1031  EQUAL2, TAD VALUE       /DEFINE OR REDEFINE
00527  3032          DCA VALUE2
00530  4544          JMS I [PUTTAG   /STORE TAG
00531  5550          JMP I [PUNVAL   /SEE ABOUT DUMPING SOURCE CODE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 15




             /HANDLER FOR FIXMRI PSEUDO-OP

00532  4566  FIXMRX, JMS I [SPNOR    /IGNORE SPACES
00533  4543          JMS I [TSTALP   /IS CHARACTER ALPHABETIC?
00534  5344          JMP FIXMR1      /YES-CONTINUE
00535  4545          JMS I [ERROR    /NO GENERATE IC ERROR MESSAGE
00536  5143          IC
00537  1035          TAD CHAR        /GET CHARACTER
00540  7710          SPA CLA         /WAS IT END OF LINE?
00541  5577          JMP I [LOOKEX   /YES--EXIT TO MAIN--
00542  4574          JMS I [GETC     /NO-GET NEXT CHARACTER
00543  5333          JMP FIXMRX+1    /KEEP LOOKING FOR ALPHABETIC CH. OR END OF LINE
00544  4542  FIXMR1, JMS I [GETTAG   /PICK UP TAG-IS SYMBOL IN TABLE?
00545  5371          JMP FIXMR3      /NO-PUT IT IN
00546  7240          CLA CMA         /YES-CLEAR UNDEFINED TAG SWITCH
00547  3060          DCA ALPHAI
00550  1021          TAD TAG2        /SET BIT FOR MEMORY REFERENCE INSTRUCTION
00551  7104          CLL RAL
00552  7130          CLL CML RAR
00553  3021          DCA TAG2
00554  4544          JMS I [PUTTAG   /STORE TAG
00555  4566          JMS I [SPNOR    /IGNORE SPACES
00556  1035  FIXMR2, TAD CHAR        /END OF LINE
00557  7710          SPA CLA
00560  5577          JMP I [LOOKEX   /YES--EXIT TO MAIN--
00561  1035          TAD CHAR        /NO-WAS CHARACTER = ?
00562  1373          TAD (-"=
00563  7650          SNA CLA
00564  5271          JMP EQUAL3      /YES-CONTINUE
00565  4545          JMS I [ERROR    /NO GENERATE IC ERROR MESSAGE
00566  5143          IC
00567  4574          JMS I [GETC     /IGNORE ILLEGAL CHARACTER
00570  5356          JMP FIXMR2      /GET NEXT ONE

00571  4547  FIXMR3, JMS I [INSRTG   /PUT SYMBOL IN TABLE
00572  5347          JMP FIXMR1+3

00573  7503
00574  5114
00575  2217
00576  4563
00577  1442
       0600          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 16



             /ROTATE AC 6 LEFT

00600  0000  RTL6,   0
00601  7106          CLL RTL
00602  7006          RTL
00603  7006          RTL
00604  5600          JMP I RTL6      /--RETURN--


             /GET NEXT CHARACTER ROUTINE
             /READS FROM THE INPUT FILES AND PASSES THE MODIFIED CHARACTERS
             /TO THE PROGRAM
             /IT ALSO PRINTS THE LATEST LINE IF IT HAS NOT BEEN PRINTED

00605  0000  GETC,   0
00606  2034          ISZ TXTPTR      /POINT TO NEXT CHARACTER
00607  1434  GETC7,  TAD I TXTPTR    /GET NEXT CHARACTER
00610  7440          SZA             /IS IT 0?
00611  5257          JMP GETC8       /NO - MORE ARE IN THIS LINE
00612  1047          TAD PASS        /IS THIS PASS 3?
00613  7750          SPA SNA CLA
00614  5232          JMP GETC1       /NO
00615  1141          TAD [LINBUF     /YES
00616  3034          DCA TXTPTR      /RESET POINTER TO BEGINNING
00617  1434          TAD I TXTPTR    /GET 1ST CHARACTER
00620  7450          SNA             /IS IT 0?
00621  5232          JMP GETC1       /YES - LINE HAS BEEN PRINTED
00622  1140          TAD [-215       /IS IT 215?
00623  7650          SNA CLA
00624  5231          JMP GETC2       /YES - DO NOT PRINT THE SPACES
00625  1137          TAD [211        /NO-OUTPUT 2 TABS
00626  4446          JMS I OERROR
00627  1137          TAD [211
00630  4446          JMS I OERROR
00631  4340  GETC2,  JMS LINPRT      /NOW PRINT THE LINE
00632  1377  GETC1,  TAD (-121
00633  3033          DCA TXTSWT
00634  1136          TAD [LINBUF-1
00635  3034          DCA TXTPTR      /RESET POINTER
00636  2034          ISZ TXTPTR
00637  4445  GETC6,  JMS I ICHAR     /GET NEXT CHARACTER
00640  5247          JMP GETC4       /215
00641  3434          DCA I TXTPTR    /STORE THE CHARACTER
00642  2033          ISZ TXTSWT      /TOO MANY?
00643  5236          JMP GETC6-1     /NO
00644  7240          CLA CMA         /YES
00645  3033          DCA TXTSWT
00646  5237          JMP GETC6

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 17




00647  3434  GETC4,  DCA I TXTPTR    /SET END
00650  2034          ISZ TXTPTR
00651  3434          DCA I TXTPTR    /SET END OF LINE
00652  1141          TAD [LINBUF
00653  3034          DCA TXTPTR      /RESET POINTER
00654  7240          CLA CMA
00655  3033          DCA TXTSWT      /RESET SWITCH
00656  5207          JMP GETC7       /GET THAT CHARACTER

00657  1140  GETC8,  TAD [-215       /IS IT A CARRIAGE RETURN?
00660  7450          SNA
00661  5310          JMP GETC12      /YES-END OF LINE
00662  1061          TAD GETCI       /NO-
00663  1376          TAD (215-"/     /IS IT A /?
00664  7450          SNA             /YES-
00665  5316          JMP GETC13      /"/" IS END
00666  1375          TAD ("/-";      /IS IT A ;?
00667  7450          SNA             /YES-
00670  5310          JMP GETC12      /";" IS END
00671  1374          TAD (";-211     /IS IT A TAB?
00672  7450          SNA
00673  5277          JMP GETC10      /YES- TAB IS SPACE
00674  1373          TAD (211-240    /IS IT SPACE?
00675  7640          SZA CLA
00676  5311          JMP GETC9       /NO-NOT ANYTHING SPECIAL
00677  2033  GETC10, ISZ TXTSWT      /YES-2ND OCCURANCE?
00700  5206          JMP GETC+1      /YES - IGNORE
00701  1135          TAD [240
00702  3035          DCA CHAR        /NO - GIVE A SPACE
00703  5605          JMP I GETC      /--RETURN--

00704  2051  GETC16, ISZ CONDSW      /DECREMENT CONDITIONAL COUNTER
00705  5321          JMP GETC15
00706  1167  GETC17, TAD [LINBUF+120
00707  3034          DCA TXTPTR
00710  7330  GETC12, CLL CLA CML RAR /AC=4000
00711  1434  GETC9,  TAD I TXTPTR
00712  3035          DCA CHAR        /STORE CHARACTER
00713  7240          CLA CMA
00714  3033          DCA TXTSWT      /SET THE SWITCH
00715  5605          JMP I GETC      /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 18




00716  1051  GETC13, TAD CONDSW      /CURRENTLY IN CONDITIONALS?
00717  7650          SNA CLA
00720  5306          JMP GETC17      /NO
00721  2034  GETC15, ISZ TXTPTR      /YES-SCAN LINE FOR < AND >
00722  1434          TAD I TXTPTR
00723  1140          TAD [-215       /IS CHARACTER A CARRIAGE RETURN?
00724  7450          SNA
00725  5306          JMP GETC17      /YES
00726  1372          TAD (215-">     /NO IS IT A >?
00727  7450          SNA
00730  5304          JMP GETC16      /YES
00731  1371          TAD (">-"<      /NO-IS IT <?
00732  7640          SZA CLA
00733  5321          JMP GETC15      /NO
00734  7240          CLA CMA         /YES-INCREMENT CONDITIONAL COUNTER
00735  1051          TAD CONDSW
00736  3051          DCA CONDSW
00737  5321          JMP GETC15


             /CHAR IS NEGATIVE IF LOGICAL END OF LINE:
             /       CARRIAGE RETURN
             /       /
             /       ;

             /CHAR MAY BE ZERO IF PHYSICAL END OF LINE:
             /       CARRIAGE RETURN

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 19


             /PRINT A LINE OF SOURCE CODE

00740  0000  LINPRT, 0
00741  1370          TAD (LINBUF-1
00742  3012          DCA XREG1       /SET POINTER TO LINE
00743  1412  LINPR1, TAD I XREG1     /GET CHARACTER
00744  7450          SNA             /IS IT END OF LINE?
00745  5350          JMP LINPR2      /YES - END LINE
00746  4446          JMS I OERROR    /NO - OUTPUT CHARACTER
00747  5343          JMP LINPR1

00750  3541  LINPR2, DCA I [LINBUF   /0 MEANS THAT LINE HAS BEEN PRINTED
00751  5740          JMP I LINPRT    /--RETURN--


             /HANDLE PHASE ERROR
             /AND ALL ERROR EXITS TO MONITOR

00752  1367  PHASE,  TAD (PH         /GENERATE PH ERROR MESSAGE
00753  3357  MONERR, DCA MONER1      /ERROR IS SERIOUS ENOUGH TO
00754  1134          TAD [OTYPEO     / CAUSE IMMEDIATE RETURN TO
00755  3046          DCA OERROR      / MONITOR
00756  4545          JMS I [ERROR
00757  0000  MONER1, 0               /STORE ERROR TYPE HERE
00760  5766'         JMP MONWT       /***EXIT TO MONITOR***


             /FIND CURRENT PAGE NUMBER
             /EXIT WITH NUMBER IN AC

00761  0000  FINDSP, 0
00762  1027          TAD LOC
00763  0154          AND [7600
00764  4555          JMS I [RTL6
00765  5761          JMP I FINDSP    /--RETURN--

00766  4247
00767  6050
00770  1613
00771  0002
00772  7717
00773  7751
00774  0062
00775  7764
00776  7736
00777  7657
       1000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 20




             /PASS 3 LISTING OUTPUT

01000  0000  LISOUT, 0
01001  3006          DCA LISOU2
01002  1026          TAD XLISTX      /IS THIS COVERED BY XLIST?
01003  7640          SZA CLA
01004  5600          JMP I LISOUT    /YES--RETURN--
01005  2230          ISZ LISCNT      /NO-WAS PREVIOUS CHARACTER A 215?
01006  5215          JMP LISOU1      /NO
01007  2057          ISZ LINCNT      /WAS IT END OF PAGE?
01010  5215          JMP LISOU1      /NO
01011  2036          ISZ THISPG      /YES-START OVERFLOW PAGE
01012  4357  BEGIAB, JMS CRLF        /OUTPUT CARRIAGE RETURN/LINE FEED
01013  4533  HSWIT1, JMS I [FORMFD   /0 IF /H SWITCH OPTION TO SUPRESS PAGING
01014  2057          ISZ LINCNT
01015  1006  LISOU1, TAD LISOU2      /IS CHARACTER A CARRIAGE RETURN?
01016  1140          TAD [-215
01017  7450          SNA
01020  5224          JMP LISOU3      /YES - OUTPUT CR/LF
01021  1132          TAD [215        /NO - RESTORE CHARACTER
01022  4444          JMS I OCHAR     /OUTPUT CHARACTER
01023  5600          JMP I LISOUT    /--RETURN--

01024  7240  LISOU3, CLA CMA
01025  3230          DCA LISCNT      /REMEMBER THE 215 FOR NEXT TIME
01026  4357          JMS CRLF        /OUTPUT CARRIAGE RETURN/LINE FEED
01027  5600          JMP I LISOUT    /--RETURN--

01030  7777  LISCNT, -1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 21



             /FORM FEED OUTPUT ROUTINES

01031  0000  FORMFD, 0
01032  1026          TAD XLISTX      /IS THIS COVERED BY XLIST?
01033  7640          SZA CLA
01034  5631          JMP I FORMFD    /YES--RETURN--
01035  5347  HSWITC, JMP FORMF1      /0 IF /T OR TTY:; JMP FORMF3 IF /H
                                     /OUTPUT IF TTY:OR /T OPTION
01036  1057          TAD LINCNT
01037  1131          TAD [-4
01040  3057          DCA LINCNT
01041  4357          JMS CRLF        /OUTPUT CARRIAGE RETURN/LINE FEED
01042  2057          ISZ LINCNT
01043  5362          JMP CRLF1       /OUTPUT LINE FEED
                                     /CRLF1 WILL RETURN TO
                                     /JMP-1 UNTIL LINCNT HAS
                                     /BEEN BUMPED SUFFICIENTLY
01044  1353          TAD FORMM6
01045  3057          DCA LINCNT
01046  1130          TAD ["-         /OUTPUT ------
01047  4444          JMS I OCHAR
01050  2057          ISZ LINCNT
01051  5246          JMP .-3
01052  1131          TAD [-4
01053  3057          DCA LINCNT
                                     /OUTPUT IF NO OPTIONS SPECIFIED
                                     /LINCNT=-1
01054  4357  FORMF2, JMS CRLF        /OUTPUT CARRIAGE RETURN/LINE FEED
01055  2057          ISZ LINCNT
01056  5362          JMP CRLF1       /OUTPUT LINE FEED
01057  1354          TAD FORM70
01060  3057          DCA LINCNT

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 22



01061  1127  FORM22, TAD [HEADER-1   /OUTPUT HEADER
01062  3013          DCA XREG2
01063  1126          TAD [40
01064  3062          DCA LSTCNT
01065  1413  FORM30, TAD I XREG2     /GET NEXT CHARACTER OF HEADING
01066  7450          SNA             /IS IT LAST + 1
01067  5277          JMP FORM20      /YES
01070  4444          JMS I OCHAR     /NO-OUTPUT IT
01071  1062          TAD LSTCNT
01072  1160          TAD [-100       /DONE 40 CHARACTERS YET?
01073  7640          SZA CLA
01074  5265          JMP FORM30      /NO-CONTINUE
01075  1126          TAD [40         /YES-START SYSTEM HEADER
01076  5261          JMP FORM22      /WHICH STARTS AT HEADER+40


             /TTY: OR /T OUTPUTS FORM FEED AS
             /CARRIAGE RETURN, MULTIPLE LINE FEEDS TO END OF PAGE
             /------
             /CARRIAGE RETURN, 5 LINE FEEDS
             /HEADER
             /NO OPTIONS TREATS F/F AS
             /F/F, LF, CR/LF
             /HEADER

             / /H OPTION TREATS F/F AS 2 CR/LF

             /USER HEADER IS 40 (8) CHARACTERS WIDE
             /ASSEMBLER HEADER ENDS WITH 0


             /OUTPUT PAGE NUMBERS

01077  1037  FORM20, TAD EDITPG      /OUTPUT EDITOR PAGE NUMBER
01100  4313          JMS FORMF4
01101  1036          TAD THISPG      /IS THERE PAGE OVERFLOW?
01102  7650          SNA CLA
01103  5310  FORM21, JMP FORMF3      /NO
01104  1130          TAD ["-         /YES
01105  4444          JMS I OCHAR     /OUTPUT -
01106  1036          TAD THISPG      /OUTPUT NUMBER OF OVERFLOW PAGE
01107  4313          JMS FORMF4
                                     /OUTPUT IF /H OPTION
01110  4357  FORMF3, JMS CRLF        /OUTPUT 2 CR/LF
01111  4357          JMS CRLF
01112  5631          JMP I FORMFD    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 23



             /DECIMAL PRINT ROUTINE

01113  0000  FORMF4, 0
01114  3004          DCA FORMF6      /SAVE NUMBER
01115  1355          TAD FORM8F
01116  3357          DCA CRLF        /POINT TO DIVISION LIST
01117  7346          CLL CLA CMA RTL /AC=7775
01120  3356          DCA FORM11      /DIVIDE BY 1000, 100, OR 10
01121  3005  FORM12, DCA FORMF7      /START WITH 0
01122  5325          JMP .+3
01123  3004  FORMF5, DCA FORMF6
01124  2005          ISZ FORMF7      /ADD 1 TO DIGIT
01125  1004          TAD FORMF6
01126  1757          TAD I CRLF      /SUBTRACT 1000, 100, OR 10
01127  7500          SMA             /OVERFLOW
01130  5323          JMP FORMF5      /NO-KEEP SUBTRACTING
01131  7200          CLA             /YES-DIGIT DONE
01132  2357          ISZ CRLF        /BUMP LIST POINTER
01133  1005          TAD FORMF7      /WAS DIGIT A 0?
01134  7450          SNA
01135  5341          JMP FORM10      /YES
01136  1125          TAD ["0         /NO-MAKE IT ASCII
01137  4444          JMS I OCHAR     /OUTPUT DIGIT
01140  7330          CLL CLA CML RAR /AC=4000
01141  2356  FORM10, ISZ FORM11      /DONE?
01142  5321          JMP FORM12      /NO-4000 IN AC WILL FORCE SIGNIGICANCE
01143  1004          TAD FORMF6      /GET LAST DIGIT (UNITS PLACE)
01144  1125          TAD ["0
01145  4444          JMS I OCHAR     /OUTPUT DIGIT
01146  5713          JMP I FORMF4    /--RETURN--

01147  7340  FORMF1, CLL CLA CMA
01150  3057          DCA LINCNT
01151  7240          CLA CMA         /ENTER CRLF WITH AC=-1
01152  5254          JMP FORMF2      /TO GENERATE F/F LF

01153  7772  FORMM6, -6
01154  7710  FORM70, -70
01155  5131  FORM8F, FORMF8
01156  0000  FORM11, 0

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 24



             /OUTPUT CARRIAGE RETURN/LINE FEED
             /ENTER WITH AC=-1 TO GENERATE F/F LF

01157  0000  CRLF,   0
01160  1132          TAD [215
01161  4444          JMS I OCHAR
01162  1142  CRLF1,  TAD [212        /RE-ENTRY FOR MULTIPLE LINE FEEDS
01163  4444          JMS I OCHAR
01164  5757          JMP I CRLF      /--RETURN--


       1200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 25



             /SYMBOL TABLE OUTPUT (COLUMNAR)
                             /*CODE TO GENERATE DDT COMPATIBLE*
                             /**SYMBOL TABLE--SUBSTITUTED WITH*
                             /**ONCE ONLY CODE IF NEEDED*******

01200  0000  SYMPRT, 0
01201  2036          ISZ THISPG                      /FORM FEED
01202  4533          JMS I [FORMFD
01203  1124          TAD [-67        /DCA I SYMPR6-1
01204  3060          DCA SYMPR7      /JMS SYMPR9+6
01205  3064  SYMPR8, DCA SYMPR2      /TAD [377       //RUBOUT
01206  7240          CLA CMA         /JMS I OERROR
01207  3055          DCA THISTG      /CLA CMA
01210  1064          TAD SYMPR2      /DCA THISTG
01211  7040          CMA             /TAD [215       //CARRIAGE RETURN
01212  3063          DCA SYMPR3      /JMS I OERROR
01213  2063  SYMPR5, ISZ SYMPR3      /JMS SYMPPP
01214  5253          JMP SYMPR4      /JMP SYMPR9-1
01215  1131          TAD [-4         /JMP SYMPR6+2
01216  3063          DCA SYMPR3      /HSWIT1
01217  4270  SYMPR6, JMS SYMPPP      /204            //EOT
01220  5240          JMP SYMPR9
01221  1171          TAD [1777
01222  0020          AND TAG1                        /OUTPUT TAG
01223  4777          JMS I (DIV45
01224  7350          CLL CLA CMA RAR /AC=3777
01225  0021          AND TAG2
01226  4777          JMS I (DIV45
01227  7350          CLL CLA CMA RAR /AC=3777
01230  0022          AND TAG3
01231  4777          JMS I (DIV45
01232  1135          TAD [240
01233  4446          JMS I OERROR                    /OUTPUT SPACE
01234  1032          TAD VALUE2
01235  4310          JMS OCTPRT                      /OUTPUT OCTAL VALUE
01236  2063          ISZ SYMPR3      /JMP SYMPR5-2
01237  5256          JMP SYMPR0      /TAD SYMPR6
01240  1132  SYMPR9, TAD [215        /JMS I OERROR   /CARRIAGE RETURN
01241  4446          JMS I OERROR    /TAD [377       //RUBOUT
01242  2060          ISZ SYMPR7      /JMS I OERROR
01243  5250          JMP .+5         /JMS SYMPR9+6
01244  4533  HSWIT2, JMS I [FORMFD   /DCA LINCNT     /0 IF NOT /H
01245  1124          TAD [-67        /JMP I SYMPRT   //--RETURN--
01246  3060          DCA SYMPR7      /0
01247  1272          TAD SYM245      /TAD [-200
01250  7001          IAC             /DCA SYMPR2
01251  1064          TAD SYMPR2      /TAD [200       //LEADER-TRAILER
01252  5205          JMP SYMPR8      /JMS I OERROR

01253  4270  SYMPR4, JMS SYMPPP      /ISZ SYMPR2
01254  5600          JMP I SYMPRT    /JMP SYMPR4-2   /--RETURN--
01255  5213          JMP SYMPR5      /JMP I SYMPR9+6

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 26




01256  1376  SYMPR0, TAD (-66
01257  3053          DCA SYMPPB
01260  4270          JMS SYMPPP
01261  5240          JMP SYMPR9
01262  2053          ISZ SYMPPB
01263  5260          JMP .-3
01264  4523          JMS I [ERROR1
01265  4523          JMS I [ERROR1
01266  4523          JMS I [ERROR1
01267  5217          JMP SYMPR6

       0064  SYMPR2=LINKSW
       0063  SYMPR3=UNDFSW
       0060  SYMPR7=ALPHAI
       0053  SYMPPB=CHKSUM

             HEDCL2,
             OCTPR1,
01270  0000  SYMPPP, 0
01271  2055          ISZ THISTG
01272  0245  SYM245, 245
01273  1055          TAD THISTG
01274  7141          CLL CIA
01275  1056          TAD HIGHTG
01276  7620          SNL CLA
01277  5670          JMP I SYMPPP    /--RETURN--
01300  4572          JMS I [FINDTG
01301  7330          CLL CLA CML RAR /AC=4000
01302  0020          AND TAG1
01303  1022          TAD TAG3
01304  7730          SPA SZL CLA
01305  5271          JMP SYMPPP+1
01306  2270          ISZ SYMPPP
01307  5670          JMP I SYMPPP    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 27



             /OCTAL PRINT ROUTINE
             /ENTER WITH # TO BE OUTPUT IN AC

01310  0000  OCTPRT, 0
01311  3270          DCA OCTPR1
01312  1131          TAD [-4
01313  3361          DCA OCTPR3
01314  1270  OCTPR2, TAD OCTPR1      /GET EACH DIGIT SEPARATELY
01315  7106          CLL RTL
01316  7004          RAL
01317  3270          DCA OCTPR1
01320  1270          TAD OCTPR1
01321  7004          RAL
01322  0122          AND [7
01323  1125          TAD ["0         /MAKE IT INTO AN ASCII CHARACTER
01324  4446          JMS I OERROR    /OUTPUT IT
01325  2361          ISZ OCTPR3
01326  5314          JMP OCTPR2
01327  5710          JMP I OCTPRT    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 28


             HEDCL1,

             /OUTPUT ONE REGISTER

01330  0000  PUNONE, 0
01331  1047          TAD PASS        /WHICH PASS IS THIS?
01332  7450          SNA
01333  5355          JMP PUNON2      /PASS 2--OUTPUT BINARY
01334  7710          SPA CLA
01335  5353          JMP PUNON1+2    /PASS 1--EXIT
01336  4775          JMS I (PUNFLD   /PRINT 5 DIGIT ADDRESS
01337  4523  DTORG1, JMS I [ERROR1   /OUTPUT 2 SPACES
01340  1031          TAD VALUE
01341  4310          JMS OCTPRT      /OUTPUT CONTENTS
01342  1541          TAD I [LINBUF   /IS THERE SOURCE CODE TO DUMP?
01343  7650          SNA CLA
01344  5351          JMP PUNON1      /NO-OUTPUT CARRIAGE RETURN
01345  1064          TAD LINKSW      /YES-DUMP LINK SWITCH (' ) OR (  )
01346  4523          JMS I [ERROR1
01347  4774          JMS I (LINPRT   /DUMP SOURCE CODE
01350  5353          JMP PUNON1+2    /AND EXIT

01351  1132  PUNON1, TAD [215        /OUTPUT CARRIAGE RETURN
01352  4446          JMS I OERROR
01353  3064          DCA LINKSW      /CLEAR LINK SWITCH
01354  5730          JMP I PUNONE    /--RETURN--

             /PASS 2-OUTPUT ONE REGISTER
01355  1031  PUNON2, TAD VALUE       /GET CONTENTS
01356  7100          CLL
01357  4521          JMS I [PUNOUT   /OUTPUT AS 2 FRAMES
01360  5353          JMP PUNON1+2    /AND EXIT


             OCTPR3,

             /CLEAR PAGE HEADING BUFFER

01361  0000  HEDCLR, 0
01362  1120          TAD [-40        /SET HEADING BUFFER
01363  3270          DCA HEDCL2      /TO TABS
01364  1127          TAD [HEADER-1
01365  3330          DCA HEDCL1
01366  1137          TAD [211
01367  2330          ISZ HEDCL1
01370  3730          DCA I HEDCL1
01371  2270          ISZ HEDCL2
01372  5366          JMP .-4
01373  5761          JMP I HEDCLR    /--RETURN--

01374  0740
01375  2226
01376  7712
01377  4047

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 28-1

       1400          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 29


             /**CURRENT PAGE LITERALS ON THIS PAGE WILL BE LOST**
             /***WHEN OVERLAYED BY PUSHDOWN LIST**

             /ARRANGE TO OUTPUT ONE REGISTER

01400  0000  PUNBIN, 0
01401  3031          DCA VALUE
01402  4552          JMS I [FINDSP   /FIND CURRENT PAGE NUMBER
01403  1151          TAD [LITBUF
01404  3042          DCA TEMP2       /POINT TO NUMBER OR LITERALS
01405  1027          TAD LOC
01406  0176          AND [177
01407  3040          DCA TEMP
01410  1442          TAD I TEMP2     /IS PAGE FULL?
01411  7041          CIA
01412  1040          TAD TEMP
01413  2040          ISZ TEMP
01414  7710          SPA CLA
01415  5230          JMP ONEOK       /NO-OK TO ADD ONE MORE REGISTER
01416  1040          TAD TEMP        /YES-
01417  3442          DCA I TEMP2
01420  4552          JMS I [FINDSP   /FIND CURRENT PAGE NUMBER
01421  7640          SZA CLA         /IS THIS PAGE 0?
01422  5226          JMP .+4
01423  4466          JMS I PERROR    /YES-GENERATE ZE ERROR MESSAGE
01424  7245          ZE
01425  5230          JMP ONEOK       /PUT OUT CODE
01426  4466          JMS I PERROR    /NO-GENERATE PE ERROR MESSAGE
01427  6045          PE
01430  4552  ONEOK,  JMS I [FINDSP   /FIND CURRENT PAGE NUMBER
01431  1117          TAD [TPINST
01432  3042          DCA TEMP2
01433  1040          TAD TEMP        /IS THIS ADDRESS HIGHER THAN PREVIOUS
01434  7041          CIA             /HIGH INSTRUCTION PAGE?
01435  1442          TAD I TEMP2
01436  7700          SMA CLA
01437  5242          JMP .+3         /NO
01440  1040          TAD TEMP        /YES-THIS IS NEW HIGH INSTRUCTION
01441  3442          DCA I TEMP2

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 30




01442  4563  PUNMOD, JMS I [PUNONE   /OUTPUT THIS REGISTER
01443  2027          ISZ LOC         /GET NEXT LOCATION
01444  1027          TAD LOC         /IF THE "ISZ" SKIPS IT IS O.K. (A 0)
01445  0176          AND [177        /IS THIS FIRST INSTRUCTION ON NEXT PAGE?
01446  7640          SZA CLA
01447  5600          JMP I PUNBIN    /NO--RETURN--
01450  4552          JMS I [FINDSP   /YES-FIND CURRENT PAGE NUMBER
01451  1151          TAD [LITBUF     /RESET POINTERS
01452  3042          DCA TEMP2
01453  1442          TAD I TEMP2
01454  3023          DCA LITPTR
01455  5600          JMP I PUNBIN    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 31



       1456  HEADER=.

             /**********************************************************


             /SECOND CONTINUATION OF EXPUNGE HANDLER
             /CONTINUED FROM EXPUNW
             /ENTER WITH TAG3 IN AC--PASS 1 ONLY

01456  5231  EXPUA1, EXPUN2          /TEMPORARY STORAGE REGISTER
01457  5223  EXPUA2, EXPUNY          /FIRST CONTINUATION

01460  7710  EXPUNV, SPA CLA         /IS SYMBOL A PSEUDO-OP?
01461  5266          JMP EXPUNZ      /YES
01462  7332  EXPUA4, CLL CLA CML RTR /AC=2000
01463  0020          AND TAG1        /NO-IS IT I OR Z ?
01464  7650          SNA CLA
01465  5272          JMP .+5         /NO-FORGET TAG
01466  1656  EXPUNZ, TAD I EXPUA1    /YES-RETURN TAG TO SYMBOL TABLE
01467  3055          DCA THISTG
01470  4544          JMS I [PUTTAG
01471  2656          ISZ I EXPUA1
01472  2041          ISZ TEMP1
01473  2043          ISZ TEMP3       /DONE YET?
01474  5657          JMP I EXPUA2    /NO- TRY NEXT TAG
01475  7240          CLA CMA         /YES
01476  1656          TAD I EXPUA1    /RESET HIGH TAG
01477  3056          DCA HIGHTG
01500  5577          JMP I [LOOKEX   /--EXIT TO MAIN--
             /**********************************************************

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 32



             /ASSEMBLER HEADER BUFFER

       1516  *HEADER+40

01516  0240          " ;" ;"P;"A;"L;"C;"-
01517  0240
01520  0320
01521  0301
01522  0314
01523  0303
01524  0255
01525  0326          "V;VERSION+"0
01526  0262
01527  0240          " ;" 
01530  0240
01531  0240  DATE,   " ;" ;" ;" ;" ;" ;" ;" 
01532  0240
01533  0240
01534  0240
01535  0240
01536  0240
01537  0240
01540  0240
01541  0240          " ;" ;"P;"A;"G;"E;" ;0
01542  0240
01543  0320
01544  0301
01545  0307
01546  0305
01547  0240
01550  0000

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 33




             /PUSHDOWN LIST
             /OCCUPIES NEXT 43(8) LOCATIONS
       1551  PDLND=.

       1600  PAGE

       1614  LINBUF=.+14             /LINE BUFFER OCCUPIES 122(8) LOCATIONS

       1613  PDLST=LINBUF-1

       1736  LITBUF=LINBUF+122       /LITERAL TABLE IS 40(8) LOCATIONS (ONE PER PAGE)
                                     /  SHOWING LOWEST PAGE ADDRESS USED FOR LITERALS

       1776  TPINST=LITBUF+40        /TOP INSTRUCTION TABLE IS 40(8) LOCTIONS
                                     /  SHOWING HIGHEST PAGE ADDRESS USED FOR INSTRUCTIONS

       2017  LITBF2=TPINST+40-17     /LITERAL BUFFER 2 CONTAINS UP TO 160(8)
                                     /PAGE 0 LITERALS

       2200  LITBF1=LITBF2+200-17    /LITERAL BUFFER 1 CONTAINS UP TO 100(8)
                                     /CURRENT PAGE LITERALS

             /2217-2277 WILL CONTAIN MAIN ASSEMBLER CODE
             /AFTER STARTUP PROCEDURES

             IFNZRO LITBF1&177 < THIS IS AN ERROR!! >

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 34




       1600          *1600

01600  6211  BEGIN,  CDF 10          /GET PARMS FROM MONITOR
01601  1777          TAD I (MPARAM
01602  3272          DCA PARM1
01603  1776          TAD I (MPARAM+1
01604  3273          DCA PARM2
01605  6201          CDF
01606  1273          TAD PARM2
01607  0375          AND (20         /T?
01610  7650          SNA CLA
01611  5214          JMP BEGSKP+1    /LISTING NOT GOING TO TTY
01612  3774          DCA I (HSWITC   /LISTING GOING TO TTY
01613  7610  BEGSKP, SKP CLA
01614  3773          DCA I (BEGIAB
01615  1273          TAD PARM2
01616  0372          AND (40         /S?
01617  7640          SZA CLA
01620  3771          DCA I (SSWITC   /LOOK UP COMMENT IN PAL8
01621  7332          CLA CLL CML RTR /N?
01622  0273          AND PARM2
01623  7650          SNA CLA
01624  5230          JMP BEGN
01625  1213          TAD BEGSKP
01626  3770          DCA I (NSWITC   /DONT PRINT SYMBOL TABLE
01627  5234          JMP BEGFH
01630  1272  BEGN,   TAD PARM1
01631  0375          AND (20         /H?
01632  7650          SNA CLA
01633  5240          JMP BEGINB
01634  1767  BEGFH,  TAD I (FORM21
01635  3774          DCA I (HSWITC
01636  3766          DCA I (HSWIT1
01637  7610          CLA SKP
01640  3765  BEGINB, DCA I (HSWIT2
01641  1272          TAD PARM1
01642  0364          AND (400        /D?
01643  7650          SNA CLA
01644  5255          JMP BEGIN1
01645  1412          TAD I XREG1
01646  3416          DCA I LAST3     /COPY DDT COMPATIBLE SYMBOL TABLE CODE
01647  2274          ISZ DSWIT3
01650  5245          JMP .-3
01651  1413          TAD I XREG2
01652  3417          DCA I LAST4
01653  2275          ISZ DSWIT4
01654  5251          JMP .-3
01655  6211  BEGIN1, CDF 10
01656  1415          TAD I LAST2     /MOVE DATE INTO PASS3 BUFFER
01657  6201          CDF 0
01660  3414          DCA I LAST1
01661  2271          ISZ DATCNT

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 34-1

01662  5255          JMP BEGIN1
01663  3014          DCA LAST1       /SIGNIFIES DATE IN BUFFER
01664  1363          TAD (-10
01665  3007          DCA LEADER
01666  3762          DCA I (LINBUF+120
01667  3761          DCA I (LINBUF+121
01670  5760          JMP I (BEGIN2

01671  7770  DATCNT, -10
01672  0000  PARM1,  0
01673  0000  PARM2,  0
01674  7763  DSWIT3, DSWIT1-DSWITA-1
01675  7760  DSWIT4, DSWIT2-DSWITB-1

01760  2000
01761  1735
01762  1734
01763  7770
01764  0400
01765  1244
01766  1013
01767  1103
01770  4334
01771  4243
01772  0040
01773  1012
01774  1035
01775  0020
01776  7401
01777  7400
       2000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 35




02000  1777' BEGIN2, TAD PARM1
02001  7012          RTR             /K?
02002  7620          SNL CLA
02003  5225          JMP FLD1+3
02004  6251          CDF 50
02005  4250          JMS FLD2        /WHAT IS HIGHEST FIELD?
02006  5221          JMP FLD1-1      /5
02007  6241          CDF 40
02010  4250          JMS FLD2
02011  5222          JMP FLD1        /4
02012  6231          CDF 30
02013  4250          JMS FLD2
02014  5223          JMP FLD1+1      /3
02015  6221          CDF 20
02016  4250          JMS FLD2
02017  5224          JMP FLD1+2      /2
02020  5225          JMP FLD1+3      /1
02021  1376          TAD (1400       /IF FIELD 5, ALLOW 3840 SYMBOLS
02022  1376  FLD1,   TAD (1400       /OTHERWISE ALLOW 1400(NR OF FIELDS)
02023  1376          TAD (1400
02024  1376          TAD (1400
02025  1376          TAD (1400
02026  3775          DCA I (TAGMAX   /SET HIGHEST ADDRESS FOR TAGS
02027  1775          TAD I (TAGMAX
02030  7104          CLL RAL
02031  7730          SZL SPA CLA     /IS FIELD 1 HIGHEST FIELD?
02032  5774          JMP I (BEGING   /NO
02033  1673  OPTIM4, TAD I OPTIM1    /YES - OPTIMIZE SEARCH PATTERN
02034  2273          ISZ OPTIM1      /BY SUBSTITUTING CODE IN SEARCH
02035  3674          DCA I OPTIM2    /ROUTINE
02036  2274          ISZ OPTIM2
02037  2275          ISZ OPTIM3
02040  5233          JMP OPTIM4
02041  1676  OPTIM8, TAD I OPTIM5
02042  2276          ISZ OPTIM5
02043  3677          DCA I OPTIM6
02044  2277          ISZ OPTIM6
02045  2300          ISZ OPTIM7
02046  5241          JMP OPTIM8
02047  5774          JMP I (BEGING

             /SKIP IF CURRENT DATA FIELD DOES NOT EXIST
02050  0000  FLD2,   0
02051  1373          TAD (FLD3
02052  3772          DCA I (FLD4
02053  7200  FLD3,   CLA
02054  1772          TAD I (FLD4
02055  7000          NOP
02056  6201          CDF
02057  1371          TAD (-FLD3
02060  7640          SZA CLA
02061  5270          JMP FLD5

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 35-1

02062  1050          TAD IOMON
02063  1154          TAD [-200
02064  7650          SNA CLA         /IS FIELD THERE?
02065  5650          JMP I FLD2      /YES--RETURN--
02066  1156          TAD [200
02067  3050          DCA IOMON
02070  2250  FLD5,   ISZ FLD2        /NO-INCREMENT RETURN ADDRESS
02071  5650          JMP I FLD2      /--RETURN--

02072  0050  FLD4,   IOMON

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 36




             /OVERLAY CODE FOR OPTIMAL SYMBOL TABLE SEARCH
             /IN 8K

02073  2101  OPTIM1, OPTIMA
02074  4110  OPTIM2, SETFLD+1
02075  7771  OPTIM3, -7

02076  2110  OPTIM5, OPTIMB
02077  4011  OPTIM6, GETTG5
02100  7757  OPTIM7, -21

02101  7146  OPTIMA, CLL CMA RTL
02102  1315          SETFLD+6&177+1200
02103  3011          DCA TAGXR
02104  6211          CDF 10
02105  5707          SETFLD&177+5600
02106  5776          -2002
02107  0004          4

02110  1056  OPTIMB, TAD HIGHTG
02111  4307          SETFLD&177+4200
02112  1011          TAD TAGXR
02113  3012          DCA XREG1
02114  1012          TAD XREG1
02115  1316          SETFLD+7&177+1200
02116  3013          DCA XREG2
02117  1055          TAD THISTG
02120  4307          SETFLD&177+4200
02121  1413          TAD I XREG2
02122  3412          DCA I XREG1
02123  1012          TAD XREG1
02124  7041          CIA
02125  1011          TAD TAGXR
02126  7640          SZA CLA
02127  5222          GETTG5+11&177+5200
02130  6201          CDF


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 37


             /ONCE ONLY CODE FOR /D OPTION
             /PUT INTO SYMLST FOR DDT COMPATIBLE SYMBOL TABLE

02131  3616  DSWIT1, SYMPR6-1&177+3600
02132  4246          SYMPR9+6&177+4200
02133  1116          TAD [377
02134  4446          JMS I OERROR
02135  7240          CLA CMA
02136  3055          DCA THISTG
02137  1132          TAD [215
02140  4446          JMS I OERROR
02141  4270          SYMPPP&177+4200
02142  5237          SYMPR9-1&177+5200
02143  5221          SYMPR6+2&177+5200
02144  1013          HSWIT1
02145  0204  DSWITA, 204



             /OVERLAY CODE FOR DDT SYMBOL TABLE PRINT

02146  5211  DSWIT2, SYMPR5-2&177+5200
02147  1217          SYMPR6&177+1200
02150  4446          JMS I OERROR
02151  1116          TAD [377
02152  4446          JMS I OERROR
02153  4246          SYMPR9+6&177+4200
02154  3057          DCA LINCNT
02155  5600          SYMPRT&177+5600
02156  0000          0
02157  1154          TAD [-200
02160  3064          DCA SYMPR2
02161  1156          TAD [200
02162  4446          JMS I OERROR
02163  2064          ISZ SYMPR2
02164  5251          SYMPR4-2&177+5200
02165  5646  DSWITB, SYMPR9+6&177+5600


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 38



             /**********************************************************

02171  5725
02172  2072
02173  2053
02174  5400
02175  4044
02176  1400
02177  1672
       2217          *LITBF1+17

             /SET FIELD DIGIT

02217  0000  FIELDA, 0
02220  0122          AND [7          /STORE FIELD NUMBER
02221  3031          DCA VALUE
02222  1031          TAD VALUE       /MAKE FIELD NUMBER INTO ASCII DIGIT
02223  1125          TAD ["0
02224  3067          DCA FLDIND
02225  5617          JMP I FIELDA    /--RETURN--


             /PRINT 5 DIGIT ADDRESS

02226  0000  PUNFLD, 0
02227  1067          TAD FLDIND      /PRINT FIELD DIGIT
02230  4446          JMS I OERROR
02231  1027          TAD LOC         /PRINT 4 DIGIT ADDRESS
02232  4634          JMS I PUNFL1
02233  5626          JMP I PUNFLD    /--RETURN--

02234  1310  PUNFL1, OCTPRT


             /POP ENTRY OFF PUSHDOWN LIST
             /AND JUMP TO THAT ADDRESS

02235  1410  POPJ,   TAD I PDLXR
02236  3040          DCA TEMP
02237  5440          JMP I TEMP

             /FROM HERE TO 2277 IS OPEN FOR CHANGES
             /TO MAIN ASSEMBLER CODE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 39


       2400          *2400

             /HANDLER FOR TEXT PSEUDO-OP
             /SPACES ARE IGNORED TO DELIMITER
             /DELIMITER IS FIRST PRINTING CHARACTER
             /OTHER THAN SPACE
             /NON-PRINTING CHARACTERS ARE ILLEGAL
             /A PRINTING CHARACTER HAS EITHER BIT 5
             /OR BIT 6 SET, BUT NOT BOTH

02400  7330  TEXTX,  CLL CLA CML RAR /AC=4000
02401  3061          DCA GETCI       /; AND / ARE NOT END OF LINE
02402  4250          JMS TEXT1A      /CHECK FOR PRINTING CHARACTER
02403  5233          JMP TEXT8       /NON PRINTING - IGNORE
02404  1170          TAD [-240       /IGNORE SPACES UNTIL DELIMITER
02405  7450          SNA             /HAS BEEN FOUND
02406  5233          JMP TEXT8
02407  1135          TAD [240        /RESTORE CHARACTER
02410  7041          CIA
02411  3032          DCA VALUE2      /STORE NEGATIVE DELIMITER
02412  3274          DCA TEXT6       /SET PACKING SWITCH
02413  4574  TEXT3,  JMS I [GETC     /GET NEXT CHARACTER
02414  4250          JMS TEXT1A      /IS IT A PRINTING CHARACTER?
02415  5235          JMP TEXT9       /NO - IC
02416  1032          TAD VALUE2      /YES - IS IT DELIMITER?
02417  7650          SNA CLA
02420  5224          JMP TEXT4       /YES - TERMINATE
02421  1035          TAD CHAR        /NO - PACK AND OUTPUT
02422  4260          JMS TEXT2       /PACK IT
02423  5213          JMP TEXT3

02424  3061  TEXT4,  DCA GETCI       /RESET GETC SWITCH
02425  4574          JMS I [GETC     /SKIP DELIMITER
02426  7200          CLA
02427  4260          JMS TEXT2       /OUTPUT 0 TO FILE
02430  4260          JMS TEXT2
             /CHANGE LAST LOCATION TO:
             /       NOP
             /FOR NO EXTRA WORD OF ZEROS
02431  3061          DCA GETCI       /RESET GETCI TO CALL ; AND / END OF LINE
02432  5577          JMP I [LOOKEX   /--EXIT TO MAIN--

02433  4574  TEXT8,  JMS I [GETC     /GET NEXT CHARACTER
02434  5202          JMP TEXTX+2

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 40



02435  4545  TEXT9,  JMS I [ERROR    /GENERATE IC ERROR MESSAGE
02436  5143          IC
02437  5213          JMP TEXT3

             /SKIP ON NON-PRINTING CHARACTER
02440  0000  TEXT1,  0
02441  0377          AND (140        /IS BITS 5 OR 6 SET?
02442  7450          SNA
02443  5246          JMP .+3         /NO
02444  1376          TAD (-140       /YES - ARE BIT 5 AND 6 SET?
02445  7650          SNA CLA
02446  2240          ISZ TEXT1       /YES - NON-PRINTING CHARACTER
02447  5640          JMP I TEXT1     /--RETURN--

             /SKIP ON PRINTING CHARACTER
02450  0000  TEXT1A, 0
02451  1035          TAD CHAR
02452  7550          SPA SNA         /IS CHARACTER -
02453  5226          JMP TEXT4+2     /YES
02454  4240          JMS TEXT1       /NO - IS IT PRINTING?
02455  2250          ISZ TEXT1A      /YES - INCREMENT RETURN
02456  1035          TAD CHAR        /WITH CHARACTER IN AC
02457  5650          JMP I TEXT1A    /--RETURN--

             /OUTPUT 2 TEXT CHARACTERS (ONE REGISTER)
             /ENTER WITH CHARACTERS IN AC
02460  0000  TEXT2,  0
02461  0175          AND [77         /GET RIGHT 6 BITS
02462  2274          ISZ TEXT6       /WHICH HALF OF WORD?
02463  5267          JMP TEXT5       /LEFT
02464  1275          TAD TEXT7       /RIGHT--ADD IN LEFT HALF
02465  4564          JMS I [PUNBIN   /OUTPUT IT
02466  5660          JMP I TEXT2     /--RETURN--

02467  4555  TEXT5,  JMS I [RTL6     /GET LEFT HALF OF WORD
02470  3275          DCA TEXT7       /SAVE IT
02471  7240          CLA CMA         /SET SWITCH FOR RIGHT HALF
02472  3274          DCA TEXT6
02473  5660          JMP I TEXT2     /--RETURN--

02474  0000  TEXT6,  0
02475  0000  TEXT7,  0

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 41


             /HANDLER FOR EXPUNGE PSEUDO-OP

02476  1047  EXPUNX, TAD PASS        /IS THIS PASS 1
02477  7700          SMA CLA
02500  5577          JMP I [LOOKEX   /NO--EXIT TO MAIN--
02501  5775          JMP I (EXPUNW   /YES-CONTINUE AT EXPUNW


             /ADD BITS TO PUNCH ORIGIN

02502  0000  PUNORG, 0
02503  3027          DCA LOC
02504  1047          TAD PASS        /IS THIS PASS 2?
02505  7640          SZA CLA
02506  5702          JMP I PUNORG    /NO--RETURN--
02507  1027          TAD LOC         /YES - OUTPUT ORIGIN SETTING
02510  7120          CLL CML
02511  4521          JMS I [PUNOUT
02512  5702          JMP I PUNORG    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 42



02513  0000  MOUNT,  0
02514  7300          CLA CLL         /JUST IN CASE WE GET BY AN ERROR CALL
02515  4774'         JMS WRTMSG
02516  7031          MOUNTM
02517  1074          TAD IPTR
02520  7001          IAC
02521  3073          DCA SPTR        /GET CURRENT FILE POINTER
02522  1373          TAD (-6
02523  3071          DCA KNT
02524  4772'         JMS OUTEM       /TYPE OUT THE FILENAME
02525  1371          TAD (".&177
02526  4770'         JMS TOUT
02527  7346          CLA CLL CMA RTL
02530  3071          DCA KNT         /EXTENSION KNT
02531  4772'         JMS OUTEM
02532  1367  ASKAGN, TAD ("?&177+400 /A MUST PRINT CHAR
02533  4770'         JMS TOUT
02534  4766'         JMS KIN
02535  1156          TAD [200        /CONVERT TO ASSEM NOTATION
02536  3035          DCA CHAR
02537  1035          TAD CHAR
02540  4770'         JMS TOUT
02541  1365          TAD (CHAR
02542  4764'         JMS CNAME
02543  7777          -1;BCLOSW
02544  5350
02545  7410          SKP
02546  5332          JMP ASKAGN
02547  4763'         JMS TSTNUM      /ASSEMBLERS CHECK DIGIT ROUTIE
02550  7410          SKP
02551  5332          JMP ASKAGN      /WASN'T A DIGIT
02552  7330          CLA CLL CML RAR
02553  0474          AND I IPTR      /TURN OFF MOUNT BIT BUT LEAVE BACK SPACE ALONE
02554  1035          TAD CHAR
02555  3474          DCA I IPTR
02556  4774'         JMS WRTMSG
02557  7041          CRLFR
02560  5713          JMP I MOUNT

02563  4734
02564  7107
02565  0035
02566  7003
02567  0477
02570  7000
02571  0056
02572  5137
02573  7772
02574  7014
02575  5216
02576  7640
02577  0140
       2600          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 43



             /MAINLINE CODE

02600  0000  LOOKE2, 0               /WAS THIS END OF LINE
02601  1035          TAD CHAR        / OR END OF CONDITIONAL?
02602  1115          TAD [-">
02603  7450          SNA
02604  5236          JMP CONEND      /END OF CONDITIONAL
02605  1377          TAD (">
02606  7700          SMA CLA
02607  5600          JMP I LOOKE2    /NOT END OF LINE--RETURN--
02610  4574  LOOKE1, JMS I [GETC     /GET A CHARACTER
             MAIN,
02611  4566  MAIN1,  JMS I [SPNOR    /IGNORE SPACES
02612  1035          TAD CHAR
02613  1376          TAD (-"$        /WAS IT $ ?
02614  7450          SNA             /YES--
02615  5775          JMP I (ENDPAS   /NO-END THIS PASS
02616  1374          TAD ("$-"*
02617  7650          SNA CLA         /WAS IT * ?
02620  5245          JMP STAR        /YES-HANDLE *
02621  4543          JMS I [TSTALP   /NO-WAS IT ALPHABETIC?
02622  5270          JMP ALPHA       /YES
02623  4200          JMS LOOKE2      /NO
02624  4565  TOEXP,  JMS I [EXP      /GET REST OF EXPRESSION
02625  1065          TAD LININD
02626  3064          DCA LINKSW      /STORE LINK SWITCH
02627  1031          TAD VALUE
02630  4564          JMS I [PUNBIN   /OUTPUT THE REGISTER
02631  4566  LOOKEX, JMS I [SPNOR    /IGNORE TRAILING SPACES
02632  4200          JMS LOOKE2      /IS LINE ENDED?
02633  4545  ILCHAR, JMS I [ERROR    /NO-GENERATE IC ERROR MESSAGE
02634  5143          IC
02635  5243          JMP CONEN1

02636  1051  CONEND, TAD CONDSW      /ARE WE INTO CONDITIONALS?
02637  7450          SNA
02640  5233          JMP ILCHAR      /NO - > IS ILLEGAL
02641  7001          IAC             /ONE LESS CONDITIONAL
02642  3051          DCA CONDSW
02643  4574  CONEN1, JMS I [GETC     /GET NEXT CHARACTER
02644  5231          JMP LOOKEX      /AND TRY FOR END AGAIN

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 44



             /HANDLER FOR *

02645  4574  STAR,   JMS I [GETC     /GET NEXT CHARACTER AFTER *
02646  4566          JMS I [SPNOR    /IGNORE SPACES
02647  4565          JMS I [EXP      /GET REST OF EXPRESSION
02650  2063          ISZ UNDFSW      /WAS ANYTHING UNDEFINED?
02651  5254          JMP .+3         
02652  4545          JMS I [ERROR    /YES-GENERATE UO ERROR MESSAGE
02653  6557          UO
02654  1031          TAD VALUE       /NO
02655  3030          DCA OP
02656  1027          TAD LOC         /IS THIS THE SAME PAGE AS
02657  0154          AND [7600       /THE PREVIOUS CODE?
02660  7041          CIA
02661  1030          TAD OP
02662  0154          AND [7600
02663  7650          SNA CLA
02664  5773          JMP I (STAR2    /YES-PUNCH ORIGIN
02665  4562          JMS I [DUMPS    /NO-DUMP LITERALS
02666  1030          TAD OP
02667  5772          JMP I (STAR1-2  /PUNCH NEW ORIGIN

02670  4542  ALPHA,  JMS I [GETTAG   /PICK UP TAG-IS IT IN TABLE?
02671  7240          CLA CMA         /NO
02672  3060          DCA ALPHAI      /YES-FIX UNDEFINED TAG SWITCH
02673  1022          TAD TAG3        /IS IT A PSEUDO-OP?
02674  7710          SPA CLA
02675  5432          JMP I VALUE2    /YES-GO TO ITS HANDLER
02676  1035          TAD CHAR        /NO
02677  1371          TAD (-",        /WAS IT TERMINATED BY , ?
02700  7450          SNA
02701  5320          JMP COMMA       /YES-DEFINE THE SYMBOL
02702  1370          TAD (",-"=      /NO-WAS IT TERMINATED BY = ?
02703  7650          SNA CLA
02704  5767          JMP I (EQUAL    /YES-EQUATE THE SYMBOL
02705  7330          CLL CLA CML RAR /NO--AC=4000
02706  5224          JMP TOEXP       /TREAT AS AN EXPRESSION

             /HANDLER FOR "

02707  2034  QUOTE,  ISZ TXTPTR
02710  1434          TAD I TXTPTR    /GET CHARACTER FROM TEXT BUFFER
02711  1140          TAD [-215       /WAS IT CARRIAGE RETURN?
02712  7650          SNA CLA
02713  5766          JMP I (QUOTE1   /YES-IT IS IC-IGNORE "
02714  1434          TAD I TXTPTR    /NO-PUT ASCII CODE INTO
02715  3032          DCA VALUE2      /VALUE WORD
02716  4574          JMS I [GETC     /GET NEXT CHARACTER
02717  5765          JMP I (NUMBE1+1 /RETURN TO EXPRESSION PROCESSOR

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 45



             /HANDLER FOR ,

02720  4574  COMMA,  JMS I [GETC     /GET NEXT CHARACTER
02721  2060          ISZ ALPHAI      /WAS TAG DEFINED PREVIOUSLY?
02722  5337          JMP COMMA2      /YES
02723  1027          TAD LOC         /NO-STORE CURRENT ADDRESS FOR DEFINITION
02724  3032          DCA VALUE2
02725  4547          JMS I [INSRTG   /PUT TAG IN SYMBOL TABLE
02726  1020  COMMA1, TAD TAG1        /STORE FOR ERROR MESSAGE OUTPUT
02727  3014          DCA LAST1
02730  1021          TAD TAG2
02731  3015          DCA LAST2
02732  1022          TAD TAG3
02733  3016          DCA LAST3
02734  1032          TAD VALUE2
02735  3017          DCA LAST4
02736  5211          JMP MAIN        /--EXIT TO MAIN--

02737  1027  COMMA2, TAD LOC         /DO NEW AND OLD DEFINITIONS AGREE?
02740  7041          CIA
02741  1032          TAD VALUE2
02742  7650          SNA CLA
02743  5326          JMP COMMA1      /YES-ALLOW REDEFINITION
02744  4545          JMS I [ERROR    /NO-GENERATE ID ERROR MESSAGE
02745  5144          ID
02746  5211          JMP MAIN        /--EXIT TO MAIN--


             /HANDLER FOR ! AND SPACE AS INCLUSIVE OR

02747  1032  OP5,    TAD VALUE2
02750  0031          AND VALUE
02751  7040          CMA
02752  0032          AND VALUE2
02753  5764          JMP I (OP0+1

02764  3401
02765  3132
02766  3146
02767  0466
02770  7757
02771  7524
02772  0454
02773  4147
02774  7772
02775  4223
02776  7534
02777  0276
       3000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 46



             /EXPRESSION PROCESSOR
             /POSSIBLE RECURSIVE ENTRY
             /ENTER WITH CHARACTER IN CHAR

03000  0000  EXP,    0
03001  3052          DCA EXPIND      /SET INDICATOR (NOT 0 IF NO MRI FOUND)
03002  3065          DCA LININD      /CLEAR LINK GENERATED SWITCH (' )
03003  3031          DCA VALUE       /START WITH "VALUE" = 0
03004  3063          DCA UNDFSW      /CLEAR UNDIFINED SWITCH
03005  1200          TAD EXP
03006  4546          JMS I [PUSHA    /SAVE RETURN ADDRESS
03007  3030          DCA OP          /OP=0; ADD
03010  1052          TAD EXPIND
03011  7710          SPA CLA
03012  5777          JMP I (EXPINT
03013  1035          TAD CHAR        /IS CHARACTER A + ?
03014  1114          TAD [-"+
03015  7450          SNA
03016  5223          JMP EXP1-1      /YES-OP=0
03017  1113          TAD ["+-"-      /NO-IS CHARACTER A - ?
03020  7640          SZA CLA
03021  5225          JMP EXP1+1      /NO
03022  2030          ISZ OP          /YES-OP=1
03023  4574          JMS I [GETC     /GET NEXT CHARACTER
03024  2052  EXP1,   ISZ EXPIND      /MRI NO LONGER LEGAL ON THIS LINE
03025  1035          TAD CHAR        /IS CHARACTER A . ?
03026  1112          TAD [-".
03027  7450          SNA
03030  5343          JMP PERIOD      /YES-GO TO . HANDLER
03031  1376          TAD (".-""      /NO-IS IT " ?
03032  7450          SNA
03033  5775          JMP I (QUOTE    /YES-GO TO " HANDLER
03034  1374          TAD (""-"[      /NO-IS IT [ ?
03035  7450          SNA
03036  5773          JMP I (LITZ     /YES-HANDLER PAGE 0 LITERAL
03037  1372          TAD ("[-"(      /NO-IS IT ( ?
03040  7650          SNA CLA
03041  5771          JMP I (LITS     /YES-HANDLE SAME PAGE LITERAL

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 47



03042  4543          JMS I [TSTALP   /NO-IS IT ALPHABETIC?
03043  5770          JMP I (ALPHA1   /YES-HANDLE SYMBOL
03044  4511          JMS I [TSTNUM   /NO-IS IT NUMERIC?
03045  5302          JMP NUMBER      /YES-HANDLE NUMBER

03046  4256  EXP2,   JMS ENDCHK      /NO-CHECK FOR END
03047  5225          JMP EXP1+1      /NOGO - TRY AGAIN
03050  1030          TAD OP
03051  1110          TAD [-5         /IS OP SPACE (5)
03052  7650          SNA CLA
03053  5767          JMP I (EXPXIT   /YES-EXIT
03054  3035          DCA CHAR        /MAKE AN ILLEGAL CHARARACTER
03055  5246          JMP EXP2


             /END OF EXPRESSION CHECK
             /SKIP IF OK

03056  0000  ENDCHK, 0
03057  1035          TAD CHAR
03060  1366          TAD (-"]        /IS CHARACTER A ] ?
03061  7440          SZA             /YES-SKIP A EXIT
03062  1365          TAD ("]-")      /IS CHARACTER A ) ?
03063  7440          SZA             /YES-SKIP A EXIT
03064  1364          TAD (")-">      /IS CHARACTER A > ?
03065  7440          SZA             /YES-SKIP AND EXIT
03066  1363          TAD (">-"<      /IS CHARACTER A < ?
03067  7450          SNA
03070  5300          JMP ENDCH1      /YES-SKIP AND EXIT
03071  1362          TAD ("<
03072  7710          SPA CLA         /IS IT END-OF-LINE?
03073  5300          JMP ENDCH1      /YES-SKIP AND EXIT
03074  4545          JMS I [ERROR    /NO-GENERATE IC ERROR MESSAGE
03075  5143          IC
03076  4574          JMS I [GETC     /GET NEXT CHARACTER & TRY AGAIN
03077  5656          JMP I ENDCHK    /--RETURN--

03100  2256  ENDCH1, ISZ ENDCHK      /INCREMENT RETURN ADDRESS
03101  5656          JMP I ENDCHK    /--RETURN--


03102  3040  NUMBER, DCA TEMP
03103  1024  NUMBE2, TAD RADIX       /IS THE CURRENT RADIX OCTAL?
03104  7650          SNA CLA
03105  1035          TAD CHAR        /YES-IS THE DIGIT GREATER THAN 7?
03106  1361          TAD (-"8
03107  7700          SMA CLA
03110  5340          JMP NUMBE3      /YES-ILLEGAL CHARACTER
03111  1040          TAD TEMP        /NO-ADD IT TO THE PREVIOUS
03112  7104          CLL RAL         /ACCUMULATED VALUE
03113  7104          CLL RAL
03114  3042          DCA TEMP2

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 48



03115  1024          TAD RADIX       /IS RADIX OCTAL?
03116  7640          SZA CLA
03117  1040          TAD TEMP        /NO
03120  1042          TAD TEMP2       /YES
03121  7104          CLL RAL
03122  1035          TAD CHAR
03123  1107          TAD [-"0
03124  3040          DCA TEMP
03125  4574  NUMBE4, JMS I [GETC     /GET NEXT CHARACTER
03126  4511          JMS I [TSTNUM   /IS IT NUMERIC?
03127  5303          JMP NUMBE2      /YES-CONTINUE ACCUMULATING NUMBER
03130  1040          TAD TEMP        /NO-STORE NUMBER
03131  3032  NUMBE1, DCA VALUE2
03132  1030          TAD OP          /GO COMBINE IT VIA LAST OPERATION
03133  1360          TAD (OPTABL
03134  3040          DCA TEMP        /FIND THE OPERATOR HANDLER
03135  1440          TAD I TEMP
03136  3040          DCA TEMP
03137  5440          JMP I TEMP      /GO TO THE HANDLER
             /8 OR 9 FOUND DURING OCTAL RADIX
03140  4545  NUMBE3, JMS I [ERROR    /GENERATE IC ERROR MESSAGE
03141  5143          IC
03142  5325          JMP NUMBE4      /IGNORE CHARACTER

             /HANDLER FOR .
03143  4574  PERIOD, JMS I [GETC     /GET NEXT CHARACTER
03144  1027          TAD LOC         /MAKE CURRENT LOCATION
03145  5331          JMP NUMBE1      /INTO VALUE OF NUMBER

             /CARRIAGE RETURN FOUND IN SINGLE CHARACTER TEXT

03146  4545  QUOTE1, JMS I [ERROR    /GENERATE IC ERROR MESSAGE
03147  5143          IC
03150  7240          CLA CMA
03151  3035          DCA CHAR
03152  5767          JMP I (EXPXIT

03160  3553
03161  7510
03162  0274
03163  0002
03164  7753
03165  0064
03166  7443
03167  3433
03170  3200
03171  4400
03172  0063
03173  4401
03174  7707
03175  2707
03176  0014
03177  3262

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 48-1

       3200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 49



03200  4542  ALPHA1, JMS I [GETTAG   /PICK UP TAG-WAS IT IN TABLE?
03201  7240          CLA CMA         /NO-SET UNDEFINED INDICATOR
03202  3060          DCA ALPHAI      /YES-CLEAR UNDEFINED INDICATOR
03203  1022          TAD TAG3        /IS IT A PSEUDO-OP?
03204  7700          SMA CLA
03205  5210          JMP .+3
03206  4545          JMS I [ERROR    /YES-GENERATE IP ERROR MESSAGE
03207  5160          IP
03210  2060          ISZ ALPHAI      /NO-WAS IT UNDEFINED?
03211  5220          JMP .+7
03212  2063          ISZ UNDFSW      /YES-SET UNDEFINED SWITCH
03213  1047          TAD PASS        /IS THIS PASS 1?
03214  7710          SPA CLA
03215  5220          JMP .+3         /YES-SUPPRESS ERROR MAESSAGE
03216  4545          JMS I [ERROR    /NO-GENERATE US ERROR MESSAGE
03217  6563          US
03220  1021          TAD TAG2        /NO-WAS IT A MEMORY REFERENCE INSTRUCTION?
03221  7700          SMA CLA
03222  5777          JMP I (NUMBE1+1 /NO-GO COMBINE IT VIA LAST OPERATOR
03223  1035          TAD CHAR        /YES-GET TERMINATING CHARACTER
03224  1170          TAD [-240       /WAS IT SPACE?
03225  7640          SZA CLA
03226  5777          JMP I (NUMBE1+1 /NO
03227  4566          JMS I [SPNOR    /YES-IGNORE SPACES
03230  1035          TAD CHAR
03231  7710          SPA CLA
03232  5777          JMP I (NUMBE1+1
03233  1052          TAD EXPIND      /IS MEMORY REFERENCE INSTRUCTION OK?
03234  7640          SZA CLA
03235  5777          JMP I (NUMBE1+1 /NO-
03236  3054          DCA IZIND       /YES-CLEAR I AND Z INDICATOR
03237  1032          TAD VALUE2      /STORE MRI ON PUSHDOWN LIST
03240  4546          JMS I [PUSHA

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 50



03241  4543  ALPHA6, JMS I [TSTALP   /WAS TERMINATING CHARACTER ALPHABETIC?
03242  7410          SKP
03243  5272          JMP ALPHA4      /NO-
03244  4542          JMS I [GETTAG   /YES-PICK UP TAG-IS IT IN TABLE?
03245  7240          CLA CMA         /NO-SET UNDEFINED INDICATOR
03246  3060          DCA ALPHAI      /YES-CLEAR UNDEFINED INDICATOR
03247  7332          CLL CLA CML RTR /AC=2000
03250  0020          AND TAG1        /WAS IT AN I OR Z?
03251  7650          SNA CLA
03252  5266          JMP ALPHA5      /NO
03253  1032          TAD VALUE2      /YES-WAS IT I?
03254  7450          SNA
03255  2054          ISZ IZIND
03256  1054          TAD IZIND
03257  3054          DCA IZIND
03260  4566          JMS I [SPNOR    /IGNORE SPACES
03261  5241          JMP ALPHA6

03262  1052  EXPINT, TAD EXPIND
03263  1147          TAD [4000
03264  3052          DCA EXPIND
03265  5203          JMP ALPHA1+3

03266  1054  ALPHA5, TAD IZIND       /SAVE I OR Z INDICATOR
03267  4546          JMS I [PUSHA
03270  7330          CLL CLA CML RAR /AC=4000
03271  5274          JMP ALPHA4+2

03272  1054  ALPHA4, TAD IZIND       /SAVE I OR Z INDICATOR
03273  4546          JMS I [PUSHA    /ON PUSHDOWN LIST
03274  7001          IAC
03275  4565          JMS I [EXP      /GET REST OF EXPRESSION
03276  1410          TAD I PDLXR     /RETRIEVE MRI
03277  3054          DCA IZIND
03300  1410          TAD I PDLXR
03301  3032          DCA VALUE2
03302  3065          DCA LININD      /CLEAR LINK GENERATED SWITCH
03303  1054          TAD IZIND       /WAS Z FOUND?
03304  0175          AND [77
03305  7650          SNA CLA
03306  5315          JMP FIX1        /NO-COMBINE ADDRESS WITH INSTRUCTION
03307  1031          TAD VALUE       /YES-IS THIS PAGE 0?
03310  0154          AND [7600
03311  7650          SNA CLA
03312  5337          JMP FIX4        /YES-
03313  4545          JMS I [ERROR    /NO-GENERATE IZ ERROR MESSAGE
03314  5172          IZ

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 51



             /COMBINE ADDRESS WITH MEMORY REFERENCE INSTRUCTION

03315  1031  FIX1,   TAD VALUE       /GET ADDRESS
03316  0154          AND [7600
03317  7450          SNA             /IS IT PAGE 0?
03320  5337          JMP FIX4        /YES
03321  7041          CIA             /NO-IS IT ON CURRENT PAGE?
03322  1027          TAD LOC
03323  0154          AND [7600
03324  7650          SNA CLA
03325  5334          JMP FIX2        /YES
03326  1031          TAD VALUE       /NO-SET UP LINK
03327  4776          JMS I (FINDS
03330  3031          DCA VALUE
03331  1106          TAD [0700       /SET INDICATOR TO PRINT '
03332  3065          DCA LININD      /TO SHOW LINK GENERATED
03333  1105          TAD [400
03334  1156  FIX2,   TAD [200        /SET CURRENT PAGE BIT
03335  1032          TAD VALUE2
03336  3032          DCA VALUE2
03337  1054  FIX4,   TAD IZIND       /WAS THERE AN I?
03340  0160          AND [7700
03341  7650          SNA CLA
03342  5355          JMP FIX3        /NO
03343  1032          TAD VALUE2      /YES-SET INDIRECT BIT
03344  0105          AND [400
03345  7650          SNA CLA         /WAS INDIRECT BIT ALREADY SET?
03346  5352          JMP FIX5        /NO
03347  4545          JMS I [ERROR    /YES-GENERATE II ERROR MESSAGE
03350  5151          II
03351  5355          JMP FIX3        /OUTPUT CODE AS IS

             /SET INDIRECT BIT
03352  1105  FIX5,   TAD [400
03353  1032          TAD VALUE2
03354  3032          DCA VALUE2
             /COMBINE ADDRESS WITH MRI
03355  1031  FIX3,   TAD VALUE       /GET ADDRESS
03356  0176          AND [177
03357  1032          TAD VALUE2      /GET OP CODE
03360  3031          DCA VALUE       /STORE
03361  5504          JMP I [POPJ     /--EXIT VIA POPJ--

             /FETCH CHARACTER FROM TTY AND CHECK FOR ^O

03362  0000  OTYPEO, 0
03363  4775          JMS I (OTYPE1   /TYPE CHARACTER IN AC
03364  5762          JMP I OTYPEO    /NO--RETURN--

03375  5023
03376  4447
03377  3132
       3400          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 52



             /COMBINE CURRENT VALUE WITH PREVIOUS VALUE
             /ACCORDING TO LAST OPERATOR

03400  1032  OP0,    TAD VALUE2      /HANDLER FOR +
03401  1031          TAD VALUE
03402  3031          DCA VALUE
03403  1035  EXP3,   TAD CHAR        /GET LAST OPERATOR
03404  1114          TAD [-"+        /WAS IT A + ?
03405  7450          SNA
03406  5250          JMP EXP4+5      /YES
03407  1113          TAD ["+-"-      /NO-WAS IT A - ?
03410  7450          SNA
03411  5247          JMP EXP4+4      /YES
03412  1122          TAD [7          /NO("--"& = 255-246 = 7)-WAS IT & ?
03413  7450          SNA
03414  5246          JMP EXP4+3      /YES-
03415  1377          TAD ("&-"!      /NO-WAS IT ! ?
03416  7450          SNA
03417  5245          JMP EXP4+2      /YES
03420  1376          TAD ("!-"^      /NO-WAS IT ^ ?
03421  7450          SNA
03422  5244          JMP EXP4+1      /YES
03423  1375          TAD ("^-240     /NO-WAS IT SPACE?
03424  7450          SNA
03425  5243          JMP EXP4        /YES
03426  1374          TAD (240-"%     /NO-WAS IT % ?
03427  7650          SNA CLA
03430  5242          JMP EXP4-1      /YES
03431  4773          JMS I (ENDCHK   /NO-SEE IF END OF LINE FOUND
03432  5203          JMP EXP3        /NO-TRY AGAIN
03433  1063  EXPXIT, TAD UNDFSW      /EXIT FROM EXP
03434  7650          SNA CLA         /RESTORE EXIT POINT
03435  5504          JMP I [POPJ     /--EXIT VIA POPJ--
03436  7240          CLA CMA
03437  3063          DCA UNDFSW      /SET UNDEFINED SWITCH
03440  3031          DCA VALUE       /RESULT IS 0
03441  5504          JMP I [POPJ     /--EXIT VIA POPJ--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 53



03442  7001          IAC
03443  7001  EXP4,   IAC
03444  7001          IAC
03445  7001          IAC
03446  7001          IAC
03447  7001          IAC
03450  3030          DCA OP
03451  4574          JMS I [GETC     /GET NEXT CHARACTER
03452  5772          JMP I (EXP1     /GET REST OF EXPRESSION

             /HANDLER FOR &

03453  1031  OP2,    TAD VALUE
03454  0032          AND VALUE2
03455  5202          JMP OP0+2


             /HANDLER FOR ^
             /MULTIPLY BY REPEATED ADDITION

03456  1031  OP4,    TAD VALUE
03457  7041          CIA
03460  3040          DCA TEMP
03461  1032          TAD VALUE2
03462  2040          ISZ TEMP
03463  5261          JMP .-2
03464  5202          JMP OP0+2

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 54



             /CHARACTER INPUT CHECK
             /ENTER WITH CHARACTER IN AC

03465  1371  LSTCH9, TAD (-177
03466  7440          SZA             /IGNORE RUBOUT (377)
03467  1370          TAD (177-13
03470  7440          SZA             /IGNORE VERTICAL TAB (213)
03471  7001          IAC
03472  7450          SNA
03473  5767          JMP I (INPUT+1  /IGNORE LINE FEED (212)
03474  1103          TAD [12-32      /WAS IT ^Z (END-OF-FILE=232)?
03475  7450          SNA
03476  5766          JMP I (GETFLE   /YES - GET NEXT FILE
03477  1365          TAD (32-15      /NO - WAS IT CARRIAGE RETURN?
03500  7450          SNA
03501  5332          JMP LSTCHR      /YES - LAST CHARACTER OF LINE
03502  7001          IAC             /NO
03503  7450          SNA             /WAS IT FORM FEED (214)?
03504  5346          JMP FORCHR      /YES - HANDLER FORM FEED
03505  2764          ISZ I (INPUT
03506  1363  LSTCH2, TAD (14+200
03507  3327          DCA LSTCH5      /STORE CHARACTER
03510  1047          TAD PASS        /IS THIS PASS 3?
03511  7750          SPA SNA CLA
03512  5317          JMP LSTCH4      /NO -
03513  2330          ISZ LSTCH6      /YES - FILLING HEADER AREA?
03514  5323          JMP LSTCH3      /YES
03515  7240          CLA CMA         /NO - RESET SWITCH
03516  3330          DCA LSTCH6
03517  1764  LSTCH4, TAD I (INPUT
03520  3040          DCA TEMP
03521  1327          TAD LSTCH5      /GET CHARACTER IN AC
03522  5440          JMP I TEMP      /-EXIT FROM INPUT-

03523  2331  LSTCH3, ISZ LSTCH7      /FILLING HEADER
03524  1327          TAD LSTCH5      /STORE CHARACTER IN HEADER AREA
03525  3731          DCA I LSTCH7
03526  5317          JMP LSTCH4

03527  0000  LSTCH5, 0
03530  7740  LSTCH6, -40
03531  1455  LSTCH7, HEADER-1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 55




03532  1350  LSTCHR, TAD FORMSW      /CARRIAGE RETURN WAS FOUND
03533  7650          SNA CLA         /HAS THERE BEEN A FORM FEED?
03534  5343          JMP LSTCH1      /NO -
03535  3350          DCA FORMSW      /YES - CLEAR FORM FEED SWITCH
03536  2037          ISZ EDITPG      /GO TO NEXT EDITOR PAGE
03537  3036          DCA THISPG      /CLEAR OVERFLOW PAGE
03540  1047          TAD PASS        /IS THIS PASS 3?
03541  7740          SMA SZA CLA
03542  4533          JMS I [FORMFD   /YES - GENERATE FORM FEED
03543  1132  LSTCH1, TAD [215        /NO - CARRIAGE RETURN IS CHARACTER
03544  3327          DCA LSTCH5
03545  5315          JMP LSTCH4-2    /EXIT

03546  2350  FORCHR, ISZ FORMSW      /SET FORM FEED SWITCH
03547  5767          JMP I (INPUT+1  /GET ANOTHER CHARACTER

03550  0001  FORMSW, 1

03551  1362  PUSHA1, TAD (BE         /GENERATE BE ERROR MESSAGE
03552  5502          JMP I [MONERR   /**FATAL ERROR**

             /TABLE OF OPERATOR HANDLING ROUTINES

03553  3400  OPTABL, OP0             /+
03554  5134          OP1             /-
03555  3453          OP2             /&
03556  2747          OP5             /!
03557  3456          OP4             /^
03560  2747          OP5             /(SPACE)
03561  5005          OP6             /%

03562  4245
03563  0214
03564  7253
03565  0015
03566  7260
03567  7254
03570  0164
03571  7601
03572  3024
03573  3056
03574  7773
03575  0076
03576  7703
03577  0005
       3600          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 56



             /ERROR MESSAGE OUTPUT
03600  0000  ERROR,  0
03601  7200          CLA
03602  1600          TAD I ERROR     /GET ERROR MESSAGE
03603  2200          ISZ ERROR       /INCREMENT RETURN ADDRESS
03604  4344          JMS ERROR1      /OUTPUT 2 CHARACTER ERROR MESSAGE
03605  1047          TAD PASS        /IS THIS PASS 3?
03606  7740          SMA SZA CLA
03607  5236          JMP ERROR4      /YES - CARRIAGE RETURN/LINE FEED
03610  4344          JMS ERROR1      /NO - OUTPUT 2 SPACES
03611  1171          TAD [1777       /IS THERE A TAG SAVED?
03612  0014          AND LAST1
03613  7450          SNA
03614  5226          JMP ERROR3      /NO
03615  4777          JMS I (DIV45    /YES - OUTPUT FIRST 2 CHARACTERS
03616  7350          CLL CLA CMA RAR /AC=3777
03617  0015          AND LAST2       /OUTPUT SECOND 2 CHARACTERS
03620  4777          JMS I (DIV45
03621  7350          CLL CLA CMA RAR /AC=3777
03622  0016          AND LAST3
03623  4777          JMS I (DIV45    /OUTPUT THIRD 2 CHARACTERS
03624  1017          TAD LAST4       /IS ERROR LOCATION SAME AS LAST TAG?
03625  7041          CIA
03626  1027  ERROR3, TAD LOC
03627  7450          SNA
03630  5236          JMP ERROR4      /YES - CARRIAGE RETURN
03631  3246          DCA ERROR5      /NO - OUTPUT +
03632  1376          TAD ("+
03633  4446          JMS I OERROR
03634  1246          TAD ERROR5      /OUTPUT 4 DIGIT ADDRESS OR INCREMENT
03635  4775          JMS I (OCTPRT
03636  1132  ERROR4, TAD [215        /OUTPUT CARRIAGE RETURN/LINE FEED
03637  4446          JMS I OERROR
03640  5600          JMP I ERROR     /--RETURN--

             /OUTPUT 1 ERROR MESSAGE CHARACTER

03641  0000  ERROR2, 0
03642  0175          AND [77
03643  1135          TAD [240        /MAKE ASCII CHARACTER
03644  4446          JMS I OERROR
03645  5641          JMP I ERROR2    /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 57


             ERROR5,

             /RESET LITERAL TABLES AND POINTERS

03646  0000  CLEAN,  0
03647  1374          TAD (LITBUF-1
03650  3012          DCA XREG1       /SET LITERAL TABLE POINTER
03651  1373          TAD (TPINST-1
03652  3013          DCA XREG2       /SET TOP INST. TABLE POINTER
03653  1120          TAD [-40
03654  3040          DCA TEMP
03655  1156          TAD [200
03656  3412          DCA I XREG1     /SET LITERAL TABLE ENTRIES TO 200
03657  3413          DCA I XREG2     /SET TOP INST. TABLE ENTRIES TO 0
03660  2040          ISZ TEMP
03661  5255          JMP .-4
03662  3014          DCA LAST1       /CLEAR LAST DEFINED TAG
03663  5646          JMP I CLEAN     /--RETURN--


             /DUMP CURRENT PAGE LITERALS

03664  0000  DUMPS,  0
03665  4552          JMS I [FINDSP   /PAGE ZERO?
03666  7450          SNA
03667  5664          JMP I DUMPS     /YES --RETURN--
03670  1151          TAD [LITBUF     /NO
03671  3200          DCA DUMPS1
03672  1023          TAD LITPTR
03673  7041          CIA
03674  1600          TAD I DUMPS1    /ARE THERE LITERALS ON THIS PAGE?
03675  7500          SMA
03676  5323          JMP DUMPS4      /NO - EXIT
03677  3325          DCA DUMPS2      /YES
03700  1027          TAD LOC
03701  0154          AND [7600
03702  1600          TAD I DUMPS1
03703  4553          JMS I [PUNORG   /OUTPUT ORIGIN
03704  1600          TAD I DUMPS1
03705  1101          TAD [LITBF1
03706  3200          DCA DUMPS1
03707  1541  DUMPS3, TAD I [LINBUF   /SAVE LINBUF
03710  4546          JMS I [PUSHA
03711  3541          DCA I [LINBUF
03712  1600          TAD I DUMPS1
03713  3031          DCA VALUE
03714  4563          JMS I [PUNONE   /OUTPUT ONE REGISTER
03715  2027          ISZ LOC
03716  2200          ISZ DUMPS1
03717  2325          ISZ DUMPS2
03720  5312          JMP DUMPS3+3
03721  1410          TAD I PDLXR
03722  3541          DCA I [LINBUF   /RESTORE LINBUF
03723  7200  DUMPS4, CLA

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 57-1

03724  5664          JMP I DUMPS     /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 58



             /DUMP PAGE 0 LITERALS

03725  0000  DUMPZ,  0
03726  1325          TAD DUMPZ       /RESET EXIT FROM DUMPS
03727  3264          DCA DUMPS
03730  1156          TAD [200
03731  7041          CIA
03732  1551          TAD I [LITBUF   /ARE THERE LITERALS TO DUMP?
03733  7500          SMA
03734  5323          JMP DUMPS4      /NO-EXIT
03735  3325          DCA DUMPS2      /YES-SET COUNTER
03736  1551          TAD I [LITBUF   /SET VALUES FOR DUMPS
03737  1372          TAD (LITBF2
03740  3200          DCA DUMPS1
03741  1551          TAD I [LITBUF
03742  4553          JMS I [PUNORG   /OUTPUT ORIGIN
03743  5307          JMP DUMPS3

       3600  DUMPS1=ERROR
       3725  DUMPS2=DUMPZ


             /OUTPUT 2 CHARACTER ERROR CODE

03744  0000  ERROR1, 0
03745  3246          DCA ERROR5
03746  1246          TAD ERROR5
03747  4555          JMS I [RTL6
03750  7004          RAL
03751  4241          JMS ERROR2      /OUTPUT FIRST CHARACTER
03752  1246          TAD ERROR5
03753  4241          JMS ERROR2      /OUTPUT SECOND CHARACTER
03754  5744          JMP I ERROR1    /--RETURN--

03772  2017
03773  1775
03774  1735
03775  1310
03776  0253
03777  4047
       4000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 59



             /ENTER A TAG INTO SYMBOL TABLE

04000  0000  INSRTG, 0
04001  1032          TAD VALUE2      /SAVE VALUE 2
04002  4546          JMS I [PUSHA
04003  2056          ISZ HIGHTG      /COUNT IN THIS TAG
04004  1244          TAD TAGMAX
04005  7141          CLL CIA         /GET LIMIT OF SYMBOL STORAGE
04006  1056          TAD HIGHTG      /IS THERE ROOM FOR ONE MORE?
04007  7630          SZL CLA
04010  5245          JMP GETTG7      /NO - SE**FATAL ERROR**
04011  1055  GETTG5, TAD THISTG      /SEARCH SYMBOL TABLE
04012  3042          DCA TEMP2
04013  1056          TAD HIGHTG
04014  7001          IAC
04015  3055          DCA THISTG
04016  7344  GETTG8, CLL CLA CMA RAL /AC=7776
04017  1055          TAD THISTG
04020  3055          DCA THISTG
04021  4572          JMS I [FINDTG   /GET NEXT TAG FROM SYMBOL TABLE
04022  2055          ISZ THISTG
04023  1055          TAD THISTG
04024  7041          CIA
04025  1042          TAD TEMP2       /DOES NEW TAG GO WHERE PREVIOUS TAG WAS?
04026  7650          SNA CLA
04027  5232          JMP GETTG9      /YES-PUT IT THERE AND EXIT
04030  4544          JMS I [PUTTAG   /NO-REPLACE RETRIEVED TAG WHERE PREVIOUS TAG WAS
04031  5216          JMP GETTG8
             /THE ABOVE CODE WILL BE OPTIMIZED AT INITIALIZATION
             /IF THE ASSEMBLER IS TO BE RESTRICTED TO 8K OF CORE


04032  1777  GETTG9, TAD I (NAME1    /GET CURRENT TAG
04033  3020          DCA TAG1        /PUT IT IN TAG1-TAG3
04034  1776          TAD I (NAME2
04035  3021          DCA TAG2
04036  1775          TAD I (NAME3
04037  3022          DCA TAG3
04040  1410          TAD I PDLXR     /RESTORE VALUE 2
04041  3032          DCA VALUE2
04042  4544          JMS I [PUTTAG   /PUT TAG1 - TAG3 INTO SYMBOL TABLE
04043  5600          JMP I INSRTG    /--RETURN--

04044  1400  TAGMAX, 1400

             /SYMBOL TABLE EXCEEDED

04045  1374  GETTG7, TAD (SE         /GENERATE SE ERROR MESSAGE
04046  5502          JMP I [MONERR   /**FATAL ERROR**

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 60


             /OUTPUT 2 CHARACTER WORD
             /FROM SYMBOL TABLE FORMAT
             /DIVIDE BY 45(8)

04047  0000  DIV45,  0
04050  3272          DCA DIV45B
04051  3307          DCA DIV45C
04052  5255          JMP DIV45D

04053  2307  DIV45A, ISZ DIV45C
04054  3272          DCA DIV45B
04055  1272  DIV45D, TAD DIV45B
04056  1373          TAD (-45
04057  7500          SMA
04060  5253          JMP DIV45A
04061  1372          TAD (45
04062  4273          JMS DIV45E
04063  3272          DCA DIV45B
04064  1307          TAD DIV45C
04065  4273          JMS DIV45E
04066  4555          JMS I [RTL6
04067  1272          TAD DIV45B
04070  4523          JMS I [ERROR1   /OUTPUT 2 CHARACTERS
04071  5647          JMP I DIV45     /--RETURN--

04072  0000  DIV45B, 0

04073  0000  DIV45E, 0
04074  7450          SNA
04075  5673          JMP I DIV45E
04076  1371          TAD (-33
04077  7500          SMA
04100  1370          TAD (20-40-33
04101  1367          TAD (33+40
04102  5673          JMP I DIV45E    /--RETURN--

             /HANDLER FOR FIXTAB PSEUDO-OP

04103  1047  FIXTBX, TAD PASS        /IS THIS PASS 1?
04104  7700          SMA CLA
04105  5577          JMP I [LOOKEX   /NO--EXIT TO MAIN--
04106  5766          JMP I (FIXTAY   /YES--DO FIXTAB
             DIV45C,

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 61




             /SET FIELD

04107  0000  SETFLD, 0
04110  7200          CLA             /SETFLD CALLED WITH AC RANDOM
04111  3330          DCA SETFL1      /INITIALIZE FIELD
04112  1055          TAD THISTG
04113  2330  SETFLP, ISZ SETFL1
04114  7100          CLL
04115  1365          TAD (-1400      /PUT 1400 SYMBOLS IN EACH FIELD
04116  7430          SZL             /IS THE DIVIDE THROUGH?
04117  5313          JMP SETFLP      /NO - CONTINUE
04120  7146          CLL CMA RTL     /AC CONTAINED REM-1400; THIS MAKES IT INTO
04121  1364          TAD (-1         /7573-4*REM WHICH IS THE ADDRESS WE WANT
04122  3011          DCA TAGXR       /TO STICK INTO AN AUTO-XR
04123  1330          TAD SETFL1
04124  7106          CLL RTL
04125  7004          RAL
04126  1345          TAD SETFL2
04127  3330          DCA SETFL1
04130  7402  SETFL1, HLT
04131  5707          JMP I SETFLD    /--RETURN--

             /FIND TAG
             /GET TAG FROM SYMBOL TABLE
             /PUT IT INTO TAG1-TAG3
             /WITH ITS VALUE IN VALUE2

04132  0000  FINDTG, 0
04133  1055          TAD THISTG
04134  4307          JMS SETFLD
04135  1411          TAD I TAGXR
04136  3020          DCA TAG1
04137  1411          TAD I TAGXR
04140  3021          DCA TAG2
04141  1411          TAD I TAGXR
04142  3022          DCA TAG3
04143  1411          TAD I TAGXR
04144  3032          DCA VALUE2
04145  6201  SETFL2, CDF
04146  5732          JMP I FINDTG    /--RETURN--
             /OPTIMIZATION MAY CHANGE SETFLD TO
             /REMOVE CLA ON ENTRY

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 62



04147  1030  STAR2,  TAD OP
04150  4553          JMS I [PUNORG   /PUNCH ORIGIN
04151  3014          DCA LAST1       /CLEAR LAST DEFINED SYMBOL
04152  5550          JMP I [PUNVAL

04164  7777
04165  6400
04166  5200
04167  0073
04170  7725
04171  7745
04172  0045
04173  7733
04174  6345
04175  0202
04176  0201
04177  0200
       4200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 63



             /BEGINNING OF PASS CODE

04200  2047  START2, ISZ PASS        /SET UP COUNTERS AND POINTERS
04201  3026          DCA XLISTX      /CLEAR XLIST SWITCH
04202  4777          JMS I (IINIT    /SET INPUT ROUTINE TO OPEN FILE
04203  3061          DCA GETCI
04204  3025          DCA PUNCHX      /CLEAR PUNCH INHIBIT
04205  3541          DCA I [LINBUF
04206  3024          DCA RADIX       /SET RADIX TO OCTAL
04207  1376          TAD (PDLST
04210  3010          DCA PDLXR       /INITIALIZE PUSHDOWN LIST
04211  1125          TAD ["0         /SET FIELD TO 0
04212  3067          DCA FLDIND
04213  3051          DCA CONDSW
04214  3037          DCA EDITPG
04215  4557          JMS I [CLEAN    /CLEAN UP LITERAL BUFFERS
04216  1156          TAD [200
04217  3023          DCA LITPTR
04220  1156          TAD [200        /PUNCH ORIGIN 0200
04221  4553          JMS I [PUNORG
04222  5775          JMP I (LOOKE1   /--EXIT TO MAIN--

             /HANDLER FOR $

04223  4562  ENDPAS, JMS I [DUMPS    /DUMP CURRENT PAGE LITERALS
04224  1047          TAD PASS        /WHAT PASS IS ENDING?
04225  7450          SNA
04226  5260          JMP ENDPA2      /PASS 2
04227  7710          SPA CLA
04230  5774          JMP I (START1   /PASS 1
04231  1541          TAD I [LINBUF   /PASS 3
04232  7650          SNA CLA         /ANYTHING TO PRINT?
04233  5241          JMP ENDPA1-1    /NO
04234  1137          TAD [211        /YES - TAB OVER TWICE
04235  4446          JMS I OERROR
04236  1137          TAD [211
04237  4446          JMS I OERROR
04240  4773          JMS I (LINPRT   /PRINT LINE
04241  4561          JMS I [DUMPZ    /DUMP PAGE 0 LITERALS
04242  3026  ENDPA1, DCA XLISTX
             /OUTPUT SYMBOL TABLE
04243  4772  SSWITC, JMS I (SYMPRT   /(0 IF /S)
04244  1771          TAD I (FORM21
04245  3770          DCA I (FORM22
04246  4533          JMS I [FORMFD   /OUTPUT FORM FEED
04247  1767' MONWT,  TAD LPCHCT
04250  1766'         TAD TTCHCT
04251  7640          SZA CLA
04252  5247          JMP MONWT
04253  4765'         JMS WRTMSG
04254  7331          UPC             /PRINT ^C AND WAIT FOR CHAR
04255  4764'         JMS KIN
04256  7600          7600

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 63-1

04257  5656          JMP I .-1       /BOOTSTRAP

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 64


             /END PASS 2

04260  4561  ENDPA2, JMS I [DUMPZ    /DUMP PAGE 0 LITERALS
04261  3025          DCA PUNCHX
04262  4763          JMS I (OCLOSE   /CLOSE PASS 2 OUTPUT FILE
04263  1362          TAD (LISOUT
04264  3046          DCA OERROR      /SET NEW OUTPUT TO BE LISTING
04265  2761          ISZ I (OUTPT1
04266  1760'         TAD LSLOT
04267  7650          SNA CLA
04270  5247          JMP MONWT       /NO PASS 3
04271  3757'         DCA OUTINH
04272  1356          TAD (P3O&177+5200       /JUMP TO LIST SUBROUTINE
04273  3755'         DCA OUTPUX+1    /STORE OVER BINARY OUTPUT SUBROUTINE
04274  1354          TAD (-377       /ADDITIONAL RING BUFFER ROOM
04275  3072          DCA CNT
04276  1353          TAD (OBUFR
04277  3070          DCA PTR
04300  3470          DCA I PTR
04301  2070          ISZ PTR
04302  2072          ISZ CNT
04303  5300          JMP .-3
04304  1767'         TAD LPCHCT      /BEFORE MANGLING LPT RING BUFFER
04305  7640          SZA CLA         / MAKE SURE ITS EMPTY
04306  5304          JMP .-2
04307  1752          TAD I (LPBUFR+LPSIZE
04310  3470          DCA I PTR
04311  1353          TAD (OBUFR
04312  3752          DCA I (LPBUFR+LPSIZE
04313  1351          TAD (377
04314  1750'         TAD LPSIZ
04315  3750'         DCA LPSIZ
04316  2760'         ISZ LSLOT
04317  5334          JMP NSWITC      /REALLY WAS LINE PRINTER
04320  1347          TAD (P3OT&177+4600      /JMS TO THE PRINT A TTY CHAR ROUTINE
04321  3746'         DCA P3OF        /MAKE THE LPOCHR JMS A TTOCHR JMS
04322  1766'         TAD TTCHCT
04323  7640          SZA CLA
04324  5322          JMP .-2
04325  1745          TAD I (TTBUFR+TTSIZE
04326  3470          DCA I PTR
04327  1353          TAD (OBUFR
04330  3745          DCA I (TTBUFR+TTSIZE
04331  1351          TAD (377
04332  1744'         TAD TTSIZ
04333  3744'         DCA TTSIZ       /EXPAND TTY RING BUFFER IF LISTING TO IT
04334  5200  NSWITC, JMP START2      /(SKP IF /N) START NEXT PAGES
04335  7000          NOP
04336  5242          JMP ENDPA1

04344  7410
04345  7764
04346  6656
04347  4660

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 64-1

04350  7414
04351  0377
04352  7733
04353  6000
04354  7401
04355  6636
04356  5251
04357  6647
04360  7251
04361  6600
04362  1000
04363  6707
04364  7003
04365  7014
04366  7413
04367  7406
04370  1061
04371  1103
04372  1200
04373  0740
04374  5246
04375  2610
04376  1613
04377  7066
       4400          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 65



             /EVALUATE LITERAL

04400  7240  LITS,   CLA CMA         /CURRENT PAGE
04401  3246  LITZ,   DCA LITS1       /PAGE 0
04402  4574          JMS I [GETC     /GET NEXT CHARACTER
04403  4566          JMS I [SPNOR    /IGNORE SPACES
04404  1052          TAD EXPIND      /STORE IMPORTANT VALUES PRIOR TO
04405  4546          JMS I [PUSHA    /ENTRANCE INTO EXP
04406  1030          TAD OP
04407  4546          JMS I [PUSHA
04410  1031          TAD VALUE
04411  4546          JMS I [PUSHA
04412  1246          TAD LITS1
04413  4546          JMS I [PUSHA
04414  4565          JMS I [EXP      /GET EXPRESSION
04415  1410          TAD I PDLXR     /RETRIEVE PAGE INDICATOR
04416  3246          DCA LITS1
04417  1031          TAD VALUE       /FIND LITERAL IN TABLE
04420  2246          ISZ LITS1       /PAGE 0?
04421  5224          JMP .+3
04422  4247          JMS FINDS       /NO
04423  7410          SKP
04424  4356          JMS FIND0       /YES
04425  3032          DCA VALUE2      /STORE ADDRESS
04426  1246          TAD LITS1
04427  7040          CMA
04430  3246          DCA LITS1
04431  1410          TAD I PDLXR
04432  3031          DCA VALUE
04433  1410          TAD I PDLXR     /RESTORE SAVED VALUES
04434  3030          DCA OP
04435  1410          TAD I PDLXR
04436  3052          DCA EXPIND
04437  1035          TAD CHAR        /IGNORE ) OR ]
04440  1377          TAD (-")
04441  2246          ISZ LITS1
04442  1376          TAD (")-"]
04443  7650          SNA CLA
04444  4574          JMS I [GETC     /GET NEXT CHARACTER
04445  5775          JMP I (NUMBE1+1 /RETURN TO EXPRESSION PROCESSOR

04446  0000  LITS1,  0


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 66




             /FIND LITERAL ON CURRENT PAGE

04447  0000  FINDS,  0
04450  3371          DCA FINDS1
04451  1027          TAD LOC
04452  0154          AND [7600
04453  7450          SNA             /IS THIS PAGE 0?
04454  5362          JMP FIND01      /YES
04455  3372          DCA FINDS2      /NO - SAVE PAGE NUMBER
04456  1101          TAD [LITBF1
04457  3356          DCA FIND0
04460  1160          TAD [7700       /ALLOW 100(8) CURRENT PAGE LITERALS
04461  3004          DCA FORMF6
04462  1023          TAD LITPTR
04463  3373  FIND02, DCA FINDS3
04464  1372          TAD FINDS2
04465  4555          JMS I [RTL6
04466  1151          TAD [LITBUF
04467  3040          DCA TEMP
04470  1356          TAD FIND0
04471  1440          TAD I TEMP
04472  3042          DCA TEMP2
04473  1373          TAD FINDS3
04474  7041          CIA
04475  1440          TAD I TEMP
04476  7450          SNA
04477  5311          JMP FINDS6
04500  3373          DCA FINDS3
04501  1442  FINDS4, TAD I TEMP2     /GET LITERAL FROM TABLE
04502  7041          CIA
04503  1371          TAD FINDS1      /AND CURRENT LITERAL
04504  7650          SNA CLA         /DO THEY MATCH?
04505  5351          JMP FINDS5      /YES
04506  2042          ISZ TEMP2       /NO - BUMP COUNTERS
04507  2373          ISZ FINDS3
04510  5301          JMP FINDS4      /TRY AGAIN
04511  1372  FINDS6, TAD FINDS2
04512  4555          JMS I [RTL6
04513  1117          TAD [TPINST
04514  3373          DCA FINDS3
04515  1440          TAD I TEMP      /DOES THIS OVERFLOW PAGE?
04516  7041          CIA
04517  1773          TAD I FINDS3
04520  7710          SPA CLA
04521  5334          JMP FINDS7      /NO


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 67




04522  1372  FIND03, TAD FINDS2      /YES - PAGE 0?
04523  7650          SNA CLA
04524  5330          JMP .+4
04525  4466          JMS I PERROR    /NO - GENERATE PE ERROR MESSAGE
04526  6045          PE
04527  5332          JMP FINDS8
04530  4466          JMS I PERROR    /YES - GENERATE ZE ERROR MESSAGE
04531  7245          ZE
04532  7240  FINDS8, CLA CMA
04533  5344          JMP FINDS9
04534  7240  FINDS7, CLA CMA
04535  1440          TAD I TEMP      /IS PAGE FULL?
04536  0004          AND FORMF6
04537  7650          SNA CLA
04540  5322          JMP FIND03      /YES - OUTPUT ERROR MESSAGE
04541  7240          CLA CMA
04542  1440          TAD I TEMP      /NO
04543  3440          DCA I TEMP
04544  1440  FINDS9, TAD I TEMP
04545  1356          TAD FIND0
04546  3042          DCA TEMP2
04547  1371          TAD FINDS1
04550  3442          DCA I TEMP2
04551  1356  FINDS5, TAD FIND0       /GET ADDRESS OF LITERAL
04552  7041          CIA
04553  1042          TAD TEMP2
04554  1372          TAD FINDS2
04555  5647          JMP I FINDS     /--RETURN--


             /FIND LITERAL ON PAGE 0

04556  0000  FIND0,  0
04557  3371          DCA FINDS1
04560  1356          TAD FIND0       /RESET EXIT FROM FINDS
04561  3247          DCA FINDS
04562  3372  FIND01, DCA FINDS2      /SET POINTERS
04563  1374          TAD (LITBF2
04564  3356          DCA FIND0
04565  1103          TAD [7760       /ALLOW 160(8) PAGE 0 LITERALS
04566  3004          DCA FORMF6
04567  1156          TAD [200
04570  5263          JMP FIND02

04571  0000  FINDS1, 0
04572  0000  FINDS2, 0
04573  0000  FINDS3, 0

04574  2017
04575  3132
04576  7714
04577  7527

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 67-1

       4600          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 68



             /HANDLER FOR IFZERO PSEUDO-OP

04600  1100  IF0,    TAD [10         /IFTST1, SNA CLA

             /HANDLER FOR IFNZERO PSEUDO-OP

04601  1241  IFN0,   TAD IFSZA       /IFTST1, SZA CLA
04602  3226          DCA IFTST1
04603  4566          JMS I [SPNOR    /IGNORE SPACES
04604  4565          JMS I [EXP      /GET EXPRESSION
04605  1035  IFTST3, TAD CHAR        /GET LAST CHARACTER
04606  1377          TAD (-"<
04607  7650          SNA CLA         /IS IT <?
04610  5216          JMP IFTST2      /YES
04611  4545          JMS I [ERROR    /NO - GENERATE IC ERROR MESSAGE
04612  5143          IC
04613  4574          JMS I [GETC     /GET NEXT CHARACTER
04614  4566  IFTST9, JMS I [SPNOR    /IGNORE SPACES
04615  5205          JMP IFTST3      /TRY AGAIN

04616  4574  IFTST2, JMS I [GETC     /GET NEXT CHARACTER
04617  1051          TAD CONDSW
04620  7041          CIA
04621  3300          DCA CONDTM      /SET NUMBER OF NESTED CONDITIONALS
04622  7240          CLA CMA         /DECREMENT NUMBER OF NESTED CONDITIONALS
04623  1051          TAD CONDSW
04624  3051          DCA CONDSW
04625  1031          TAD VALUE
04626  7402  IFTST1, HLT             /SZA CLA OR SNA CLA
04627  5776          JMP I (MAIN     /--EXIT TO MAIN--
04630  1051  IFTST5, TAD CONDSW      /DONE WITH ALL CONDITIONALS IN NEST?
04631  1300          TAD CONDTM
04632  7700          SMA CLA
04633  5776          JMP I (MAIN     /YES --EXIT TO MAIN--
04634  1035          TAD CHAR
04635  1377          TAD (-"<        /NO - GET NEXT CHARACTER
04636  7450          SNA             /IS IT <?
04637  5244          JMP IFTST6      /YES - HANDLE NEXT CONDITIONAL
04640  1375          TAD ("<-">      /NO - IS IT >?
04641  7640  IFSZA,  SZA CLA
04642  5247          JMP IFTST4      /NO - FINISH THIS CONDITIONAL
04643  7344          CLL CLA CMA RAL /AC=7776
04644  7040  IFTST6, CMA
04645  1051          TAD CONDSW
04646  3051          DCA CONDSW
04647  4574  IFTST4, JMS I [GETC     /GET NEXT CHARACTER
04650  5230          JMP IFTST5

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 69



             /HANDLER FOR IFDEF PSEUDO-OP

04651  1100  IFD,    TAD [10         /IFTST1, SNA CLA

             /HANDLER FOR IFNDEF PSEUDO-OP

04652  1241  IFND,   TAD IFSZA       /IFTST1, SZA CLA
04653  3226          DCA IFTST1
04654  4566          JMS I [SPNOR    /IGNORE SPACES
04655  4543  IFTST7, JMS I [TSTALP   /IS NEXT CHARACTER ALPHABETIC
04656  5267          JMP IFTST8      /YES
04657  4545          JMS I [ERROR    /NO - GENERATE IC ERROR MESSAGE
04660  5143          IC
04661  1035          TAD CHAR        /IS CHARACTER <?
04662  1377          TAD (-"<
04663  7650          SNA CLA
04664  5216          JMP IFTST2      /YES - CONTINUE
04665  4574          JMS I [GETC     /NO - GET NEXT CHARACTER
04666  5255          JMP IFTST7

04667  4542  IFTST8, JMS I [GETTAG   /PICK UP TAG - IS IT IN TABLE?
04670  7240          CLA CMA         /NO
04671  3031          DCA VALUE       /YES
04672  1022          TAD TAG3        /WAS IT A PSEUDO-OP?
04673  7700          SMA CLA
04674  5214          JMP IFTST9      /NO
04675  4545          JMS I [ERROR    /YES - GENERATE IP ERROR MESSAGE
04676  5160          IP
04677  5214          JMP IFTST9

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 70


             CONDTM,

             /PUT TAG IN SYMBOL TABLE

04700  0000  PUTTAG, 0
04701  1055          TAD THISTG
04702  4774          JMS I (SETFLD   /SET FIELD
04703  1020          TAD TAG1
04704  3411          DCA I TAGXR
04705  1021          TAD TAG2
04706  3411          DCA I TAGXR
04707  1022          TAD TAG3
04710  3411          DCA I TAGXR
04711  1032          TAD VALUE2
04712  3411          DCA I TAGXR
04713  6201          CDF
04714  5700          JMP I PUTTAG    /--RETURN--



             /PUSHDOWN ROUTINE
             /PUT NEW ENTRY ON PUSHDOWN STACK

04715  0000  PUSHA,  0
04716  3040          DCA TEMP
04717  7240          CLA CMA
04720  1010          TAD PDLXR
04721  3010          DCA PDLXR
04722  1010          TAD PDLXR
04723  1373          TAD (-PDLND
04724  7710          SPA CLA         /IS LIST TOO FULL?
04725  5772          JMP I (PUSHA1   /BE**FATAL ERROR**
04726  1040          TAD TEMP        /NO - MAKE ENTRY
04727  3410          DCA I PDLXR
04730  7240          CLA CMA
04731  1010          TAD PDLXR
04732  3010          DCA PDLXR
04733  5715          JMP I PUSHA     /--RETURN--

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 71


             /TEST NUMERIC ROUTINE
             /CALL WITH CHARACTER TO TEST IN "CHAR"
             /SKIPS IF THE CHARACTER IS NOT NUMERIC

04734  0000  TSTNUM, 0
04735  1035          TAD CHAR        /GET THE CHARACTER
04736  1107          TAD [-"0
04737  7510          SPA             /SKIPS IF >= 0
04740  5343          JMP TSTNU1      /NOT A NUMBER
04741  1371          TAD ("0-"9
04742  7740          SMA SZA CLA     /SKIPS IF <=9
04743  2334  TSTNU1, ISZ TSTNUM      /2ND EXIT - NOT A NUMBER
04744  7200          CLA
04745  5734          JMP I TSTNUM    /--RETURN--

             /TEST ALPHANUMERIC ROUTINE
             /CALL WITH CHARACTER IN "CHAR"
             /SKIPS IF CHARACTER IS NOT ALPHANUMERIC

04746  0000  TSTALN, 0
04747  4511          JMS I [TSTNUM   /IS IT NUMERIC
04750  5746          JMP I TSTALN    /YES--RETURN--
04751  4543          JMS I [TSTALP   /IS IT ALPHABETIC
04752  5746          JMP I TSTALN    /YES--RETURN--
04753  2346          ISZ TSTALN      /NEITHER
04754  5746          JMP I TSTALN    /--RETURN--

             /TEST ALPHABETIC ROUTINE
             /CALL WITH CHARACTER IN "CHAR"
             /SKIPS IF NOT ALPHABETIC

04755  0000  TSTALP, 0
04756  1035          TAD CHAR
04757  1370          TAD (-"A
04760  7510          SPA             /SKIP IF =>A
04761  5364          JMP TSTAL1      /<A
04762  1367          TAD ("A-"Z
04763  7740          SMA SZA CLA     /SKIP IF <=Z
04764  2355  TSTAL1, ISZ TSTALP      /NO GOOD - 2ND EXIT
04765  7200          CLA
04766  5755          JMP I TSTALP    /--RETURN--

04767  7747
04770  7477
04771  7767
04772  3551
04773  6227
04774  4107
04775  7776
04776  2611
04777  7504
       5000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 72


05000  1177  PUNVA1, TAD [LOOKEX     /FIX PUNONE TO EXIT TO MAIN
05001  3777          DCA I (PUNONE
05002  1137          TAD [211        /OUTPUT TAB
05003  4446          JMS I OERROR
05004  5776          JMP I (DTORG1

             /HANDLER FOR %
             /DIVIDE BY REPEATED SUBTRACTION

05005  3040  OP6,    DCA TEMP
05006  1032          TAD VALUE2
05007  7041          CIA
05010  3032          DCA VALUE2
05011  1031          TAD VALUE
05012  7100  OP6A,   CLL
05013  1032          TAD VALUE2      /SUBTRACT DIVISOR FROM DIVIDEND
05014  7420          SNL             /DONE YET?
05015  5220          JMP OP6B        /YES - EXIT
05016  2040          ISZ TEMP        /NO - COUNT ONE MORE SUBTRACTION
05017  5212          JMP OP6A        /SUBTRACT AGAIN
05020  7200  OP6B,   CLA
05021  1040          TAD TEMP        /RESULT IS # OF SUBTRACTIONS
05022  5775          JMP I (OP0+2

             EJECT7,
             /TELETYPE OUTPUT ROUTINE
             /PRINT 1 CHARACTER

05023  0000  OTYPE1, 0
05024  3235          DCA TTTT
05025  1235          TAD TTTT
05026  4774'         JMS TOUT
05027  1235          TAD TTTT
05030  1140          TAD [-215       /WAS THE CHARACTER A CARRIAGE RETURN?
05031  7640          SZA CLA
05032  5623          JMP I OTYPE1    /NO--RETURN--
05033  1142          TAD [212        /YES--OUTPUT A LINE FEED, TOO
05034  5224          JMP OTYPE1+1

05035  0000  TTTT,   0

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 73



             /HANDLER FOR XLIST PSEUDO-OP

05036  4314  XLISTY, JMS XLISTZ      /ANY EXPRESSION?
05037  5244          JMP XLIST1      /NO
05040  4565          JMS I [EXP      /GET EXPRESSION
05041  1031          TAD VALUE       /USE THE VALUE
05042  3026  XLIST2, DCA XLISTX      /SET SWITCH
05043  5577          JMP I [LOOKEX   /--EXIT TO MAIN--

05044  1026  XLIST1, TAD XLISTX
05045  7650          SNA CLA
05046  7001          IAC             /FLIP IT
05047  5242          JMP XLIST2

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 74




             /HANDLER FOR EJECT PSEUDO-OP

05050  2036  EJECTX, ISZ THISPG
05051  1047          TAD PASS        /IS THIS PASS 3?
05052  7740          SMA SZA CLA
05053  5261          JMP EJECT2      /YES
05054  1035  EJECT1, TAD CHAR        /NO - LOOK FOR NEXT NEGATIVE CHARACTER
05055  7710          SPA CLA
05056  5577          JMP I [LOOKEX   /--EXIT TO MAIN--
05057  4574          JMS I [GETC     /GET NEXT CHARACTER
05060  5254          JMP EJECT1

05061  4314  EJECT2, JMS XLISTZ      /PASS 3 - IS THERE AN EXPRESSION?
05062  5306          JMP EJECT3      /NO - EXIT
05063  4773          JMS I (HEDCLR   /YES - CLEAR HEADING BUFFER
05064  1120          TAD [-40
05065  3223          DCA EJECT7      /SET UP FOR 40 NEW CHARACTERS
05066  1127          TAD [HEADER-1
05067  3012          DCA EJECT8      /SET HEADER BUFFER POINTER
05070  5276          JMP EJECT4

05071  2223  EJECT6, ISZ EJECT7      /FILLED 40 CHARACTERS YET?
05072  5276          JMP EJECT4      /NO - KEEP FILLING
05073  7240          CLA CMA         /YES - SKIP CHARACTERS TO
05074  3223          DCA EJECT7      /END OF LINE
05075  5300          JMP EJECT5

05076  1035  EJECT4, TAD CHAR        /FILL HEADING BUFFER
05077  3412          DCA I EJECT8
05100  7240  EJECT5, CLA CMA
05101  3033          DCA TXTSWT
05102  4574          JMS I [GETC     /GET NEXT CHARACTER
05103  1035          TAD CHAR        /END OF LINE?
05104  7700          SMA CLA
05105  5271          JMP EJECT6      /NO - KEEP FILLING
05106  4533  EJECT3, JMS I [FORMFD   /GENERATE FORM FEED
05107  5577          JMP I [LOOKEX   /--EXIT TO MAIN--

       0012  EJECT8=XREG1            /HEADER BUFFER POINTER

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 75




05110  1047  PUNVAL, TAD PASS        /IS THIS PASS 2?
05111  7750          SPA SNA CLA
05112  5577          JMP I [LOOKEX   /YES--EXIT TO MAIN--
05113  5200          JMP PUNVA1      /NO


             /SEE IF EXPRESSION FOLLOWS XLIST
             /SKIP ON EXPRESSION

05114  0000  XLISTZ, 0
05115  4566          JMS I [SPNOR    /IGNORE TRAILING SPACES
05116  1035          TAD CHAR
05117  1115          TAD [-">        /IS THERE AN EXPRESSION?
05120  7650          SNA CLA
05121  5714          JMP I XLISTZ    /NO--RETURN--
05122  1035          TAD CHAR
05123  7700          SMA CLA
05124  2314          ISZ XLISTZ      /YES - INCREMENT RETURN ADDRESS
05125  5714          JMP I XLISTZ    /--RETURN--


             /DUMMY ERROR ROUTINE
             /TO SUPPRESS CERTAIN ERROR MESSAGES
             /ON PASS 1

05126  0000  PERRO1, 0
05127  2326          ISZ PERRO1      /SKIP ERROR MESSAGE POINTER
05130  5726          JMP I PERRO1    /--RETURN--


             /CONSTANTS FOR DECIMAL PRINT

             DECIMAL
05131  6030  FORMF8, -1000
05132  7634          -100
05133  7766          -10
             OCTAL


             /HANDLER FOR -

05134  1032  OP1,    TAD VALUE2
05135  7041          CIA
05136  5772          JMP I (OP0+1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 76



05137  0000  OUTEM,  0
05140  1473          TAD I SPTR
05141  1371          TAD (-240!200   /IS IT A BLANK?
05142  7650          SNA CLA
05143  5346          JMP .+3
05144  1473          TAD I SPTR
05145  4774'         JMS TOUT
05146  2073          ISZ SPTR
05147  2071          ISZ KNT
05150  5340          JMP OUTEM+1
05151  5737          JMP I OUTEM

05171  7740
05172  3401
05173  1361
05174  7000
05175  3402
05176  1337
05177  1330
       5200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 77



             /**********************************************************
             /CODE UNIQUE TO PASSES 1 AND 2



             /CONTINUATION OF FIXTAB HANDLER

05200  1056  FIXTAY, TAD HIGHTG      /SET POINTERS TO TABLE
05201  7040          CMA
05202  3043          DCA TEMP3
05203  3055          DCA THISTG
05204  4572  FIXTAX, JMS I [FINDTG   /GET A TAG
05205  7350          CLL CLA CMA RAR /AC=3777
05206  0020          AND TAG1
05207  1147          TAD [4000       /SET BIT 0 OF FIRST WORD TO 1
05210  3020          DCA TAG1        /RETURN IT TO TABLE
05211  4544          JMS I [PUTTAG
05212  2055          ISZ THISTG
05213  2043          ISZ TEMP3       /DONE WITH TABLE YET?
05214  5204          JMP FIXTAX      /NO
05215  5577          JMP I [LOOKEX   /YES--EXIT TO MAIN--

             /CONTINUATION OF EXPUNGE HANDLER
             /ENTER ONLY ON PASS 1

05216  3041  EXPUNW, DCA TEMP1
05217  3231          DCA EXPUN2
05220  1056          TAD HIGHTG
05221  7040          CMA
05222  3043          DCA TEMP3
05223  1041  EXPUNY, TAD TEMP1
05224  3055          DCA THISTG
05225  4572          JMS I [FINDTG
05226  1022          TAD TAG3
05227  5630          JMP I EXPUNU

05230  1460  EXPUNU, EXPUNV



/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 78



             EXPUN2,

             /OUTPUT ONE REGISTER - BINARY
             /ENTER WITH CONTENTS IN AC

05231  0000  PUNOUT, 0
05232  3245          DCA PUNOU1
05233  1245          TAD PUNOU1
05234  7012          RTR
05235  7012          RTR
05236  7012          RTR
05237  0176          AND [177
05240  4444          JMS I OCHAR     /OUTPUT FIRST FRAME
05241  1245          TAD PUNOU1
05242  0175          AND [77
05243  4444          JMS I OCHAR     /OUTPUT SECOND FRAME
05244  5631          JMP I PUNOUT    /--RETURN--

05245  0000  PUNOU1, 0


             /START PASS 2

05246  1377  START1, TAD (-11
05247  3071          DCA  KNT                /SIZE OF FILENAME
05250  1376          TAD (SINCH      /ADDRESS OF SINCH
05251  3070          DCA PTR
05252  1375          TAD (BSLOT+1    /ADDRESS OF FILENAME TO CREATE
05253  3074          DCA IPTR
05254  1474  MOTSIN, TAD I IPTR      /GET CHAR
05255  6211          CDF 10
05256  3470          DCA I PTR       /PIT IN SINCH
05257  3774          DCA I (BVERNO   /CLEAR THE VERSION NUMBER
05260  6201          CDF 0
05261  2070          ISZ PTR
05262  2074          ISZ IPTR
05263  2071          ISZ KNT         /DONE?
05264  5254          JMP MOTSIN      /NO..
05265  1373          TAD (BSLOT      /OPEN PASS2 OUTPUT FILE
05266  3074          DCA IPTR        /FUDGE TO USE MOUNT ROUTINE
05267  4772'         JMS INTWT       /WAIT FOR ANY IO
05270  7332          CLA CLL CML RTR
05271  0773'         AND BSLOT       /MOUNT BIT ON?
05272  7640          SZA CLA
05273  4771'         JMS MOUNT       /YES..
05274  1773'         TAD BSLOT
05275  7450          SNA
05276  5342          JMP ONOFIL      /NO PASS 2 OUTPUT FILE
05277  6212          CIF 10
05300  4770          CALL (ENTER     /OPEN THE FILE
05301  5767'         JMP WRTERR
05302  4766'         JMS WRTMSG
05303  7303          BINOP

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 78-1

05304  1773'         TAD BSLOT
05305  4765'         JMS TOUT
05306  4766'         JMS WRTMSG
05307  7041          CRLFR
05310  1773'         TAD BSLOT
05311  3350          DCA BCLOSW
05312  1364          TAD (ISLOTS
05313  3074          DCA IPTR
05314  1474  OOPLP,  TAD I IPTR      /A FILE?
05315  7650          SNA CLA
05316  5334          JMP BPA         /NO.. 
05317  1074          TAD IPTR
05320  4763'         JMS CNAME       /CHECK FOR MATCH IN UNITS
05321  7777          -1;BSLOT
05322  7237
05323  5330          JMP .+5
05324  7352          CLA CLL CMA RTR
05325  0474          AND I IPTR
05326  1362          TAD (2000       /TURN ON MOUNT BIT
05327  3474          DCA I IPTR
05330  1074          TAD IPTR
05331  1361          TAD (12
05332  3074          DCA IPTR
05333  5314          JMP OOPLP
05334  3760' BPA,    DCA OUTINH
05335  1357          TAD (-200
05336  3756'         DCA OUWDCT
05337  1355          TAD (OBUFR
05340  3754'         DCA OUPTR
05341  7410          SKP
05342  2760' ONOFIL, ISZ OUTINH
05343  1145          TAD [ERROR      /RESET PSEUDO-ERROR ROUTINE
05344  3066          DCA PERROR      /TO ALLOW MESSAGES TO BE OUTPUT
05345  3025          DCA PUNCHX      /CLEAR PUNCH INHIBIT
05346  5747          JMP I ST1ST2

05347  4200  ST1ST2, START2
05350  0000  BCLOSW, 0

05354  6661
05355  6000
05356  6663
05357  7600
05360  6647
05361  0012
05362  2000
05363  7107
05364  7200
05365  7000
05366  7014
05367  7100
05370  6404
05371  2513
05372  7006
05373  7237

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 78-2

05374  7427
05375  7240
05376  7403
05377  7767
       5400          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 79




       5400          IBUFR=.


05400  4777' BEGING, JMS WRTMSG
05401  5517          INMSG
05402  1376          TAD (ISLOTS     /POINT TO INPUT FILE LIST
05403  3316          DCA HOLE        /POINTER TO CUURENT SLOT
05404  7346          CLA CLL CMA RTL
05405  3072          DCA CNT         /ALLOW 3 INPUT FILES
05406  3716  GETIN,  DCA I HOLE      /CLEAR FILE FLAGS
05407  1375          TAD ("*
05410  4774'         JMS TOUT
05411  4773'         JMS GETLIN
05412  4772'         JMS SCNLIN
05413  5231          JMP CLIN        /NULL RETURN
05414  5771'         JMP SYNERR      /X: NOTATION
05415  4770'         JMS ADDPAL      /ADD EXTENSION
05416  7410          SKP             /GOOD FILE
05417  5206          JMP GETIN       /SYNTAX ERROR
05420  4777'         JMS WRTMSG
05421  7041          CRLFR
05422  1075          TAD UNIT
05423  3716          DCA I HOLE      /PUT INITIAL UNIT # IN
05424  1316          TAD HOLE
05425  1367          TAD (12
05426  3316          DCA HOLE        /BUMP TO NEXT SLOT
05427  2072          ISZ CNT         /3 FILES YET?
05430  5206          JMP GETIN       /NO
05431  4777' CLIN,   JMS WRTMSG      /YES.. GET BINARY FILE
05432  5535          BINMSG
05433  1366          TAD (BSLOT
05434  3316          DCA HOLE        /POINT TO BINARY SLOT
05435  3716  GETBIN, DCA I HOLE      /INITIALLY CLEAR IT
05436  1375          TAD ("*
05437  4774'         JMS TOUT
05440  4773'         JMS GETLIN
05441  4772'         JMS SCNLIN
05442  5251          JMP CLBIN       /NULL BINARY
05443  4765'         JMS ECOIN       /X: NOTATION
05444  4764'         JMS ADDBIN      /FILE WITHOUT EXTENSION
05445  7410          SKP             /GOOD FILE
05446  5235          JMP GETBIN      /SYNTAX ERROR
05447  1075          TAD UNIT        /STORE INITIAL UNIT FOR BINARY
05450  3716          DCA I HOLE
05451  4777' CLBIN,  JMS WRTMSG
05452  6213          LSTMSG
05453  1363          TAD (LSLOT
05454  3316          DCA HOLE        /POINT TO LISTING FILE
05455  3716          DCA I HOLE      /CLEAR LISTING FLAGS
05456  3762'         DCA ZOTDIG      /SUPRESS 0: FUDGE FOR UNIT
05457  1375  GETLST, TAD ("*
05460  4774'         JMS TOUT

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 79-1

05461  4773'         JMS GETLIN
05462  1361          TAD (LBUFR
05463  4760'         JMS CNAME       /CHECK FOR A (CR)
05464  7777          -1;TTY+3
05465  5706
05466  7410          SKP
05467  5313          JMP CLLIST      /YES.. NO LISTING
05470  1361          TAD (LBUFR
05471  4760'         JMS CNAME       /CHECK FOR TTY
05472  7774          -4;TTY
05473  5703
05474  5300          JMP .+4
05475  7240          CLA CMA
05476  3716          DCA I HOLE      /INDICATE TTY SPECIFIED
05477  5313          JMP CLLIST      /START ASSEMBLY
05500  1361          TAD (LBUFR
05501  4760'         JMS CNAME
05502  7774          -4;LPT          /CHECK FOR LINE PRINTER
05503  5707
05504  5310          JMP .+4
05505  7344          CLA CLL CMA RAL
05506  3716          DCA I HOLE      /INDICATE LINE PRINTER SPECIFIED
05507  5313          JMP CLLIST
05510  4777'         JMS WRTMSG      /GIVE ERROR MESSAGE
05511  7040          ERR
05512  5257          JMP GETLST      /TRY AGAIN
05513  4777' CLLIST, JMS WRTMSG
05514  7041          CRLFR
05515  5757          JMP I (START2-1 /YES VIRGINIA, THERE IS A START
                                     / TO THE ASSEMBLER

05516  0000  HOLE,   0

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 80



05517  0455  INMSG,  "-&177+400; "I; "N; "P; "U; "T; 240&177
05520  0311
05521  0316
05522  0320
05523  0325
05524  0324
05525  0040
05526  0306          "F; "I; "L; "E; "S; 215&177+400; 212&177+4000
05527  0311
05530  0314
05531  0305
05532  0323
05533  0415
05534  4012
05535  0415  BINMSG, 215&177+400; 212&177+400
05536  0412
05537  0255          "-; "B; "I; "N; "A; "R; "Y; 240&177
05540  0302
05541  0311
05542  0316
05543  0301
05544  0322
05545  0331
05546  0040
05547  0306          "F; "I; "L; "E; 215&177+400; 212&177+4000
05550  0311
05551  0314
05552  0305
05553  0415
05554  4012

05557  4177
05560  7107
05561  2073
05562  6023
05563  7251
05564  6075
05565  6115
05566  7237
05567  0012
05570  6105
05571  5674
05572  5600
05573  6000
05574  7000
05575  0252
05576  7200
05577  7014
       5600          PAGE


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 81


       2073          LBUFR=OPTIM1

05600  0000  SCNLIN, 0               /HAS 5 RETURNS!!!
05601  1377          TAD (LBUFR
05602  3070          DCA PTR         /POINT TO INPUT BUFFER
05603  3302          DCA FUDFLG      /ZERO A SKIP FLAG FOR EXIT
05604  1470          TAD I PTR
05605  1376          TAD (-215!200   /A (CR)?
05606  7650          SNA CLA
05607  5600          JMP I SCNLIN    /YES.. R1
05610  2200          ISZ SCNLIN      /BUMP RETURN POINTER
05611  1470          TAD I PTR
05612  3075          DCA UNIT        /MUST BE UNIT AND GOOD DIGIT
05613  2070          ISZ PTR
05614  1470          TAD I PTR
05615  1375          TAD (-":!200    /IS IT A COLON
05616  7640          SZA CLA
05617  5274          JMP SYNERR      /NO.. IT SHOULD HAVE BEEN
05620  2070          ISZ PTR
05621  1470          TAD I PTR
05622  1376          TAD (-215!200   /NEXT CHAR A (CR)?
05623  7650          SNA CLA
05624  5600          JMP I SCNLIN    /YES.. X: RETURN   R2
05625  1774'         TAD HOLE
05626  3073          DCA SPTR        /POINT TO ENTRY TO BLANK IT
05627  1373          TAD (-11        /BLANK 9 CHARS
05630  3071          DCA KNT
05631  2073          ISZ SPTR
05632  1372          TAD (240&177    /PUT BLANK IN
05633  3473          DCA I SPTR
05634  2071          ISZ KNT
05635  5231          JMP .-4         /JUMP BACK TO BUMP SO THAT 1ST CHAR(UNIT)
                                     / IS NOT MESSED UP
05636  1774'         TAD HOLE
05637  7001          IAC
05640  3073          DCA SPTR        /POINT TO NAME PART OF SLOT
05641  4313          JMS LET         /MAKE SURE ITS A LETTER
05642  5274          JMP SYNERR      /NO..
05643  3473          DCA I SPTR      /YES.. ITS IN AC
05644  2070          ISZ PTR
05645  2073          ISZ SPTR
05646  1371          TAD (-5         /NUMBER OF CHARS POSSIBLY REMAING IN NAME
05647  3071          DCA KNT 
05650  4337          JMS GETNAM      /SCAN AND MOVE TILL NEXT LET OR DIG
05651  1774'         TAD HOLE
05652  1370          TAD (7
05653  3073          DCA SPTR        /FORCE POINTING TO EXT FIELD
05654  1470          TAD I PTR
05655  1367          TAD (-".!200    /WAS EXT IMPLIED?
05656  7640          SZA CLA
05657  5266          JMP CRCK        /NO EXT.. MUST BE (CR)
05660  2200          ISZ SCNLIN      /BUMP EXIT POINTER
05661  2302          ISZ FUDFLG      /SAY SCNLIN HAS BEEN BUMPED BUT
                                     / A SYNTAX ERROR STILL MAY OCCUR

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 81-1

05662  2070          ISZ PTR
05663  7346          CLA CLL CMA RTL
05664  3071          DCA KNT         /3 CHAR EXTENSIONS
05665  4337          JMS GETNAM      /GET THEM TO FILE TABLE
05666  1470  CRCK,   TAD I PTR       /AT THIS POINT WE SHOULD HAVE A (CR)
05667  1376          TAD (-215!200   / OR ITS A SYNTAX ERROR
05670  7650          SNA CLA
05671  5300          JMP NORMRT      /WE DO
05672  1302          TAD FUDFLG
05673  7650          SNA CLA
05674  2200  SYNERR, ISZ SCNLIN      /POINT TO R3
05675  2200          ISZ SCNLIN      /POINT TO R4
05676  4766'         JMS WRTMSG
05677  7040          ERR
05700  2200  NORMRT, ISZ SCNLIN      /POINT TO R5 IF SYNTAX
                                     / OR POINT TO R4 IF EXT GIVEN
                                     / OR POINT TO R3 IF NOT GIVEN
05701  5600          JMP I SCNLIN    /RETURN

05702  0000  FUDFLG, 0

05703  0124  TTY,    "T&177; "T&177; "Y&177; 215&177
05704  0124
05705  0131
05706  0015
05707  0114  LPT,    "L&177; "P&177; "T&177; 215&177
05710  0120
05711  0124
05712  0015

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 82


             / CHECK FOR A LETTER ROUTINE
05713  0000  LET,    0               /R1-NOT A LETTER
05714  1470          TAD I PTR       /R2-THE LETTER IN 8 BIT
05715  1365          TAD (-"Z!200-1
05716  7100          CLL
05717  1364          TAD (32
05720  7620          SNL CLA
05721  5713          JMP I LET
05722  1470          TAD I PTR
05723  2313          ISZ LET
05724  5713          JMP I LET


             / CHECK FOR A DIGIT ROUTINE
05725  0000  DIG,    0               /R1-NOT A DIGIT
05726  1470          TAD I PTR       /R2-IS A DIGIT 0-9
05727  1363          TAD (-"0!200
05730  7100          CLL
05731  1362          TAD (-12
05732  7630          SZL CLA
05733  5725          JMP I DIG
05734  1470          TAD I PTR
05735  2325          ISZ DIG
05736  5725          JMP I DIG


             / GETS LETTERS OR DIGITS AND PUTS THEM IN THE INCH AT SPTR
05737  0000  GETNAM, 0
05740  4313          JMS LET
05741  7410          SKP             /CHECK FOR A DIGIT
05742  5345          JMP STCHAR
05743  4325          JMS DIG
05744  5737          JMP I GETNAM
05745  3473  STCHAR, DCA I SPTR
05746  2073          ISZ SPTR
05747  2070          ISZ PTR
05750  2071          ISZ KNT
05751  5340          JMP GETNAM+1
05752  5737          JMP I GETNAM

05762  7766
05763  7720
05764  0032
05765  7645
05766  7014
05767  7722
05770  0007
05771  7773
05772  0040
05773  7767
05774  5516
05775  7706
05776  7763
05777  2073

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 82-1

       6000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 83


       6000          OBUFR=.

             / GETS AN INPUT LINE FROM THE TTY
06000  0000  GETLIN, 0               /R-GETS A LINE OF TEXT ENDED
06001  1377          TAD (LBUFR      /-WITH A (CR)
06002  3070          DCA PTR
06003  4776' GLINE,  JMS KIN
06004  3470          DCA I PTR
06005  1470          TAD I PTR
06006  1375          TAD (-377!200   /A (RO)?
06007  7450          SNA             /NO..
06010  5242          JMP ROR
06011  1374          TAD (377-215    /A (CR)?
06012  7450          SNA             /NO..
06013  5600          JMP I GETLIN    /YES.. RETURN
06014  1373          TAD (215-225    /A (^U)?
06015  7650          SNA CLA         /NO..
06016  5237          JMP ZOTLIN
06017  1070          TAD PTR
06020  7041          CIA
06021  1377          TAD (LBUFR
06022  7650          SNA CLA
06023  5255  ZOTDIG, JMP ZCOL
06024  1470  CHRIN,  TAD I PTR
06025  4772'         JMS TOUT
06026  2070          ISZ PTR
06027  1070          TAD PTR
06030  7041          CIA
06031  1377          TAD (LBUFR
06032  1371          TAD (240&177
06033  7700          SMA CLA
06034  5203          JMP GLINE
06035  1370          TAD ("?
06036  4772'         JMS TOUT
06037  4767' ZOTLIN, JMS WRTMSG
06040  6210          CRLFA
06041  5201          JMP GETLIN+1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 84




             / THE RUBOUT HANDLER
06042  7240  ROR,    CMA CLA
06043  1070          TAD PTR
06044  3070          DCA PTR
06045  1377          TAD (LBUFR
06046  7041          CIA
06047  1070          TAD PTR
06050  7710          SPA CLA
06051  5237          JMP ZOTLIN
06052  1470          TAD I PTR
06053  4772'         JMS TOUT
06054  5203          JMP GLINE


             / THE 0: FUDGE
06055  4766' ZCOL,   JMS DIG
06056  7410          SKP
06057  5225          JMP CHRIN+1
06060  1365          TAD ("0&177
06061  3470          DCA I PTR
06062  2070          ISZ PTR
06063  1365          TAD ("0&177
06064  4772'         JMS TOUT
06065  1364          TAD (":&177
06066  3470          DCA I PTR
06067  2070          ISZ PTR
06070  1364          TAD (":&177
06071  4772'         JMS TOUT
06072  1763          TAD I (KBDIN
06073  3470          DCA I PTR
06074  5224          JMP CHRIN

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 85




06075  0000  ADDBIN, 0
06076  4767'         JMS WRTMSG
06077  6200          BINDOT
06100  1362          TAD (BINDOT+1
06101  3070          DCA PTR
06102  7346          CLA CLL CMA RTL
06103  4333          JMS MFNME
06104  5675          JMP I ADDBIN
06105  0000  ADDPAL, 0
06106  4767'         JMS WRTMSG
06107  6204          PALDOT
06110  1361          TAD (PALDOT+1
06111  3070          DCA PTR
06112  7346          CLA CLL CMA RTL
06113  4333          JMS MFNME
06114  5705          JMP I ADDPAL
06115  0000  ECOIN,  0
06116  1360          TAD (-6
06117  3071          DCA KNT
06120  1357          TAD (ISLOTS+1
06121  3073          DCA SPTR
06122  4756'         JMS OUTEM
06123  1357          TAD (ISLOTS+1
06124  3070          DCA PTR
06125  1755'         TAD HOLE
06126  7001          IAC
06127  3073          DCA SPTR
06130  1360          TAD (-6
06131  4333          JMS MFNME
06132  5715          JMP I ECOIN
06133  0000  MFNME,  0
06134  3071          DCA KNT
06135  1470          TAD I PTR
06136  0354          AND (177
06137  3473          DCA I SPTR
06140  2070          ISZ PTR
06141  2073          ISZ SPTR
06142  2071          ISZ KNT
06143  5335          JMP MFNME+2
06144  5733          JMP I MFNME

06154  0177
06155  5516
06156  5137
06157  7201
06160  7772
06161  6205
06162  6201
06163  7602
06164  0072
06165  0060
06166  5725

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 85-1

06167  7014
06170  0277
06171  0040
06172  7000
06173  7770
06174  0162
06175  7601
06176  7003
06177  2073
       6200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 86


06200  0056  BINDOT, ".&177; "B; "I; "N+4000
06201  0302
06202  0311
06203  4316
06204  0056  PALDOT, ".&177; "P; "A; "L+4000
06205  0320
06206  0301
06207  4314

06210  0415  CRLFA,  215&177+400; 212&177+400; "*&177+400+4000
06211  0412
06212  4452
06213  0415  LSTMSG, 215&177+400; 212&177+400
06214  0412
06215  0255          "-; "L; "I; "S; "T; 240; "T; "O
06216  0314
06217  0311
06220  0323
06221  0324
06222  0240
06223  0324
06224  0317
06225  0415          215&177+400; 212&177+4000
06226  4012

       6400          PAGE

             /END OF ONCE ONLY CODE
             /**********************************************************

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 87




06400  0000  IOPEN,  0
06401  1047          TAD PASS        /IS THIS PASS 3?
06402  7750          SPA SNA CLA
06403  5212          JMP NXTFLE      /NO
06404  4777          JMS I (HEDCLR   /YES - CLEAR HEADING BUFFER
06405  1120          TAD [-40
06406  3776          DCA I (LSTCH6
06407  1127          TAD [HEADER-1
06410  3775          DCA I (LSTCH7
06411  3062          DCA LSTCNT
06412  4774' NXTFLE, JMS INTWT       /PURGE ALL ACTIVE IO
06413  1373          TAD (12
06414  1074          TAD IPTR
06415  3074          DCA IPTR
06416  7332          CLA CLL CML RTR
06417  0474          AND I IPTR      /IS MOUNT BIT ON?
06420  7640          SZA CLA
06421  4772' MNTIT,  JMS MOUNT       /ISSUE MOUNT MESSAGE FOR FILE
06422  7201          CLA IAC
06423  1074          TAD IPTR
06424  3235          DCA LSPOT       /POINTER TO FILE NAME
06425  1474          TAD I IPTR
06426  7510          SPA             /WAS BACK SPACE BIT ON?
                     
06427  5264          JMP BCKVER      /YES... TRY TO QUICK ACCESS IT
06430  7450          SNA
06431  5771'         JMP PHASE       /NO MORE INPUT AND NO $ SIGN
06432  6212          CIF 10
06433  4770          CALL (LOOKUP    /SEARCH CASSETTE FOR FILE
06434  6201          CDF 0
06435  7402  LSPOT,  HLT
06436  5767'         JMP INERRX      /HARD ERROR DURING LOOKUP
06437  5221          JMP MNTIT       /DIDN'T FIND ON THIS CASSETTE-MOUNT A NEW ONE
06440  7350  CEXIT,  CLA CLL CMA RAR
06441  0474          AND I IPTR
06442  1366          TAD (4000
06443  3474          DCA I IPTR
06444  1074          TAD IPTR
06445  4765'         JMS CNAME
06446  7777          -1;BSLOT
06447  7237
06450  5255          JMP .+5
06451  7352          CLA CLL CMA RTR
06452  0764'         AND BSLOT
06453  1363          TAD (2000
06454  3764'         DCA BSLOT
06455  3762'         DCA INEOF
06456  7240          CLA CMA
06457  3761'         DCA INCHCT
06460  1360          TAD (IBUFR
06461  3757'         DCA INBUFP
06462  4756'         JMS READ

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 87-1

06463  5600          JMP I IOPEN

06464  6212  BCKVER, CIF 10
06465  4755          CALL (UTIL      /BACKSPACE FILE
06466  0030          30
06467  5221          JMP MNTIT       /ERROR BUT TRY ANOTHER WAY
06470  1354          TAD (MNTIT
06471  3753'         DCA ERET
06472  1352          TAD (HDSIZE     /SET UP TO READ A HEADER
06473  6213          CDF CIF 10
06474  3751          DCA I (BSIZE
06475  6201          CDF 0
06476  4750          CALL (HANDLER   /READ HEADER
06477  0000          0               /READ INTO FIELD 0
06500  5400          IBUFR
06501  5221          JMP MNTIT
06502  4774'         JMS INTWT       /MAKE SURE IN CORE BEFORE WE USE IT
06503  1347          TAD (BLSIZE     /RESTORE CORRECT BLOCKSIZE
06504  6211          CDF 10
06505  3751          DCA I (BSIZE
06506  6201          CDF 0
06507  1235          TAD LSPOT
06510  4765'         JMS CNAME
06511  7767          -11;IBUFR
06512  5400
06513  7410          SKP
06514  5240          JMP CEXIT
06515  7350          CLA CLL CMA RAR /TURN OFF BACKSPACE BIT
06516  0474          AND I IPTR
06517  3474          DCA I IPTR
06520  5222          JMP MNTIT+1

06521  0415  BINCLO, 215&177+400; 212; "B; "I; "N; "A; "R; "Y; 240
06522  0212
06523  0302
06524  0311
06525  0316
06526  0301
06527  0322
06530  0331
06531  0240
06532  0306          "F; "I; "L; "E; 240; "C; "L; "O; "S; "E; "D; 215+400; 212+4000
06533  0311
06534  0314
06535  0305
06536  0240
06537  0303
06540  0314
06541  0317
06542  0323
06543  0305
06544  0304
06545  0615
06546  4212


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 87-2

06547  0200
06550  6600
06551  7000
06552  0040
06553  7013
06554  6421
06555  7200
06556  7043
06557  7056
06560  5400
06561  7300
06562  7302
06563  2000
06564  7237
06565  7107
06566  4000
06567  7061
06570  7002
06571  0752
06572  2513
06573  0012
06574  7006
06575  3531
06576  3530
06577  1361
       6600          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 88




             /OUTPUT A CHARACTER TO OUTPUT DEVICE
             /CALLED BY JMS I OCHAR
             /WITH CHARACTER IN 8-BIT ASCII IN AC

06600  0025  OUTPT1, PUNCHX          /PASS 2=PUNCHX; 3=XLISTX

06601  0000  OUTPUT, 0
06602  0116          AND [377        /MASK OUT LEFT 4 BITS
06603  3262          DCA OUTPT2      /STORE
06604  1600          TAD I OUTPT1    /IS THIS PASS 3 AND
06605  7450          SNA
06606  1247          TAD OUTINH      /IS THIS COVERED BY XLIST?
06607  7640          SZA CLA
06610  5601          JMP I OUTPUT    /YES--RETURN--
06611  1262          TAD OUTPT2      /NO - GET CHARACTER
06612  1377          TAD (-211       /IS IT A TAB?
06613  7650          SNA CLA
06614  5225          JMP OUTPT3      /YES - OUTPUT SPACES
06615  4235          JMS OUTPUX      /NO - OUTPUT CHARACTER
06616  1262          TAD OUTPT2      /IS IT LINE FEED?
06617  1376          TAD (-212
06620  7640          SZA CLA
06621  5601          JMP I OUTPUT    /NO--RETURN--
06622  1110          TAD [7773       /YES - RESET LSTCNT
06623  3062          DCA LSTCNT
06624  5601          JMP I OUTPUT    /--RETURN--


             /OUTPUT SPACES INSTEAD OF TAB

06625  1135  OUTPT3, TAD [240
06626  3262          DCA OUTPT2
06627  4235          JMS OUTPUX      /OUTPUT SPACE
06630  1062          TAD LSTCNT      /TAB STOPS ARE EVERY 8 SPACES
06631  0122          AND [7
06632  7640          SZA CLA
06633  5227          JMP .-4
06634  5601          JMP I OUTPUT    /--RETURN--

             /OUTPUT THE CHARACTER
06635  0000  OUTPUX, 0
06636  1262          TAD OUTPT2
06637  3661          DCA I OUPTR
06640  2261          ISZ OUPTR
06641  2263          ISZ OUWDCT
06642  7410          SKP
06643  4264          JMS OUWRT       /BUFFER IS FULL, DUMP IT
06644  1262          TAD OUTPT2
06645  4775          JMS I (TEXT1    /PRINT IT IF PRINTABLE
06646  2062          ISZ LSTCNT
06647  0000  OUTINH, 0               /WILL ALWAYS BE ZERO OR 1
06650  5635          JMP I OUTPUX

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 88-1


06651  1262  P3O,    TAD OUTPT2
06652  4775          JMS I (TEXT1
06653  2062          ISZ LSTCNT
06654  7000          NOP
06655  1262          TAD OUTPT2
06656  4774  P3OF,   JMS I (LPOCHR
06657  5635          JMP I OUTPUX
06660  7000  P3OT,   TOUT

06661  0000  OUPTR,  0
06662  0000  OUTPT2, 0
06663  0000  OUWDCT, 0

06664  0000  OUWRT,  0
06665  4773'         JMS INTWT
06666  1372          TAD (WRTERR     /IF ERROR OCCURS ITS ALWAYS FATAL
06667  3771'         DCA ERET
06670  1770'         TAD BSLOT       /OUTPUT UNIT
06671  6212          CIF 10
06672  4767          CALL (HANDLER
06673  4000          4000
06674  6000  OUBPTR, OBUFR
06675  5772'         JMP WRTERR
06676  1366          TAD (-200
06677  3263          DCA OUWDCT      /RESET WORD COUNT
06700  1274          TAD OUBPTR
06701  7041          CIA
06702  1365          TAD (OBUFR+OBUFR+200
06703  3261          DCA OUPTR       /RESET OUTPUT POINTER
06704  1261          TAD OUPTR
06705  3274          DCA OUBPTR
06706  5664          JMP I OUWRT     /RETURN

06707  0000  OCLOSE, 0
06710  1247          TAD OUTINH
06711  7640          SZA CLA
06712  5707          JMP I OCLOSE    /NO OUTPUT
06713  1156          TAD [200        /SEND A ^Z FOR END OF FILE
06714  4444          JMS I OCHAR
06715  1263          TAD OUWDCT      /CHECK IF THE ^Z CAUSED A WRITE
06716  1364          TAD (200
06717  7640          SZA CLA
06720  4264          JMS OUWRT       /IT DIDN'T, WE HAVE TO WRITE THE BUFFER
06721  1363          TAD (ERET-1
06722  3771'         DCA ERET
06723  1770'         TAD BSLOT
06724  6212          CIF 10
06725  4762          CALL (CLOSE     /CLOSE THE FILE
06726  5772'         JMP WRTERR      /CLOSE FAILED
06727  4761'         JMS WRTMSG
06730  6521          BINCLO
06731  3760'         DCA BCLOSW
06732  5707          JMP I OCLOSE


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 88-2

06760  5350
06761  7014
06762  6400
06763  7012
06764  0200
06765  4200
06766  7600
06767  6600
06770  7237
06771  7013
06772  7100
06773  7006
06774  7400
06775  2440
06776  7566
06777  7567
       7000          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 89



07000  0000  TOUT,   0
07001  4777          JMS I (TTOCHR
07002  5600          JMP I TOUT

07003  0000  KIN,    0               /GET A CHAR FROM TTY
07004  4776          JMS I (KBDCHR
07005  5603          JMP I KIN

07006  0000  INTWT,  0               /I-O WAIT ROUTINE
07007  6212          CIF 10
07010  4775          CALL (WAIT
07011  5613  LPLPLP, JMP I ERET      /ERROR ON PREVIOUS OPERATION
07012  5606          JMP I INTWT     /NO ERROR.. CONTINUE

07013  7011  ERET,   LPLPLP          /INITIALLY POINT TO TIGHT LOOP

             / WRITE OUT THE GIVEN MESSAGE
07014  0000  WRTMSG, 0               /R-TYPES THE GIVEN MSG
07015  1614          TAD I WRTMSG    /THE ADDRESS OF THE MSG
07016  3230          DCA WPTR
07017  2214          ISZ WRTMSG
07020  1630  TNXT,   TAD I WPTR
07021  0374          AND (777
07022  4200          JMS TOUT
07023  1630          TAD I WPTR
07024  7710          SPA CLA         /NEG CHAR INDICATES END
07025  5614          JMP I WRTMSG
07026  2230          ISZ WPTR
07027  5220          JMP TNXT
07030  0000  WPTR,   0

07031  0455  MOUNTM, "-&177+400; "M; "O; "U; "N; "T; 240&177+4000
07032  0315
07033  0317
07034  0325
07035  0316
07036  0324
07037  4040
07040  0477  ERR,    "?&177+400
07041  0415  CRLFR,  215&177+400; 212&177+400+4000
07042  4412

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 90



07043  0000  READ,   0
07044  4206          JMS INTWT
07045  1773'         TAD INEOF       /CHECK TO SEE IF ALREADY AT END
07046  7640          SZA CLA         / OF FILE
07047  5643          JMP I READ
07050  1372          TAD (INERRX
07051  3213          DCA ERET
07052  6212          CIF 10
07053  1474          TAD I IPTR
07054  4771          CALL (HANDLER
07055  0000          0
07056  5400  INBUFP, IBUFR
07057  5276          JMP RDERR
07060  5643          JMP I READ
07061  0370  INERRX, AND (20
07062  7650          SNA CLA
07063  5276          JMP RDERR
07064  2773'         ISZ INEOF       /SIGNAL NO MORE INPUT FROM THIS FILE
07065  5606          JMP I INTWT     /THIS WASN'T A REAL ERROR
                                     /CONTINUE LAST OPERATION...

07066  0000  IINIT,  0
07067  1367          TAD (ISLOTS-12
07070  3074          DCA IPTR
07071  2766'         ISZ FORMSW      /PAL8 DID SO I WILL...
07072  1167          TAD [LINBUF+120
07073  3034          DCA TXTPTR
07074  4765'         JMS IOPEN
07075  5666          JMP I IINIT

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 91


07076  7300  RDERR,  CLA CLL
07077  5303          JMP DERR

07100  0364  WRTERR, AND (40
07101  7640          SZA CLA
07102  5305          JMP .+3
07103  1363  DERR,   TAD (DE
07104  5502          JMP I [MONERR
07105  1362          TAD (DF
07106  5304          JMP .-2



07107  0000  CNAME,  0
07110  3333          DCA PTR1
07111  1707          TAD I CNAME
07112  3071          DCA KNT
07113  2307          ISZ CNAME
07114  1707          TAD I CNAME
07115  3334          DCA PTR2
07116  2307          ISZ CNAME
07117  1733  CNM2,   TAD I PTR1
07120  7041          CIA
07121  1734          TAD I PTR2
07122  0361          AND (177
07123  7640          SZA CLA
07124  5707          JMP I CNAME
07125  2333          ISZ PTR1
07126  2334          ISZ PTR2
07127  2071          ISZ KNT
07130  5317          JMP CNM2
07131  2307          ISZ CNAME
07132  5707          JMP I CNAME

07133  0000  PTR1,   0
07134  0000  PTR2,   0

07161  0177
07162  4446
07163  4445
07164  0040
07165  6400
07166  3550
07167  7166
07170  0020
07171  6600
07172  7061
07173  7302
07174  0777
07175  6200
07176  7626
07177  7402
       7200          PAGE

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 92




07200  0000  ISLOTS, ZBLOCK  37      /THE EXTRA WORD OF ZERO AT THE END OF
                                     / THE TABLE SAVES THE TROUBLE OF 
                                     / KEEPING A COUNT
07237  0000  BSLOT,  ZBLOCK  12
07251  0000  LSLOT,  ZBLOCK  2

07253  0000  INPUT,  0
07254  2300          ISZ INCHCT
07255  5272          JMP GETCHR
07256  1302          TAD INEOF
07257  7640          SZA CLA
07260  4777' GETFLE, JMS IOPEN       /START NEW FILE
07261  1776' GETBUF, TAD INBUFP
07262  3301          DCA INPTR
07263  1776'         TAD INBUFP
07264  7041          CIA
07265  1375          TAD (IBUFR+IBUFR+200
07266  3776'         DCA INBUFP
07267  4774'         JMS READ        /THERE WERE NO MORE CHARS IN THE INPUT
                                     / BUFFER, SO WE COME HERE TO READ ANOTHER
07270  1154          TAD [-200
07271  3300          DCA INCHCT      /NUMBER OF CHARS IN 1 BUFFER LOAD
07272  1701  GETCHR, TAD I INPTR
07273  2301          ISZ INPTR       /LEAVING THIS OUT WAS SOME BUG!!!!
07274  0176          AND [177        /CONVERT TO 7 BIT
07275  7450          SNA
07276  5254          JMP INPUT+1     /IT WAS NULL- SKIP IT
07277  5773          JMP I (LSTCH9

07300  0000  INCHCT, 0
07301  0000  INPTR,  0
07302  0000  INEOF,  0

07303  0415  BINOP,  215&177+400; 212; "B; "I; "N; "A; "R; "Y; 240
07304  0212
07305  0302
07306  0311
07307  0316
07310  0301
07311  0322
07312  0331
07313  0240
07314  0306          "F; "I; "L; "E; 240; "O; "N; 240; "U; "N; "I; "T; 240&177+4000
07315  0311
07316  0314
07317  0305
07320  0240
07321  0317
07322  0316
07323  0240
07324  0325
07325  0316

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 92-1

07326  0311
07327  0324
07330  4040

07331  0415  UPC,    215&177+400; 212; "^; "C+4000
07332  0212
07333  0336
07334  4303

                     IFNZRO .&7600-7200  <MONITOR OVERFLOW>

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 93



             /**********************************************************
             /PAGE 0 LITERALS AND POINTERS
             /**********************************************************
07373  3465
07374  7043
07375  3200
07376  7056
07377  6400
00100  0010
00101  2200
00102  0753
00103  7760
00104  2235
00105  0400
00106  0700
00107  7520
00110  7773
00111  4734
00112  7522
00113  7776
00114  7525
00115  7502
00116  0377
00117  1776
00120  7740
00121  5231
00122  0007
00123  3744
00124  7711
00125  0260
00126  0040
00127  1455
00130  0255
00131  7774
00132  0215
00133  1031
00134  3362
00135  0240
00136  1613
00137  0211
00140  7563
00141  1614
00142  0212
00143  4755
00144  4700
00145  3600
00146  4715
00147  4000
00150  5110
00151  1736
00152  0761
00153  2502
00154  7600

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 93-1

00155  0600
00156  0200
00157  3646
00160  7700
00161  3725
00162  3664
00163  1330
00164  1400
00165  3000
00166  0353
00167  1734
00170  7540
00171  1777
00172  4132
00173  4746
00174  0605
00175  0077
00176  0177
00177  2631
       0001          FIELD 1

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 94




             /**********************************************************
             /SYMBOL TABLE
             /MUST REMAIN IN ALPHABETICAL ORDER
             /**********************************************************

       5160          *5160

15160  5777  SYMS,   5777                    /TERMINATOR
15161  3777          3777                    /IMPOSSIBLE (LIMITING) SYMBOL
15162  5777          5777
15163  0000          0000

15164  5704          "Z-300^45+"B-300+4000   /ZBLOCK
15165  0713          "L-300^45+"O-300
15166  4172          "C-300^45+"K-300+4000
15167  0400          ZBLOCX

15170  7702          "Z-300^45+4000+2000     /Z
15171  0000          0
15172  0000          0
15173  0000          0000

15174  5604          "X-300^45+"L-300+4000   /XLIST
15175  0540          "I-300^45+"S-300
15176  5344          "T-300^45+4000
15177  5036          XLISTY

15200  5367          "T-300^45+"S-300+4000   /TSK
15201  0627          "K-300^45
15202  0000          0
15203  6045          6045

15204  5367          "T-300^45+"S-300+4000   /TSF
15205  0336          "F-300^45
15206  0000          0
15207  6041          TSF

15210  5364          "T-300^45+"P-300+4000   /TPC
15211  0157          "C-300^45
15212  0000          0
15213  6044          TPC

15214  5360          "T-300^45+"L-300+4000   /TLS
15215  1277          "S-300^45
15216  0000          0
15217  6046          TLS

15220  5352          "T-300^45+"F-300+4000   /TFL
15221  0674          "L-300^45
15222  0000          0
15223  6040          6040


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 95



15224  5351          "T-300^45+"E-300+4000   /TEXT
15225  1614          "X-300^45+"T-300
15226  4000          4000
15227  2400          TEXTX

15230  5347          "T-300^45+"C-300+4000   /TCF
15231  0336          "F-300^45
15232  0000          0
15233  6042          TCF

15234  5345          "T-300^45+"A-300+4000   /TAD
15235  4224          "D-300^45+4000
15236  0000          0
15237  1000          TAD 0

15240  5331          "S-300^45+"Z-300+4000   /SZL
15241  0674          "L-300^45
15242  0000          0
15243  7430          SZL

15244  5331          "S-300^45+"Z-300+4000   /SZA
15245  0045          "A-300^45
15246  0000          0
15247  7440          SZA

15250  5326          "S-300^45+"W-300+4000   /SWP
15251  1120          "P-300^45
15252  0000          0
15253  7521          7521

15254  5323          "S-300^45+"T-300+4000   /STL
15255  0674          "L-300^45
15256  0000          0
15257  7120          STL

15260  5323          "S-300^45+"T-300+4000   /STA
15261  0045          "A-300^45
15262  0000          0
15263  7240          STA

15264  5321          "S-300^45+"R-300+4000   /SRQ
15265  1165          "Q-300^45
15266  0000          0
15267  6003          6003

15270  5317          "S-300^45+"P-300+4000   /SPA
15271  0045          "A-300^45
15272  0000          0
15273  7510          SPA


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 96



15274  5315          "S-300^45+"N-300+4000   /SNL
15275  0674          "L-300^45
15276  0000          0
15277  7420          SNL

15300  5315          "S-300^45+"N-300+4000   /SNA
15301  0045          "A-300^45
15302  0000          0
15303  7450          SNA

15304  5314          "S-300^45+"M-300+4000   /SMA
15305  0045          "A-300^45
15306  0000          0
15307  7500          SMA

15310  5312          "S-300^45+"K-300+4000   /SKP
15311  1120          "P-300^45
15312  0000          0
15313  7410          SKP

15314  5312          "S-300^45+"K-300+4000   /SKON
15315  1071          "O-300^45+"N-300
15316  0000          0
15317  6000          6000

15320  5306          "S-300^45+"G-300+4000   /SGT
15321  1344          "T-300^45
15322  0000          0
15323  6006          6006

15324  5256          "R-300^45+"T-300+4000   /RTR
15325  1232          "R-300^45
15326  0000          0
15327  7012          RTR

15330  5256          "R-300^45+"T-300+4000   /RTL
15331  0674          "L-300^45
15332  0000          0
15333  7006          RTL

15334  5256          "R-300^45+"T-300+4000   /RTF
15335  0336          "F-300^45
15336  0000          0
15337  6005          6005

15340  5247          "R-300^45+"M-300+4000   /RMF
15341  0336          "F-300^45
15342  0000          0
15343  6244          RMF


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 97



15344  5243          "R-300^45+"I-300+4000   /RIF
15345  0336          "F-300^45
15346  0000          0
15347  6224          RIF

15350  5243          "R-300^45+"I-300+4000   /RIB
15351  0112          "B-300^45
15352  0000          0
15353  6234          RIB

15354  5236          "R-300^45+"D-300+4000   /RDF
15355  0336          "F-300^45
15356  0000          0
15357  6214          RDF

15360  5233          "R-300^45+"A-300+4000   /RAR
15361  1232          "R-300^45
15362  0000          0
15363  7010          RAR

15364  5233          "R-300^45+"A-300+4000   /RAL
15365  0674          "L-300^45
15366  0000          0
15367  7004          RAL

15370  5121          "P-300^45+"A-300+4000   /PAUSE
15371  1434          "U-300^45+"S-300
15372  4271          "E-300^45+4000
15373  0362          PAUSEX

15374  5121          "P-300^45+"A-300+4000   /PAGE
15375  0410          "G-300^45+"E-300
15376  4000          4000
15377  0441          PAGEX

15400  5076          "O-300^45+"S-300+4000   /OSR
15401  1232          "R-300^45
15402  0000          0
15403  7404          OSR

15404  5056          "O-300^45+"C-300+4000   /OCTAL
15405  1345          "T-300^45+"A-300
15406  4674          "L-300^45+4000
15407  0210          OCTALX

15410  5025          "N-300^45+"O-300+4000   /NOPUNCH
15411  1145          "P-300^45+"U-300
15412  5011          "N-300^45+"C-300+4000
15413  0204          NOPUNX


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 98



15414  5025          "N-300^45+"O-300+4000   /NOP
15415  1120          "P-300^45
15416  0000          0
15417  7000          NOP

15420  4762          "M-300^45+"Q-300+4000   /MQL
15421  0674          "L-300^45
15422  0000          0
15423  7421          7421

15424  4762          "M-300^45+"Q-300+4000   /MQA
15425  0045          "A-300^45
15426  0000          0
15427  7501          7501

15430  4717          "L-300^45+"S-300+4000   /LSF
15431  0336          "F-300^45
15432  0000          0
15433  6661          6661

15434  4717          "L-300^45+"S-300+4000   /LSE
15435  0271          "E-300^45
15436  0000          0
15437  6663          6663

15440  4714          "L-300^45+"P-300+4000   /LPC
15441  0157          "C-300^45
15442  0000          0
15443  6664          6664

15444  4710          "L-300^45+"L-300+4000   /LLS
15445  1277          "S-300^45
15446  0000          0
15447  6666          6666

15450  4705          "L-300^45+"I-300+4000   /LIF
15451  0336          "F-300^45
15452  0000          0
15453  6667          6667

15454  4705          "L-300^45+"I-300+4000   /LIE
15455  0271          "E-300^45
15456  0000          0
15457  6665          6665

15460  4677          "L-300^45+"C-300+4000   /LCF
15461  0336          "F-300^45
15462  0000          0
15463  6662          6662


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 99



15464  4675          "L-300^45+"A-300+4000   /LAS
15465  1277          "S-300^45
15466  0000          0
15467  7604          LAS

15470  4652          "K-300^45+"S-300+4000   /KSF
15471  0336          "F-300^45
15472  0000          0
15473  6031          KSF

15474  4652          "K-300^45+"S-300+4000   /KSEN
15475  0307          "E-300^45+"N-300
15476  0000          0
15477  6702          6702

15500  4652          "K-300^45+"S-300+4000   /KSDR
15501  0246          "D-300^45+"R-300
15502  0000          0
15503  6701          6701

15504  4652          "K-300^45+"S-300+4000   /KSBF
15505  0120          "B-300^45+"F-300
15506  0000          0
15507  6703          6703

15510  4652          "K-300^45+"S-300+4000   /KSAF
15511  0053          "A-300^45+"F-300
15512  0000          0
15513  6705          6705

15514  4651          "K-300^45+"R-300+4000   /KRSB
15515  1301          "S-300^45+"B-300
15516  0000          0
15517  6707          6707

15520  4651          "K-300^45+"R-300+4000   /KRS
15521  1277          "S-300^45
15522  0000          0
15523  6034          KRS

15524  4651          "K-300^45+"R-300+4000   /KRB
15525  0112          "B-300^45
15526  0000          0
15527  6036          KRB

15530  4643          "K-300^45+"L-300+4000   /KLSA
15531  1300          "S-300^45+"A-300
15532  0000          0
15533  6704          6704


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 100



15534  4640          "K-300^45+"I-300+4000   /KIE
15535  0271          "E-300^45
15536  0000          0
15537  6035          6035

15540  4636          "K-300^45+"G-300+4000   /KGOA
15541  1054          "O-300^45+"A-300
15542  0000          0
15543  6706          6706

15544  4632          "K-300^45+"C-300+4000   /KCLR
15545  0716          "L-300^45+"R-300
15546  0000          0
15547  6700          6700

15550  4632          "K-300^45+"C-300+4000   /KCF
15551  0336          "F-300^45
15552  0000          0
15553  6030          6030

15554  4632          "K-300^45+"C-300+4000   /KCC
15555  0157          "C-300^45
15556  0000          0
15557  6032          KCC

15560  4577          "J-300^45+"M-300+4000   /JMS
15561  5277          "S-300^45+4000
15562  0000          0
15563  4000          JMS 0

15564  4577          "J-300^45+"M-300+4000   /JMP
15565  5120          "P-300^45+4000
15566  0000          0
15567  5000          JMP 0

15570  4540          "I-300^45+"S-300+4000   /ISZ
15571  5702          "Z-300^45+4000
15572  0000          0
15573  2000          ISZ 0

15574  4534          "I-300^45+"O-300+4000   /ION
15575  1006          "N-300^45
15576  0000          0
15577  6001          ION

15600  4534          "I-300^45+"O-300+4000   /IOF
15601  0336          "F-300^45
15602  0000          0
15603  6002          IOF


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 101



15604  4523          "I-300^45+"F-300+4000   /IFZERO
15605  1707          "Z-300^45+"E-300
15606  5251          "R-300^45+"O-300+4000
15607  4600          IF0

15610  4523          "I-300^45+"F-300+4000   /IFNZRO
15611  1040          "N-300^45+"Z-300
15612  5251          "R-300^45+"O-300+4000
15613  4601          IFN0

15614  4523          "I-300^45+"F-300+4000   /IFNDEF
15615  1012          "N-300^45+"D-300
15616  4277          "E-300^45+"F-300+4000
15617  4652          IFND

15620  4523          "I-300^45+"F-300+4000   /IFDEF
15621  0231          "D-300^45+"E-300
15622  4336          "F-300^45+4000
15623  4651          IFD

15624  4516          "I-300^45+"A-300+4000   /IAC
15625  0157          "C-300^45
15626  0000          0
15627  7001          IAC

15630  6515          "I-300^45+4000+2000     /I
15631  0000          0
15632  0000          0
15633  0400          0400

15634  4464          "H-300^45+"L-300+4000   /HLT
15635  1344          "T-300^45
15636  0000          0
15637  7402          HLT

15640  4427          "G-300^45+"T-300+4000   /GTF
15641  0336          "F-300^45
15642  0000          0
15643  6004          6004

15644  4417          "G-300^45+"L-300+4000   /GLK
15645  0627          "K-300^45
15646  0000          0
15647  7204          GLK

15650  4347          "F-300^45+"I-300+4000   /FIXTAB
15651  1614          "X-300^45+"T-300
15652  4047          "A-300^45+"B-300+4000
15653  4103          FIXTBX


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 102



15654  4347          "F-300^45+"I-300+4000   /FIXMRI
15655  1605          "X-300^45+"M-300
15656  5243          "R-300^45+"I-300+4000
15657  0532          FIXMRX

15660  4347          "F-300^45+"I-300+4000   /FIELD
15661  0305          "E-300^45+"L-300
15662  4224          "D-300^45+4000
15663  0420          FIELDX

15664  4321          "E-300^45+"X-300+4000   /EXPUNGE
15665  1145          "P-300^45+"U-300
15666  5015          "N-300^45+"G-300+4000
15667  2476          EXPUNX

15670  4307          "E-300^45+"N-300+4000   /ENPUNCH
15671  1145          "P-300^45+"U-300
15672  5011          "N-300^45+"C-300+4000
15673  0205          ENPUNX

15674  4303          "E-300^45+"J-300+4000   /EJECT
15675  0274          "E-300^45+"C-300
15676  5344          "T-300^45+4000
15677  5050          EJECTX

15700  4231          "D-300^45+"E-300+4000   /DECIMAL
15701  0170          "C-300^45+"I-300
15702  4742          "M-300^45+"A-300+4000
15703  0207          DECIMX

15704  4227          "D-300^45+"C-300+4000   /DCA
15705  4045          "A-300^45+4000
15706  0000          0
15707  3000          DCA 0

15710  4174          "C-300^45+"M-300+4000   /CML
15711  0674          "L-300^45
15712  0000          0
15713  7020          CML

15714  4174          "C-300^45+"M-300+4000   /CMA
15715  0045          "A-300^45
15716  0000          0
15717  7040          CMA

15720  4173          "C-300^45+"L-300+4000   /CLL
15721  0674          "L-300^45
15722  0000          0
15723  7100          CLL


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 103



15724  4173          "C-300^45+"L-300+4000   /CLA
15725  0045          "A-300^45
15726  0000          0
15727  7200          CLA

15730  4170          "C-300^45+"I-300+4000   /CIF
15731  0336          "F-300^45
15732  0000          0
15733  6202          CIF

15734  4170          "C-300^45+"I-300+4000   /CIA
15735  0045          "A-300^45
15736  0000          0
15737  7041          CIA

15740  4163          "C-300^45+"D-300+4000   /CDI
15741  0515          "I-300^45
15742  0000          0
15743  6203          6203

15744  4163          "C-300^45+"D-300+4000   /CDF
15745  0336          "F-300^45
15746  0000          0
15747  6201          CDF

15750  4160          "C-300^45+"A-300+4000   /CAM
15751  0741          "M-300^45
15752  0000          0
15753  7621          7621

15754  4160          "C-300^45+"A-300+4000   /CAF
15755  0336          "F-300^45
15756  0000          0
15757  6007          6007

15760  4135          "B-300^45+"S-300+4000   /BSW
15761  1523          "W-300^45
15762  0000          0
15763  7002          7002

15764  4063          "A-300^45+"N-300+4000   /AND
15765  4224          "D-300^45+4000
15766  0000          0
15767  0000          AND 0

15770  4050          "A-300^45+"C-300+4000   /ACL
15771  0674          "L-300^45
15772  0000          0
15773  7701          7701


/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 104



15774  4001          4001                    /TERMINATOR
15775  0000          0000                    /IMPOSSIBLE (LIMITING) SYMBOL
15776  4000          4000
15777  0000          0000

       6000  SYME=.
                     IFNZRO SYME-6000 <STERR,        WRONG!!!>

             /**********************************************************
             /TOP OF SYMBOL TABLE
             /**********************************************************

/PALC ASSEMBLER FOR CAPS MONITOR          PAL8-V10D NO DATE   PAGE 105



       0000          FIELD   0
       0200          *200            /SELF STARTING ADDRESS



$                                         PAL8-V10D NO DATE   PAGE 106

             $

$                                         PAL8-V10D NO DATE   PAGE 107

ADDBIN 6075      DATCNT 1671      ERROR5 3646      FLD5   2070
ADDPAL 6105      DATE   1531      EXP    3000      FORCHR 3546
ALPHA  2670      DATEWD 7531      EXPIND 0052      FORMFD 1031
ALPHAI 0060      DE     4445      EXPINT 3262      FORMF1 1147
ALPHA1 3200      DECIMX 0207      EXPUA1 1456      FORMF2 1054
ALPHA4 3272      DERR   7103      EXPUA2 1457      FORMF3 1110
ALPHA5 3266      DF     4446      EXPUA4 1462      FORMF4 1113
ALPHA6 3241      DIG    5725      EXPUNU 5230      FORMF5 1123
ASKAGN 2532      DIV45  4047      EXPUNV 1460      FORMF6 0004
BCKVER 6464      DIV45A 4053      EXPUNW 5216      FORMF7 0005
BCLOSW 5350      DIV45B 4072      EXPUNX 2476      FORMF8 5131
BE     4245      DIV45C 4107      EXPUNY 5223      FORMM6 1153
BEGFH  1634      DIV45D 4055      EXPUNZ 1466      FORMSW 3550
BEGIAB 1012      DIV45E 4073      EXPUN2 5231      FORM10 1141
BEGIN  1600      DSWITA 2145      EXPXIT 3433      FORM11 1156
BEGINB 1640      DSWITB 2165      EXP1   3024      FORM12 1121
BEGING 5400      DSWIT1 2131      EXP2   3046      FORM20 1077
BEGIN1 1655      DSWIT2 2146      EXP3   3403      FORM21 1103
BEGIN2 2000      DSWIT3 1674      EXP4   3443      FORM22 1061
BEGN   1630      DSWIT4 1675      FIELDA 2217      FORM30 1065
BEGSKP 1613      DTORG1 1337      FIELDX 0420      FORM70 1154
BINCLO 6521      DUMPS  3664      FIELDY 0436      FORM8F 1155
BINDOT 6200      DUMPS1 3600      FINDS  4447      FUDFLG 5702
BINMSG 5535      DUMPS2 3725      FINDSP 0761      GETBIN 5435
BINOP  7303      DUMPS3 3707      FINDS1 4571      GETBUF 7261
BLSIZE 0200      DUMPS4 3723      FINDS2 4572      GETC   0605
BPA    5334      DUMPZ  3725      FINDS3 4573      GETCHR 7272
BSIZE  7000      ECOIN  6115      FINDS4 4501      GETCI  0061
BSLOT  7237      EDITPG 0037      FINDS5 4551      GETC1  0632
BVERNO 7427      EJECTX 5050      FINDS6 4511      GETC10 0677
CALL   4400      EJECT1 5054      FINDS7 4534      GETC12 0710
CEXIT  6440      EJECT2 5061      FINDS8 4532      GETC13 0716
CHAR   0035      EJECT3 5106      FINDS9 4544      GETC15 0721
CHKSUM 0053      EJECT4 5076      FINDTG 4132      GETC16 0704
CHRIN  6024      EJECT5 5100      FIND0  4556      GETC17 0706
CLBIN  5451      EJECT6 5071      FIND01 4562      GETC2  0631
CLEAN  3646      EJECT7 5023      FIND02 4463      GETC4  0647
CLIN   5431      EJECT8 0012      FIND03 4522      GETC6  0637
CLLIST 5513      ENDCHK 3056      FIXMRX 0532      GETC7  0607
CLOSE  6400      ENDCH1 3100      FIXMR1 0544      GETC8  0657
CNAME  7107      ENDPAS 4223      FIXMR2 0556      GETC9  0711
CNM2   7117      ENDPA1 4242      FIXMR3 0571      GETFLE 7260
CNT    0072      ENDPA2 4260      FIXTAX 5204      GETIN  5406
COMMA  2720      ENPUNX 0205      FIXTAY 5200      GETLIN 6000
COMMA1 2726      ENTER  6404      FIXTBX 4103      GETLST 5457
COMMA2 2737      EQUAL  0466      FIX1   3315      GETNAM 5737
CONDSW 0051      EQUAL2 0526      FIX2   3334      GETTAG 0212
CONDTM 4700      EQUAL3 0471      FIX3   3355      GETTA1 0233
CONEND 2636      ERET   7013      FIX4   3337      GETTA2 0203
CONEN1 2643      ERR    7040      FIX5   3352      GETTA3 0324
CRCK   5666      ERROR  3600      FLDIND 0067      GETTA4 0352
CRLF   1157      ERROR1 3744      FLD1   2022      GETTG1 0221
CRLFA  6210      ERROR2 3641      FLD2   2050      GETTG2 0244
CRLFR  7041      ERROR3 3626      FLD3   2053      GETTG3 0312
CRLF1  1162      ERROR4 3636      FLD4   2072      GETTG4 0246

$                                         PAL8-V10D NO DATE   PAGE 107-1

GETTG5 4011      KBDIN  7602      MAIN1  2611      OTYPE1 5023
GETTG7 4045      KIN    7003      MFNME  6133      OUBPTR 6674
GETTG8 4016      KNT    0071      MNTIT  6421      OUPTR  6661
GETTG9 4032      LAST1  0014      MONERR 0753      OUTEM  5137
GLINE  6003      LAST2  0015      MONER1 0757      OUTINH 6647
HANDLE 6600      LAST3  0016      MONWT  4247      OUTPT1 6600
HDSIZE 0040      LAST4  0017      MOTSIN 5254      OUTPT2 6662
HEADER 1456      LBUFR  2073      MOUNT  2513      OUTPT3 6625
HEDCLR 1361      LEADER 0007      MOUNTM 7031      OUTPUT 6601
HEDCL1 1330      LET    5713      MPARAM 7400      OUTPUX 6635
HEDCL2 1270      LINBUF 1614      NAME1  0200      OUWDCT 6663
HIGHTG 0056      LINCNT 0057      NAME2  0201      OUWRT  6664
HOLE   5516      LININD 0065      NAME3  0202      PAGEX  0441
HSWITC 1035      LINKSW 0064      NOPUNX 0204      PAGEY  0451
HSWIT1 1013      LINPRT 0740      NORMRT 5700      PALDOT 6204
HSWIT2 1244      LINPR1 0743      NSWITC 4334      PARM1  1672
IBUFR  5400      LINPR2 0750      NUMBER 3102      PARM2  1673
IC     5143      LISCNT 1030      NUMBE1 3131      PASS   0047
ICHAR  0045      LISOUT 1000      NUMBE2 3103      PAUSEX 0362
ID     5144      LISOU1 1015      NUMBE3 3140      PDLND  1551
IE     5145      LISOU2 0006      NUMBE4 3125      PDLST  1613
IFD    4651      LISOU3 1024      NXTFLE 6412      PDLXR  0010
IFND   4652      LITBF1 2200      OBUFR  6000      PE     6045
IFN0   4601      LITBF2 2017      OCHAR  0044      PERIOD 3143
IFSZA  4641      LITBUF 1736      OCLOSE 6707      PERROR 0066
IFTST1 4626      LITPTR 0023      OCTALX 0210      PERRO1 5126
IFTST2 4616      LITS   4400      OCTPRT 1310      PH     6050
IFTST3 4605      LITS1  4446      OCTPR1 1270      PHASE  0752
IFTST4 4647      LITZ   4401      OCTPR2 1314      POPJ   2235
IFTST5 4630      LOC    0027      OCTPR3 1361      PTR    0070
IFTST6 4644      LOOKEX 2631      OERROR 0046      PTR1   7133
IFTST7 4655      LOOKE1 2610      ONEOK  1430      PTR2   7134
IFTST8 4667      LOOKE2 2600      ONOFIL 5342      PUNBIN 1400
IFTST9 4614      LOOKUP 7002      OOPLP  5314      PUNCHX 0025
IF0    4600      LPBUFR 7731      OP     0030      PUNFLD 2226
II     5151      LPCHCT 7406      OPTABL 3553      PUNFL1 2234
IINIT  7066      LPLPLP 7011      OPTIMA 2101      PUNMOD 1442
ILCHAR 2633      LPOCHR 7400      OPTIMB 2110      PUNONE 1330
INBUFP 7056      LPSIZ  7414      OPTIM1 2073      PUNON1 1351
INCHCT 7300      LPSIZE 0002      OPTIM2 2074      PUNON2 1355
INEOF  7302      LPT    5707      OPTIM3 2075      PUNORG 2502
INERRX 7061      LSLOT  7251      OPTIM4 2033      PUNOUT 5231
INMSG  5517      LSPOT  6435      OPTIM5 2076      PUNOU1 5245
INPTR  7301      LSTCHR 3532      OPTIM6 2077      PUNVAL 5110
INPUT  7253      LSTCH1 3543      OPTIM7 2100      PUNVA1 5000
INSRTG 4000      LSTCH2 3506      OPTIM8 2041      PUSHA  4715
INTWT  7006      LSTCH3 3523      OP0    3400      PUSHA1 3551
IOMON  0050      LSTCH4 3517      OP1    5134      PUTTAG 4700
IOPEN  6400      LSTCH5 3527      OP2    3453      P3O    6651
IP     5160      LSTCH6 3530      OP4    3456      P3OF   6656
IPTR   0074      LSTCH7 3531      OP5    2747      P3OT   6660
ISLOTS 7200      LSTCH9 3465      OP6    5005      QUOTE  2707
IZ     5172      LSTCNT 0062      OP6A   5012      QUOTE1 3146
IZIND  0054      LSTMSG 6213      OP6B   5020      RADIX  0024
KBDCHR 7626      MAIN   2611      OTYPEO 3362      RD     6244

$                                         PAL8-V10D NO DATE   PAGE 107-2

RDERR  7076      TEXT8  2433      
READ   7043      TEXT9  2435      
ROR    6042      THISPG 0036      
RTL6   0600      THISTG 0055      
SCNLIN 5600      TNXT   7020      
SE     6345      TOEXP  2624      
SETFLD 4107      TOUT   7000      
SETFLP 4113      TPINST 1776      
SETFL1 4130      TSTALN 4746      
SETFL2 4145      TSTALP 4755      
SINCH  7403      TSTAL1 4764      
SPNOR  0353      TSTNUM 4734      
SPTR   0073      TSTNU1 4743      
SSWITC 4243      TTBUFR 7734      
STAR   2645      TTCHCT 7413      
START1 5246      TTOCHR 7402      
START2 4200      TTSIZ  7410      
STAR1  0456      TTSIZE 0030      
STAR2  4147      TTTT   5035      
STCHAR 5745      TTY    5703      
ST1ST2 5347      TXTPTR 0034      
SYME   6000      TXTSWT 0033      
SYMPPB 0053      UNDFSW 0063      
SYMPPP 1270      UNIT   0075      
SYMPRT 1200      UO     6557      
SYMPR0 1256      UPC    7331      
SYMPR2 0064      US     6563      
SYMPR3 0063      UTIL   7200      
SYMPR4 1253      VALUE  0031      
SYMPR5 1213      VALUE2 0032      
SYMPR6 1217      VERSIO 0002      
SYMPR7 0060      WAIT   6200      
SYMPR8 1205      WPTR   7030      
SYMPR9 1240      WRTERR 7100      
SYMS   5160      WRTMSG 7014      
SYM245 1272      XLISTX 0026      
SYNERR 5674      XLISTY 5036      
TAGMAX 4044      XLISTZ 5114      
TAGXR  0011      XLIST1 5044      
TAG1   0020      XLIST2 5042      
TAG2   0021      XREG1  0012      
TAG3   0022      XREG2  0013      
TEMP   0040      ZBLOCX 0400      
TEMP1  0041      ZBLOCY 0407      
TEMP2  0042      ZCOL   6055      
TEMP3  0043      ZE     7245      
TEXTX  2400      ZOTDIG 6023      
TEXT1  2440      ZOTLIN 6037      
TEXT1A 2450      
TEXT2  2460      
TEXT3  2413      
TEXT4  2424      
TEXT5  2467      
TEXT6  2474      
TEXT7  2475      



ERRORS DETECTED: 0
LINKS GENERATED: 114



