/**********************************************************************
* File: clib.c
* File $Revision: 3.1 $
* $Date: 1991/01/21 16:28:33 $
*	Copyright (C) 1989 by Applied Microsystems Corp.
*
* DESC:	Universal Sales Demon Program C Functions Library
***********************************************************************
**                   Include Header Information                      **
**********************************************************************/

#include "cdemon.h"

/**********************************************************************
**                    Cdemon Function Library                        **
***********************************************************************
**    ror(data,n) - Rotate Right Function
**
**    This function rotates an 8 bit variable to the right by
** the value specified by "n".  This rotation is a ring type
** shift in which the LSB is shifted into the MSB. See example;
**
**                    ,--> 0000 1111 >--,
**                    |  MSB       LSB  |
**                    `-----------------'
*/
ror(data,n)                
int data,n;
    {
    return (( data << (8-n)) | ( data >> n ) & 0x00FF );
    }

/*********************************************************************
**     rol(data,n) - Rotate Left Function 
**
**      This function rotates an 8 bit variable to the left by
**  the value specified by "n".  This rotation is a ring type
**  shift in which the MSB is shifted into the LSB. See example;
**
**                    ,--< 0000 1111 <--,
**                    |  MSB       LSB  |
**                    `-----------------'
*/
rol(data,n)
int data,n;
    {
    return (( data >> (8-n)) | ( data << n ) & 0x00FF );
    }

/*********************************************************************
**
**  strcpy(dst,src) - Copy string src to dst location
**
**      This function copies ascii strings pointed to by src to the
**  location indicated by the pointer dst.  The null terminator at
**  the end of the source strings cancels the while loop when read
**  and the function returns.
*/
strcpy(dst,src)
    char *dst,
    *src;
    {
    while (*dst++ = *src++)
	; 
    }

/*********************************************************************
**                         End of Library                           **
*********************************************************************/
