/**********************************************************************
* File: com.c
* File $Revision: 3.1 $
* $Date: 1991/01/21 16:28:34 $
*	Copyright (C) 1989 by Applied Microsystems Corp.
*
* DESC:	Universal Sales Demon Program Com Functions Library
***********************************************************************
**                   Include header information                      **
**********************************************************************/

#include "cdemon.h"

/**********************************************************************
**                          Com Port Data                            **
**********************************************************************/

extern struct com_port      /* com port layout */
    {
    BYTE write_data,        /* TARGET -> EMUALTOR */
          read_data;        /* EMUALTOR -> TARGET */
    } com;

/**********************************************************************
**                        Com Port Functions                         **
***********************************************************************
**
**  wait(fine,coarse) - Wait according to fine and coarse settings
**
**      This function forms a delay by counting down the values passed
**  in the variables fine and coarse.  The variable fine is decremented
**  and checked for greater than zero then the wait function is called
**  again until fine goes below zero.  Coarse is decremented in a while
**  loop and checked for zero in each call to wait.
*/
wait(fine,coarse)
    int fine,
    coarse;
    {
    extern char led_port[18];
    static int i;

    if (--fine) wait(fine,coarse);	/* recursive call */
    if (getcom() == '?') printcom("\n\r  LEDS COM PORT\n\r"); /* answer ? */
    while (coarse--)			/* with above string */
        {
        if ((i >= 0) && (i < 17))
	    {
            if (putcom(led_port[i])) i++;
	    }
        else
	    {
	    if (putcom('\r')) i = 0;
	    }
	}
    }

/*********************************************************************
**
**	getcom()  - Get character from the com port
**
**      This function reads a character from the com port.  If ready,
**  the ready bit is reset, the data is read and returned.  Otherwise a
**  zero or false is returned.
**
**             read_data:  7 6543210
**                         ^    ^---- data bits ( 7 bit ascii value )
**                         `--------- ready bit ( 0 = clear, 1 = ready )
*/
getcom()
    {
    extern	struct com_port com;
    BYTE c;

    if ((com.read_data & STATUS) == READY)
	{
        c = com.read_data & DATA;       /* get data and mask off status */
        com.read_data = CLEAR;          /* clear data and status */
        return c;                       /* return with data character */
	}
    else
	return 0;                       /* not ready */
    }

/*********************************************************************
**
** putcom(c) - Put a character out the com port
**
**	This function writes a character out the com port.  If the ready
**  bit is clear then the character is written with the ready bit set
**  and the character is returned.  If not ready, then a zero or false
**  is returned.
**
**            write_data:  7 6543210
**                         ^    ^---- data bits ( 7 bit ascii value )
**                         `--------- ready bit ( 0 = clear, 1 = ready )
*/
putcom(c)
    BYTE c;
    {
    extern struct com_port com;

    if ((com.write_data & STATUS) == CLEAR)
	{
        com.write_data = (c | READY);   /* put data with status = ready */
	return c;                       /* return success */
	}
    else
	return 0;                       /* not clear */
    }

/*********************************************************************
**
** printcom(p) - Print ascii strings out com port
**
**      This function outputs ascii character strings until terminated by
**  a null character.  An initialized pointer to the ascii text should
**  be passed as a character pointer.  The actual characters are output
**  using putcom() library call.
*/
printcom(p)
char *p;
    {
    char c;

    while ((c = *p++) != '\0')    /* do until null */
        {
        while (!(putcom(c)));     /* write to EMUALTOR (monitor) */
        }
    }

/*********************************************************************
**                             End of Com                           **
*********************************************************************/

