cseg	segment para public 'code'
org	100h
userexit proc far

	; This program is an example of a memory-resident routine that is
	; used to contain user breakpoints and user exits from Periscope.
	; This program is attached to an unused interrupt vector so that it
	; can be called from Periscope. The allowable range of vectors is
	; 60H to FFH. This routine must be loaded into memory before Periscope
	; is run. When PS.COM is run, be sure to specify the '/I:nn' parameter,
	; where nn is the interrupt vector.

	; On entry, register AH contains a function number set by Periscope. For
	; the user breakpoints, (BU 1 through 8), AH will be from 1 to 8. For
	; the user exits (/U nn), AH will be from 9 to FFH.

	; On entry, DS:SI points to a table containing the current program's
	; register values. The values available are as follows:
	;
	; [SI+00H] -- AX	[SI+02H] -- BX		[SI+04H] -- CX
	; [SI+06H] -- DX	[SI+08H] -- SP		[SI+0AH] -- BP
	; [SI+0CH] -- SI	[SI+0EH] -- DI		[SI+10H] -- DS
	; [SI+12H] -- ES	[SI+14H] -- SS		[SI+16H] -- CS
	; [SI+18H] -- IP	[SI+1AH] -- FLAGS
	; [SI+1CH] -- Segment of address entered on user exit command line
	; [SI+1EH] -- Offset of address entered on user exit command line
	; [SI+20H] through [SI+6DH] -- Last Periscope command, terminated w/ CR

	; On return from a USER BREAKPOINT, AL indicates whether or not the
	; routine got a 'hit'. If AL=1, then Periscope assumes a hit and stops.
	; Any other value is assumed not to be a hit and Periscope continues
	; the GT command, unless another breakpoint (e.g. BW) is taken.

	; On return from a USER EXIT, AL indicates whether the exit code has
	; set a command to be executed by Periscope. If AL=2, Periscope reads
	; the command line passed back from the user exit. The command line
	; must start with a semi-colon and end with a carriage return.

	; The values of registers other than AX, SI, and DS on entry to the
	; program are undefined.

	; If your code will require more than 32 words of stack space, you
	; should switch to your own internal stack. Be sure that Periscope's
	; original stack is in place before returning to Periscope. All other
	; registers may be modified as needed.

	assume cs:cseg,ds:cseg,ss:nothing,es:nothing

start:	jmp transient		; go to start-up code

intno	equ 60h 		; use interrupt 60h

signature db 'P','S'            ; signature required by PS.COM - must be just
				; before interrupt entry point!!!

resident:			; interrupt entry point
				; choose function based on value in ah

	cmp ah,1		; ah=1?
	jz func1		; yes

	cmp ah,9		; ah=9?
	jz func9		; yes

	cmp ah,87h		; ah=87h?
	jz func87

exit:	iret			; return to Periscope

indos	dd 0			; pointer to in-dos flag

func1:				; function 1
	; This is an example of a user breakpoint to check for dos availability.
	; It is invoked by specifying 'BU 1' and then using 'GT'.

	les di,cs:indos 	; get pointer to in-dos flag
	cmp byte ptr es:[di],0	; dos avail?
	jnz exit1		; no

	test word ptr [si+26],0200h ; interrupts enabled?
	jz exit1		; no

	mov al,1		; yes - it's a hit

exit1:	jmp exit

commline  db ';dd 0:0',0dh      ; ps command line - must start with a semi-colon
				; and end with a carriage return

commlen equ 8			; length of command line

func9:				; function 9
	; This is an example of a user exit that stuffs a command into
	; Periscope's command line.

	mov di,si
	add di,20h		; point to ps command line
	push ds
	pop es			; es:di point to ps command line

	push cs
	pop ds
	mov si,offset commline	; ds:si point to new command

	mov cx,commlen		; length must be <= 78 bytes!
	rep movsb		; copy command

	mov al,2		; indicate that this is a command

exit9:	jmp exit

func87: 			; function 87 - display 8087/80287 status
	push cs
	pop ds			; ds=cs
	push ds
	pop es			; es=ds
	call p330		; clear output line

	wait			; wait for 8087
;;	fstenv npdcrtl		; save ndp environment
	db 0d9h,036h
	dw offset ndpctrl

	wait			; wait for 8087
;;	fldenv ndpctrl		; restore it
	db 0d9h,026h
	dw offset ndpctrl

	call p200		; display control info
	call p210		; display status line
	call p220		; display ip, opcode, and dp
	call p230		; display tag words

exit87: jmp exit

	; control word equates
nbic	equ 1000h		; ic - bit 12
nbrc	equ 0c00h		; rc - bits 10,11
nbpc	equ 0300h		; pc - bits 8,9
nbpm	equ 0020h		; pm - bit 5
nbum	equ 0010h		; um - bit 4
nbom	equ 0008h		; om - bit 3
nbzm	equ 0004h		; zm - bit 2
nbdm	equ 0002h		; dm - bit 1
nbim	equ 0001h		; im - bit 0

	; status word equates
nbby	equ 8000h		; busy
nbc3	equ 4000h		; cond code 3
nbtop	equ 3800h		; top of stack
nbc2	equ 0400h		; cond code 2
nbc1	equ 0200h		; cond code 1
nbc0	equ 0100h		; cond code 0
nbes	equ 0080h		; err status

	; control word text
ndpc1	db 'Ctrl: Infin=',0
ndpc2	db '  Round=',0
ndpc3	db '  Prec=',0
ndpc4	db '  Flags=',0

	; status word text
ndps1	db 'Stat: Cond=',0
ndps2	db '   Stacktop=',0

	; misc text
ndpip	db 'IP=',0
ndpop	db 'Opcode=',0
ndpdp	db 'DP=',0
ndptag	db 'Tag: ',0
ndpflags db 'PrecUndrOverZeroDen Inv ' ; possible flags
ndpbusy db 'Busy'
ndperr	db 'Err '
ndpinf0 db 'Proj'
ndpinf1 db 'Aff '
ndprnd	db 'NearDownUp  Chop'   ; round types
ndpprec db 'Short?????Long Temp ' ; precision types
ndptval db 'ValidZero InfinEmpty' ; tag values

	; ndp save area
ndpctrl dw 0			; save area - control word
ndpstat dw 0			; status word
ndptagw dw 0			; tag word
ndpip1	dw 0			; inst ptr 1
ndpip2	dw 0			; inst ptr 2
ndpdp1	dw 0			; data ptr 1
ndpdp2	dw 0			; data ptr 2

outline db 80 dup(' ')          ; output work line


p200	proc near		; display control info
	mov ax,ndpctrl
	mov si,offset ndpc1
	call p300		; copy control header
	mov si,offset ndpinf0	; assume projective
	test ax,nbic		; proj?
	jz p201 		; yes

	mov si,offset ndpinf1	; no

p201:	movsw			; copy infinity type
	movsw

	mov si,offset ndpc2
	call p300		; copy round header
	mov si,offset ndprnd	; assume near

	mov bx,ax		; get word in bx
	and bx,nbrc		; clear other bits
	xchg bh,bl		; times four as is
	add si,bx
	movsw			; copy round type
	movsw

	mov si,offset ndpc3
	call p300		; copy precision header
	mov si,offset ndpprec
	mov bx,ax
	and bx,nbpc
	xchg bh,bl
	mov cx,bx
	shl bx,1		; times 2
	shl bx,1		; times 4
	add bx,cx		; times 5
	add si,bx
	movsw			; copy precision type
	movsw
	movsb

	call p320		; display flags
	call p340		; print line
	ret
p200	endp

p210	proc near		; display status info
	mov ax,ndpstat
	mov si,offset ndps1
	call p300		; copy status header
	test ax,nbc3		; cc3 on?
	call p310		; print result
	test ax,nbc2		; cc2 on?
	call p310
	test ax,nbc1
	call p310
	test ax,nbc0
	call p310

	mov si,offset ndps2
	call p300		; copy stacktop header
	mov bx,ax
	and bx,nbtop
	shr bx,1
	shr bx,1
	shr bx,1		; in bh
	add bh,'0'              ; make ascii
	mov [di],bh
	inc di
	inc di
	inc di

	test ax,nbby		; busy?
	jnz p211		; yes

	add di,4		; no
	jmp short p212

p211:	mov si,offset ndpbusy
	movsw
	movsw

p212:	inc di
	inc di

	test ax,nbes		; error?
	jnz p213		; yes

	inc di
	inc di
	inc di
	jmp short p214

p213:	mov si,offset ndperr
	movsw
	movsb

p214:	inc di
	call p320		; display flags
	call p340		; display line
	ret
p210	endp

p220	proc near		; display ip, opcode, and dp
	mov si,offset ndpip
	call p300		; copy ip header
	mov ax,ndpip2		; get ip
	mov cx,4
	rol ax,cl		; address in low 4 bits
	call p350		; display nibble
	mov ax,ndpip1		; get lower part of ip
	call p360		; display word

	mov si,offset ndpop
	call p300		; copy opcode header
	mov ax,ndpip2
	and ax,07ffh		; clear out ip part
	or ax,0d800h		; make it an esc instruction
	call p360		; display word

	mov si,offset ndpdp
	call p300		; copy dp header
	mov ax,ndpdp2		; get dp
	mov cx,4
	rol ax,cl		; address in low 4 bits
	call p350		; display nibble
	mov ax,ndpdp1		; get lower part of dp
	call p360		; display word

	call p340		; display line
	ret
p220	endp

p230	proc near		; display tag word
	mov si,offset ndptag
	call p300		; copy tag header
	mov ax,ndptagw		; get tag word
	mov cx,8

p231:	rol ax,1
	rol ax,1		; get next tag word
	push ax
	and ax,3
	mov bx,ax
	shl ax,1
	shl ax,1
	add bx,ax		; times five
	mov si,offset ndptval	; point to tag values
	add si,bx
	movsw
	movsw
	movsb			; copy to output
	inc di
	inc di			; two spaces
	pop ax
	loop p231

	call p340		; display line
	ret
p230	endp

p300	proc near		; copy to output line
	push ax

p301:	lodsb			; get byte
	cmp al,0		; end?
	jz p305 		; yes

	stosb			; no - save it
	jmp p301		; continue

p305:	pop ax
	ret
p300	endp

p310	proc near		; print 0 if zr, else 1
	mov bl,'0'
	jz p315

	mov bl,'1'

p315:	mov [di],bl
	inc di
	ret
p310	endp

p320	proc near		; display flags
	mov si,offset ndpc4
	call p300		; copy flags header
	mov si,offset ndpflags
	mov bx,nbpm		; start w/ pm
	mov cx,6		; six flags

p321:	test ax,bx		; bit on?
	jnz p322		; yes

	add si,4		; next name
	add di,4
	jmp short p323

p322:	movsw			; yes - copy it
	movsw

p323:	inc di			; skip one
	shr bx,1		; next test
	loop p321
	ret

p320	endp

p330	proc near		; clear output line
	mov di,offset outline
	push di
	mov cx,80/2		; length
	mov ax,'  '             ; spaces
	rep stosw		; init to spaces
	pop di
	ret
p330	endp

p340	proc near		; print output line
	mov cx,80		; length
	mov si,offset outline

p345:	mov ah,14		; bios tty output
	lodsb			; get char
	int 10h 		; display char
	loop p345		; done?

	call p330		; yes - clear line
	ret
p340	endp

p350	proc near		; display nibble
	push ax
	and ax,0fh
	cmp ax,9		; 0 to 9?
	ja p351 		; no - a to f

	add ax,'0'              ; convert to ascii
	jmp short p352

p351:	add ax,55		; a - f

p352:	stosb			; save byte
	pop ax
	ret
p350	endp

p360	proc near		; display word
	mov bx,4		; counter

p361:	rol ax,cl		; move to low nibble
	call p350		; display it
	dec bx
	jnz p361		; not done

	inc di
	inc di			; two spaces
	ret
p360	endp


transient:			; end of resident code and
				; start of transient code

	mov ah,34h		; set in-dos pointer
	int 21h
	mov si,offset indos
	mov [si],bx		; save offset
	mov [si+2],es		; and segment for user breakpoint 1

	xor ax,ax
	mov es,ax
	mov di,intno		; get int number
	shl di,1
	shl di,1		; times 4

	cli			; no interrupts
	mov ax,offset resident	; point interrupt to resident code
	stosw			; set offset
	mov ax,ds
	stosw			; and segment
	sti			; interrupts back on

	mov dx,offset transient
	int 27h 		; stay resident

userexit endp
cseg	ends
end	userexit
